/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.core.Tuple;

public final class DiffableUtils {
    private static final MapDiff<?, ?, ?> EMPTY = new MapDiff<Object, Object, Map<Object, Object>>(null, null, List.of(), List.of(), List.of(), null){

        @Override
        public Map<Object, Object> apply(Map<Object, Object> part) {
            return part;
        }
    };

    private DiffableUtils() {
    }

    public static KeySerializer<String> getStringKeySerializer() {
        return StringKeySerializer.INSTANCE;
    }

    public static KeySerializer<Integer> getIntKeySerializer() {
        return IntKeySerializer.INSTANCE;
    }

    public static <W extends Writeable> KeySerializer<W> getWriteableKeySerializer(Writeable.Reader<W> reader) {
        return new WriteableKeySerializer<W>(reader);
    }

    public static <K, T extends Diffable<T>, M extends Map<K, T>> MapDiff<K, T, M> diff(M before, M after, KeySerializer<K> keySerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : DiffableUtils.createDiff(before, after, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> diff(M before, M after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        return before.equals(after) ? DiffableUtils.emptyDiff() : DiffableUtils.createDiff(before, after, keySerializer, valueSerializer);
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> emptyDiff() {
        return EMPTY;
    }

    public static <K, T extends Diffable<T>, T1 extends T, T2 extends T, M extends Map<K, T>> MapDiff<K, T, M> merge(MapDiff<K, T1, ? extends ImmutableOpenMap<K, T1>> diff1, MapDiff<K, T2, ? extends ImmutableOpenMap<K, T2>> diff2, KeySerializer<K> keySerializer) {
        return DiffableUtils.merge(diff1, diff2, keySerializer, DiffableValueSerializer.getWriteOnlyInstance());
    }

    public static <K, T, T1 extends T, T2 extends T, M extends Map<K, T>> MapDiff<K, T, M> merge(MapDiff<K, T1, ? extends ImmutableOpenMap<K, T1>> diff1, MapDiff<K, T2, ? extends ImmutableOpenMap<K, T2>> diff2, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        List<K> deletes = CollectionUtils.concatLists(diff1.getDeletes(), diff2.getDeletes());
        List diffs = Stream.concat(DiffableUtils.mapEntries(diff1.getDiffs(), diff -> diff), DiffableUtils.mapEntries(diff2.getDiffs(), diff -> diff)).toList();
        List upserts = Stream.concat(DiffableUtils.mapEntries(diff1.getUpserts(), val -> val), DiffableUtils.mapEntries(diff2.getUpserts(), val -> val)).toList();
        return new MapDiff<K, T, Map>(keySerializer, valueSerializer, deletes, diffs, upserts, DiffableUtils::createImmutableMapBuilder);
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> removeKeys(MapDiff<K, T, M> diff, Set<K> keys) {
        List<Object> deletes = diff.getDeletes().stream().filter(k -> !keys.contains(k)).toList();
        List diffs = diff.getDiffs().stream().filter(entry -> !keys.contains(entry.getKey())).toList();
        List upserts = diff.getUpserts().stream().filter(entry -> !keys.contains(entry.getKey())).toList();
        return new MapDiff(diff.keySerializer, diff.valueSerializer, deletes, diffs, upserts, diff.builderCtor);
    }

    public static <K, T, M extends Map<K, T>> boolean hasKey(MapDiff<K, T, M> diff, K key) {
        if (diff.getDeletes().contains(key)) {
            return true;
        }
        if (diff.getDiffs().stream().map(Map.Entry::getKey).anyMatch(k -> Objects.equals(k, key))) {
            return true;
        }
        return diff.getUpserts().stream().map(Map.Entry::getKey).anyMatch(k -> Objects.equals(k, key));
    }

    public static <K, T, M extends Map<K, T>> MapDiff<K, T, M> updateDiffsAndUpserts(MapDiff<K, T, M> diff, Predicate<K> keyPredicate, BiFunction<K, Diff<T>, Diff<T>> diffUpdateFunction, BiFunction<K, T, T> upsertUpdateFunction) {
        List newDiffs = diff.getDiffs().stream().map(entry -> {
            if (!keyPredicate.test(entry.getKey())) {
                return entry;
            }
            return Map.entry(entry.getKey(), (Diff)diffUpdateFunction.apply(entry.getKey(), (Diff)entry.getValue()));
        }).toList();
        List newUpserts = diff.getUpserts().stream().map(entry -> {
            if (!keyPredicate.test(entry.getKey())) {
                return entry;
            }
            return Map.entry(entry.getKey(), upsertUpdateFunction.apply(entry.getKey(), entry.getValue()));
        }).toList();
        return new MapDiff(diff.keySerializer, diff.valueSerializer, diff.deletes, newDiffs, newUpserts, diff.builderCtor);
    }

    public static <K1, K2, T extends Diffable<T>, M1 extends Map<K1, T>> MapDiff<K2, T, Map<K2, T>> jdkMapDiffWithUpdatedKeys(MapDiff<K1, T, M1> diff, Function<K1, K2> keyFunction, KeySerializer<K2> keySerializer) {
        List<K2> deletes = diff.getDeletes().stream().map(keyFunction).toList();
        List diffs = diff.getDiffs().stream().map(entry -> Map.entry(keyFunction.apply(entry.getKey()), (Diff)entry.getValue())).toList();
        List upserts = diff.getUpserts().stream().map(entry -> Map.entry(keyFunction.apply(entry.getKey()), (Diffable)entry.getValue())).toList();
        return new MapDiff(keySerializer, DiffableValueSerializer.getWriteOnlyInstance(), deletes, diffs, upserts, JdkMapBuilder::new);
    }

    public static <K, T extends Diffable<T>, M extends Map<K, T>> MapDiff<K, T, M> singleEntryDiff(K key, Diff<T> diff, KeySerializer<K> keySerializer) {
        return new MapDiff(keySerializer, DiffableValueSerializer.getWriteOnlyInstance(), List.of(), List.of(Map.entry(key, diff)), List.of(), DiffableUtils::createJdkMapBuilder);
    }

    public static <K, T extends Diffable<T>, M extends Map<K, T>> MapDiff<K, T, M> singleDeleteDiff(K key, KeySerializer<K> keySerializer) {
        return new MapDiff(keySerializer, DiffableValueSerializer.getWriteOnlyInstance(), List.of(key), List.of(), List.of(), DiffableUtils::createJdkMapBuilder);
    }

    public static <K, T extends Diffable<T>, M extends Map<K, T>> MapDiff<K, T, M> singleUpsertDiff(K key, T entry, KeySerializer<K> keySerializer) {
        return new MapDiff(keySerializer, DiffableValueSerializer.getWriteOnlyInstance(), List.of(), List.of(), List.of(Map.entry(key, entry)), DiffableUtils::createJdkMapBuilder);
    }

    private static <K, F, T> Stream<Map.Entry<K, T>> mapEntries(List<Map.Entry<K, F>> source, Function<F, T> fn) {
        return source.stream().map(e -> Map.entry(e.getKey(), fn.apply(e.getValue())));
    }

    public static <K, T, T1 extends T, T2 extends T> Tuple<MapDiff<K, T1, ImmutableOpenMap<K, T1>>, MapDiff<K, T2, ImmutableOpenMap<K, T2>>> split(MapDiff<K, T, ? extends Map<K, T>> diff, Predicate<K> keysT1, ValueSerializer<K, T1> serializer1, Predicate<K> keysT2, ValueSerializer<K, T2> serializer2) {
        ArrayList deletes1 = new ArrayList();
        ArrayList deletes2 = new ArrayList();
        DiffableUtils.split(diff.getDeletes(), Function.identity(), keysT1, deletes1::add, keysT2, deletes2::add);
        ArrayList diffs1 = new ArrayList();
        ArrayList diffs2 = new ArrayList();
        DiffableUtils.split(diff.getDiffs(), e -> e.getKey(), keysT1, e -> diffs1.add(Map.entry(e.getKey(), (Diff)e.getValue())), keysT2, e -> diffs2.add(Map.entry(e.getKey(), (Diff)e.getValue())));
        ArrayList upserts1 = new ArrayList();
        ArrayList upserts2 = new ArrayList();
        DiffableUtils.split(diff.getUpserts(), e -> e.getKey(), keysT1, e -> upserts1.add(Map.entry(e.getKey(), e.getValue())), keysT2, e -> upserts2.add(Map.entry(e.getKey(), e.getValue())));
        return Tuple.tuple(new MapDiff(diff.keySerializer, serializer1, deletes1, diffs1, upserts1, DiffableUtils::createImmutableMapBuilder), new MapDiff(diff.keySerializer, serializer2, deletes2, diffs2, upserts2, DiffableUtils::createImmutableMapBuilder));
    }

    private static <K, E> void split(List<E> source, Function<E, K> getKey, Predicate<K> keys1, Consumer<E> dest1, Predicate<K> keys2, Consumer<E> dest2) {
        for (E e : source) {
            K k = getKey.apply(e);
            if (keys1.test(k)) {
                dest1.accept(e);
                continue;
            }
            if (keys2.test(k)) {
                dest2.accept(e);
                continue;
            }
            throw new IllegalStateException("Found diff key [" + String.valueOf(k) + "] which does not match [" + String.valueOf(keys1) + "] nor [" + String.valueOf(keys2) + "]");
        }
    }

    public static <K, T> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, ImmutableOpenMap>(in, keySerializer, valueSerializer, ImmutableOpenMapBuilder::new));
    }

    public static <K, T> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, Map>(in, keySerializer, valueSerializer, JdkMapBuilder::new));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, ImmutableOpenMap<K, T>> readImmutableOpenMapDiff(StreamInput in, KeySerializer<K> keySerializer, DiffableValueReader<K, T> diffableValueReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, ImmutableOpenMap>(in, keySerializer, diffableValueReader, ImmutableOpenMapBuilder::new));
    }

    public static <K, T extends Diffable<T>> MapDiff<K, T, Map<K, T>> readJdkMapDiff(StreamInput in, KeySerializer<K> keySerializer, Writeable.Reader<T> reader, Writeable.Reader<Diff<T>> diffReader) throws IOException {
        return DiffableUtils.diffOrEmpty(new MapDiff<K, T, Map>(in, keySerializer, new DiffableValueReader(reader, diffReader), JdkMapBuilder::new));
    }

    private static <K, T, M extends Map<K, T>> MapDiff<K, T, M> diffOrEmpty(MapDiff<K, T, M> diff) {
        if (diff.getUpserts().isEmpty() && diff.getDiffs().isEmpty() && diff.getDeletes().isEmpty()) {
            return DiffableUtils.emptyDiff();
        }
        return diff;
    }

    private static <K, T, M extends Map<K, T>> MapDiff<K, T, M> createDiff(M before, M after, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer) {
        assert (after != null && before != null);
        int inserts = 0;
        ArrayList upserts = new ArrayList();
        ArrayList diffs = new ArrayList();
        for (Map.Entry<K, T> entry : after.entrySet()) {
            Object previousValue = before.get(entry.getKey());
            if (previousValue == null) {
                upserts.add(entry);
                ++inserts;
                continue;
            }
            if (entry.getValue().equals(previousValue)) continue;
            if (valueSerializer.supportsDiffableValues()) {
                diffs.add(new AbstractMap.SimpleImmutableEntry<K, Diff<Object>>(entry.getKey(), valueSerializer.diff(entry.getValue(), previousValue)));
                continue;
            }
            upserts.add(entry);
        }
        int expectedDeletes = before.size() + inserts - after.size();
        ArrayList deletes = new ArrayList(expectedDeletes);
        if (expectedDeletes > 0) {
            for (Object key : before.keySet()) {
                if (after.containsKey(key)) continue;
                deletes.add(key);
                if (--expectedDeletes != 0) continue;
                break;
            }
        }
        Function<Map, MapBuilder> builderCtor = before instanceof ImmutableOpenMap ? DiffableUtils::createImmutableMapBuilder : DiffableUtils::createJdkMapBuilder;
        return new MapDiff<K, T, Map>(keySerializer, valueSerializer, deletes, diffs, upserts, builderCtor);
    }

    private static <K, T, M extends Map<K, T>> MapBuilder<K, T, M> createImmutableMapBuilder(Map<K, T> m) {
        assert (m instanceof ImmutableOpenMap);
        return new ImmutableOpenMapBuilder((ImmutableOpenMap)m);
    }

    private static <K, T, M extends Map<K, T>> MapBuilder<K, T, M> createJdkMapBuilder(Map<K, T> m) {
        return new JdkMapBuilder<K, T>(m);
    }

    private static final class StringKeySerializer
    implements KeySerializer<String> {
        private static final StringKeySerializer INSTANCE = new StringKeySerializer();

        private StringKeySerializer() {
        }

        @Override
        public void writeKey(String key, StreamOutput out) throws IOException {
            out.writeString(key);
        }

        @Override
        public String readKey(StreamInput in) throws IOException {
            return in.readString();
        }
    }

    private static final class IntKeySerializer
    implements KeySerializer<Integer> {
        public static final IntKeySerializer INSTANCE = new IntKeySerializer();

        private IntKeySerializer() {
        }

        @Override
        public void writeKey(Integer key, StreamOutput out) throws IOException {
            out.writeInt(key);
        }

        @Override
        public Integer readKey(StreamInput in) throws IOException {
            return in.readInt();
        }
    }

    private static class WriteableKeySerializer<W extends Writeable>
    implements KeySerializer<W> {
        private final Writeable.Reader<W> reader;

        WriteableKeySerializer(Writeable.Reader<W> reader) {
            this.reader = reader;
        }

        @Override
        public void writeKey(W key, StreamOutput out) throws IOException {
            out.writeWriteable((Writeable)key);
        }

        @Override
        public W readKey(StreamInput in) throws IOException {
            return (W)((Writeable)this.reader.read(in));
        }
    }

    public static class MapDiff<K, T, M extends Map<K, T>>
    implements Diff<M> {
        protected final List<K> deletes;
        protected final List<Map.Entry<K, Diff<T>>> diffs;
        protected final List<Map.Entry<K, T>> upserts;
        protected final KeySerializer<K> keySerializer;
        protected final ValueSerializer<K, T> valueSerializer;
        private final Function<M, MapBuilder<K, T, M>> builderCtor;

        private MapDiff(KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, List<K> deletes, List<Map.Entry<K, Diff<T>>> diffs, List<Map.Entry<K, T>> upserts, Function<M, MapBuilder<K, T, M>> builderCtor) {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = deletes;
            this.diffs = diffs;
            this.upserts = upserts;
            this.builderCtor = builderCtor;
        }

        private MapDiff(StreamInput in, KeySerializer<K> keySerializer, ValueSerializer<K, T> valueSerializer, Function<M, MapBuilder<K, T, M>> builderCtor) throws IOException {
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
            this.deletes = in.readCollectionAsList(keySerializer::readKey);
            int diffsCount = in.readVInt();
            this.diffs = diffsCount == 0 ? List.of() : new ArrayList(diffsCount);
            for (int i = 0; i < diffsCount; ++i) {
                K key = keySerializer.readKey(in);
                Diff<T> diff = valueSerializer.readDiff(in, key);
                this.diffs.add(new AbstractMap.SimpleImmutableEntry<K, Diff<T>>(key, diff));
            }
            int upsertsCount = in.readVInt();
            this.upserts = upsertsCount == 0 ? List.of() : new ArrayList(upsertsCount);
            for (int i = 0; i < upsertsCount; ++i) {
                K key = keySerializer.readKey(in);
                T newValue = valueSerializer.read(in, key);
                this.upserts.add(new AbstractMap.SimpleImmutableEntry<K, T>(key, newValue));
            }
            this.builderCtor = builderCtor;
        }

        @Override
        public M apply(M map) {
            MapBuilder builder = this.builderCtor.apply(map);
            for (K k : this.deletes) {
                builder.remove(k);
            }
            for (Map.Entry entry : this.diffs) {
                builder.put(entry.getKey(), ((Diff)entry.getValue()).apply(builder.get(entry.getKey())));
            }
            for (Map.Entry entry : this.upserts) {
                builder.put(entry.getKey(), entry.getValue());
            }
            return builder.build();
        }

        public boolean isEmpty() {
            return this.deletes.isEmpty() && this.diffs.isEmpty() && this.upserts.isEmpty();
        }

        public List<K> getDeletes() {
            return this.deletes;
        }

        public List<Map.Entry<K, Diff<T>>> getDiffs() {
            return this.diffs;
        }

        public List<Map.Entry<K, T>> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.deletes, (o, v) -> this.keySerializer.writeKey(v, o));
            TransportVersion version = out.getTransportVersion();
            int diffCount = 0;
            for (Map.Entry<K, Diff<T>> diff : this.diffs) {
                if (!this.valueSerializer.supportsVersion((T)diff.getValue(), version)) continue;
                ++diffCount;
            }
            out.writeVInt(diffCount);
            for (Map.Entry<K, Diff<T>> entry : this.diffs) {
                if (!this.valueSerializer.supportsVersion((T)entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.writeDiff(entry.getValue(), out);
            }
            int upsertsCount = 0;
            for (Map.Entry<K, T> upsert : this.upserts) {
                if (!this.valueSerializer.supportsVersion(upsert.getValue(), version)) continue;
                ++upsertsCount;
            }
            out.writeVInt(upsertsCount);
            for (Map.Entry<K, T> entry : this.upserts) {
                if (!this.valueSerializer.supportsVersion(entry.getValue(), version)) continue;
                this.keySerializer.writeKey(entry.getKey(), out);
                this.valueSerializer.write(entry.getValue(), out);
            }
        }
    }

    public static abstract class DiffableValueSerializer<K, V extends Diffable<V>>
    implements ValueSerializer<K, V> {
        private static final DiffableValueSerializer WRITE_ONLY_INSTANCE = new DiffableValueSerializer(){

            @Override
            public Object read(StreamInput in, Object key) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Diff<Object> readDiff(StreamInput in, Object key) {
                throw new UnsupportedOperationException();
            }
        };

        private static <K, V extends Diffable<V>> DiffableValueSerializer<K, V> getWriteOnlyInstance() {
            return WRITE_ONLY_INSTANCE;
        }

        @Override
        public boolean supportsDiffableValues() {
            return true;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            return value.diff(beforePart);
        }

        @Override
        public void write(V value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) throws IOException {
            value.writeTo(out);
        }
    }

    public static interface KeySerializer<K> {
        public void writeKey(K var1, StreamOutput var2) throws IOException;

        public K readKey(StreamInput var1) throws IOException;
    }

    public static interface ValueSerializer<K, V> {
        public void write(V var1, StreamOutput var2) throws IOException;

        public V read(StreamInput var1, K var2) throws IOException;

        public boolean supportsDiffableValues();

        default public boolean supportsVersion(Diff<V> value, TransportVersion version) {
            return true;
        }

        default public boolean supportsVersion(V value, TransportVersion version) {
            return true;
        }

        public Diff<V> diff(V var1, V var2);

        public void writeDiff(Diff<V> var1, StreamOutput var2) throws IOException;

        public Diff<V> readDiff(StreamInput var1, K var2) throws IOException;
    }

    public static class DiffableValueReader<K, V extends Diffable<V>>
    extends DiffableValueSerializer<K, V> {
        private final Writeable.Reader<V> reader;
        private final Writeable.Reader<Diff<V>> diffReader;

        public DiffableValueReader(Writeable.Reader<V> reader, Writeable.Reader<Diff<V>> diffReader) {
            this.reader = reader;
            this.diffReader = diffReader;
        }

        @Override
        public V read(StreamInput in, K key) throws IOException {
            return (V)((Diffable)this.reader.read(in));
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) throws IOException {
            return this.diffReader.read(in);
        }
    }

    private static class ImmutableOpenMapBuilder<K, T>
    implements MapBuilder<K, T, ImmutableOpenMap<K, T>> {
        private final ImmutableOpenMap.Builder<K, T> builder;

        ImmutableOpenMapBuilder(ImmutableOpenMap<K, T> map) {
            this.builder = ImmutableOpenMap.builder(map);
        }

        @Override
        public void remove(K key) {
            this.builder.remove(key);
        }

        @Override
        public T get(K key) {
            return this.builder.get(key);
        }

        @Override
        public void put(K key, T value) {
            this.builder.put(key, value);
        }

        @Override
        public ImmutableOpenMap<K, T> build() {
            return this.builder.build();
        }
    }

    private static class JdkMapBuilder<K, T>
    implements MapBuilder<K, T, Map<K, T>> {
        private final Map<K, T> map;

        JdkMapBuilder(Map<K, T> map) {
            this.map = new HashMap<K, T>(map);
        }

        @Override
        public void remove(K key) {
            this.map.remove(key);
        }

        @Override
        public T get(K key) {
            return this.map.get(key);
        }

        @Override
        public void put(K key, T value) {
            this.map.put(key, value);
        }

        @Override
        public Map<K, T> build() {
            return Collections.unmodifiableMap(this.map);
        }
    }

    public static class StringSetValueSerializer<K>
    extends NonDiffableValueSerializer<K, Set<String>> {
        private static final StringSetValueSerializer INSTANCE = new StringSetValueSerializer();

        public static <K> StringSetValueSerializer<K> getInstance() {
            return INSTANCE;
        }

        @Override
        public void write(Set<String> value, StreamOutput out) throws IOException {
            out.writeStringCollection(value);
        }

        @Override
        public Set<String> read(StreamInput in, K key) throws IOException {
            return Set.of(in.readStringArray());
        }
    }

    public static abstract class NonDiffableValueSerializer<K, V>
    implements ValueSerializer<K, V> {
        @Override
        public boolean supportsDiffableValues() {
            return false;
        }

        @Override
        public Diff<V> diff(V value, V beforePart) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeDiff(Diff<V> value, StreamOutput out) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Diff<V> readDiff(StreamInput in, K key) {
            throw new UnsupportedOperationException();
        }
    }

    private static interface MapBuilder<K, T, M extends Map<K, T>> {
        public void remove(K var1);

        public T get(K var1);

        public void put(K var1, T var2);

        public M build();
    }
}

