/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.local;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public abstract class LocalClusterStateRequest
extends LegacyActionRequest {
    private final TimeValue masterTimeout;

    protected LocalClusterStateRequest(TimeValue masterTimeout) {
        this.masterTimeout = Objects.requireNonNull(masterTimeout);
    }

    protected LocalClusterStateRequest(StreamInput in) throws IOException {
        this(in, true);
    }

    protected LocalClusterStateRequest(StreamInput in, boolean readLocal) throws IOException {
        super(in);
        this.masterTimeout = in.readTimeValue();
        in.readVLong();
        if (readLocal) {
            in.readBoolean();
        }
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public TimeValue masterTimeout() {
        return this.masterTimeout;
    }
}

