/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DelegatingActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.ResolvedIndices;
import org.elasticsearch.action.ShardOperationFailedException;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsResponse;
import org.elasticsearch.action.admin.cluster.shards.TransportClusterSearchShardsAction;
import org.elasticsearch.action.admin.cluster.stats.CCSUsage;
import org.elasticsearch.action.admin.indices.resolve.ResolveIndexAction;
import org.elasticsearch.action.search.AbstractSearchAsyncAction;
import org.elasticsearch.action.search.CCSSingleCoordinatorSearchProgressListener;
import org.elasticsearch.action.search.CanMatchPreFilterSearchPhase;
import org.elasticsearch.action.search.ClosePointInTimeRequest;
import org.elasticsearch.action.search.ClosePointInTimeResponse;
import org.elasticsearch.action.search.OpenPointInTimeRequest;
import org.elasticsearch.action.search.OpenPointInTimeResponse;
import org.elasticsearch.action.search.SearchContextId;
import org.elasticsearch.action.search.SearchContextIdForNode;
import org.elasticsearch.action.search.SearchDfsQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchPhaseController;
import org.elasticsearch.action.search.SearchPhaseResults;
import org.elasticsearch.action.search.SearchProgressListener;
import org.elasticsearch.action.search.SearchQueryThenFetchAsyncAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchRequestAttributesExtractor;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchResponseMerger;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.SearchShardsGroup;
import org.elasticsearch.action.search.SearchShardsRequest;
import org.elasticsearch.action.search.SearchShardsResponse;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.TransportClosePointInTimeAction;
import org.elasticsearch.action.search.TransportOpenPointInTimeAction;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.search.TransportSearchShardsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.SearchShardRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.ResponseCollectorService;
import org.elasticsearch.rest.action.search.SearchResponseMetrics;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.builder.PointInTimeBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.crossproject.CrossProjectIndexResolutionValidator;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchContextId;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.usage.UsageService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentFactory;

public class TransportSearchAction
extends HandledTransportAction<SearchRequest, SearchResponse> {
    public static final String NAME = "indices:data/read/search";
    public static final ActionType<SearchResponse> TYPE = new ActionType("indices:data/read/search");
    public static final RemoteClusterActionType<SearchResponse> REMOTE_TYPE = new RemoteClusterActionType<SearchResponse>("indices:data/read/search", SearchResponse::new);
    private static final Logger logger = LogManager.getLogger(TransportSearchAction.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(TransportSearchAction.class);
    public static final String FROZEN_INDICES_DEPRECATION_MESSAGE = "Searching frozen indices [{}] is deprecated. Consider cold or frozen tiers in place of frozen indices. The frozen feature will be removed in a feature release.";
    public static final Setting<Long> SHARD_COUNT_LIMIT_SETTING = Setting.longSetting("action.search.shard_count.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> DEFAULT_PRE_FILTER_SHARD_SIZE = Setting.intSetting("action.search.pre_filter_shard_size.default", 128, 1, Setting.Property.NodeScope);
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final SearchTransportService searchTransportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchPhaseController searchPhaseController;
    private final SearchService searchService;
    private final ProjectResolver projectResolver;
    private final ResponseCollectorService responseCollectorService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final CircuitBreaker circuitBreaker;
    private final ExecutorSelector executorSelector;
    private final int defaultPreFilterShardSize;
    private final boolean ccsCheckCompatibility;
    private final SearchResponseMetrics searchResponseMetrics;
    private final Client client;
    private final UsageService usageService;
    private final boolean collectCCSTelemetry;
    private final TimeValue forceConnectTimeoutSecs;
    private final CrossProjectModeDecider crossProjectModeDecider;

    @Inject
    public TransportSearchAction(ThreadPool threadPool, CircuitBreakerService circuitBreakerService, TransportService transportService, SearchService searchService, ResponseCollectorService responseCollectorService, SearchTransportService searchTransportService, SearchPhaseController searchPhaseController, ClusterService clusterService, ActionFilters actionFilters, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver, NamedWriteableRegistry namedWriteableRegistry, ExecutorSelector executorSelector, SearchResponseMetrics searchResponseMetrics, Client client, UsageService usageService) {
        super(TYPE.name(), transportService, actionFilters, SearchRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.threadPool = threadPool;
        this.circuitBreaker = circuitBreakerService.getBreaker("request");
        this.searchPhaseController = searchPhaseController;
        this.searchTransportService = searchTransportService;
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
        SearchTransportService.registerRequestHandler(transportService, searchService, namedWriteableRegistry);
        SearchQueryThenFetchAsyncAction.registerNodeSearchAction(searchTransportService, searchService, searchPhaseController, namedWriteableRegistry);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.searchService = searchService;
        this.projectResolver = projectResolver;
        this.responseCollectorService = responseCollectorService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.executorSelector = executorSelector;
        Settings settings = clusterService.getSettings();
        this.defaultPreFilterShardSize = DEFAULT_PRE_FILTER_SHARD_SIZE.get(settings);
        this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(settings);
        this.collectCCSTelemetry = SearchService.CCS_COLLECT_TELEMETRY.get(settings);
        this.searchResponseMetrics = searchResponseMetrics;
        this.client = client;
        this.usageService = usageService;
        this.forceConnectTimeoutSecs = settings.getAsTime("search.ccs.force_connect_timeout", null);
        this.crossProjectModeDecider = new CrossProjectModeDecider(settings);
    }

    private Map<String, OriginalIndices> buildPerIndexOriginalIndices(ProjectState projectState, Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases, String[] indices, IndicesOptions indicesOptions) {
        ProjectId projectId;
        Map<String, OriginalIndices> res = Maps.newMapWithExpectedSize(indices.length);
        ClusterBlocks blocks = projectState.blocks();
        boolean hasBlocks = !blocks.global(projectId = projectState.projectId()).isEmpty() || !blocks.indices(projectState.projectId()).isEmpty();
        Set<String> indicesAndAliasesResources = indicesAndAliases.stream().map(IndexNameExpressionResolver.ResolvedExpression::resource).collect(Collectors.toSet());
        for (String index : indices) {
            if (hasBlocks) {
                blocks.indexBlockedRaiseException(projectId, ClusterBlockLevel.READ, index);
            }
            String[] aliases = this.indexNameExpressionResolver.allIndexAliases(projectState.metadata(), index, indicesAndAliases);
            String[] finalIndices = Strings.EMPTY_ARRAY;
            if (aliases == null || aliases.length == 0 || indicesAndAliasesResources.contains(index) || TransportSearchAction.hasDataStreamRef(projectState.metadata(), indicesAndAliasesResources, index)) {
                finalIndices = new String[]{index};
            }
            if (aliases != null) {
                finalIndices = finalIndices.length == 0 ? aliases : ArrayUtils.concat(finalIndices, aliases);
            }
            res.put(index, new OriginalIndices(finalIndices, indicesOptions));
        }
        return res;
    }

    private static boolean hasDataStreamRef(ProjectMetadata project, Set<String> indicesAndAliases, String index) {
        IndexAbstraction ret = (IndexAbstraction)project.getIndicesLookup().get(index);
        if (ret == null || ret.getParentDataStream() == null) {
            return false;
        }
        return indicesAndAliases.contains(ret.getParentDataStream().getName());
    }

    Map<String, AliasFilter> buildIndexAliasFilters(ProjectState projectState, Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases, Index[] concreteIndices) {
        HashMap<String, AliasFilter> aliasFilterMap = new HashMap<String, AliasFilter>();
        for (Index index : concreteIndices) {
            projectState.blocks().indexBlockedRaiseException(projectState.projectId(), ClusterBlockLevel.READ, index.getName());
            AliasFilter aliasFilter = this.searchService.buildAliasFilter(projectState, index.getName(), indicesAndAliases);
            assert (aliasFilter != null);
            aliasFilterMap.put(index.getUUID(), aliasFilter);
        }
        return aliasFilterMap;
    }

    private Map<String, Float> resolveIndexBoosts(SearchRequest searchRequest, ClusterState clusterState) {
        if (searchRequest.source() == null) {
            return Collections.emptyMap();
        }
        SearchSourceBuilder source = searchRequest.source();
        if (source.indexBoosts() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Float> concreteIndexBoosts = new HashMap<String, Float>();
        for (SearchSourceBuilder.IndexBoost ib : source.indexBoosts()) {
            Index[] concreteIndices;
            for (Index concreteIndex : concreteIndices = this.indexNameExpressionResolver.concreteIndices(clusterState, searchRequest.indicesOptions(), ib.getIndex())) {
                concreteIndexBoosts.putIfAbsent(concreteIndex.getUUID(), Float.valueOf(ib.getBoost()));
            }
        }
        return Collections.unmodifiableMap(concreteIndexBoosts);
    }

    @Override
    protected void doExecute(Task task, SearchRequest searchRequest, ActionListener<SearchResponse> listener) {
        this.executeRequest((SearchTask)task, searchRequest, listener, x$0 -> new AsyncSearchActionProvider((ActionListener<SearchResponse>)x$0), true);
    }

    void executeOpenPit(SearchTask task, SearchRequest original, ActionListener<SearchResponse> originalListener, Function<ActionListener<SearchResponse>, SearchPhaseProvider> searchPhaseProvider) {
        this.executeRequest(task, original, originalListener, searchPhaseProvider, false);
    }

    private void executeRequest(SearchTask task, final SearchRequest original, ActionListener<SearchResponse> originalListener, Function<ActionListener<SearchResponse>, SearchPhaseProvider> searchPhaseProvider, boolean collectSearchTelemetry) {
        ResolvedIndices resolvedIndices;
        IndicesOptions resolutionIdxOpts;
        boolean resolvesCrossProject = this.crossProjectModeDecider.resolvesCrossProject(original);
        long relativeStartNanos = System.nanoTime();
        SearchTimeProvider timeProvider = new SearchTimeProvider(original.getOrCreateAbsoluteStartMillis(), relativeStartNanos, System::nanoTime);
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(this.projectResolver.getProjectId(), ClusterBlockLevel.READ);
        ProjectState projectState = this.projectResolver.getProjectState(clusterState);
        IndicesOptions indicesOptions = resolutionIdxOpts = resolvesCrossProject ? CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(original.indicesOptions()) : original.indicesOptions();
        if (original.pointInTimeBuilder() != null) {
            resolvedIndices = ResolvedIndices.resolveWithPIT(original.pointInTimeBuilder(), resolutionIdxOpts, projectState.metadata(), this.namedWriteableRegistry);
        } else {
            resolvedIndices = ResolvedIndices.resolveWithIndexNamesAndOptions(original.indices(), resolutionIdxOpts, projectState.metadata(), this.indexNameExpressionResolver, this.remoteClusterService, timeProvider.absoluteStartMillis());
            this.frozenIndexCheck(resolvedIndices);
        }
        SearchSourceBuilder source = original.source();
        if (this.shouldOpenPIT(source)) {
            original.setPreFilterShardSize(Integer.MAX_VALUE);
            TransportSearchAction.openPIT(this.client, original, this.searchService.getDefaultKeepAliveInMillis(), originalListener.delegateFailureAndWrap((delegate, resp) -> {
                source.pointInTimeBuilder(new PointInTimeBuilder(resp.getPointInTimeId()).setKeepAlive(TimeValue.MINUS_ONE));
                ActionListener<SearchResponse> pitListener = new ActionListener<SearchResponse>(){

                    @Override
                    public void onResponse(SearchResponse response) {
                        response.incRef();
                        TransportSearchAction.closePIT(TransportSearchAction.this.client, original.source().pointInTimeBuilder(), () -> ActionListener.respondAndRelease(delegate, response));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        TransportSearchAction.closePIT(TransportSearchAction.this.client, original.source().pointInTimeBuilder(), () -> delegate.onFailure(e));
                    }
                };
                this.executeRequest(task, original, pitListener, searchPhaseProvider, true);
            }));
            return;
        }
        ActionListener<SearchRequest> rewriteListener = originalListener.delegateFailureAndWrap((delegate, rewritten) -> {
            ActionListener searchResponseActionListener;
            if (this.ccsCheckCompatibility) {
                TransportSearchHelper.checkCCSVersionCompatibility(rewritten);
            }
            if (collectSearchTelemetry) {
                Map<String, Object> searchRequestAttributes = SearchRequestAttributesExtractor.extractAttributes(original, (String[])Arrays.stream(resolvedIndices.getConcreteLocalIndices()).map(Index::getName).toArray(String[]::new));
                if (!this.collectCCSTelemetry || resolvedIndices.getRemoteClusterIndices().isEmpty()) {
                    searchResponseActionListener = new SearchTelemetryListener((ActionListener<SearchResponse>)delegate, this.searchResponseMetrics, searchRequestAttributes, timeProvider.absoluteStartMillis());
                } else {
                    OriginalIndices localIndices;
                    CCSUsage.Builder usageBuilder = new CCSUsage.Builder();
                    usageBuilder.setRemotesCount(resolvedIndices.getRemoteClusterIndices().size());
                    usageBuilder.setClientFromTask(task);
                    if (task.isAsync()) {
                        usageBuilder.setFeature("async");
                    }
                    if (original.pointInTimeBuilder() != null) {
                        usageBuilder.setFeature("pit");
                    }
                    if ((localIndices = resolvedIndices.getLocalIndices()) != null && Arrays.stream(localIndices.indices()).anyMatch(Regex::isSimpleMatchPattern)) {
                        usageBuilder.setFeature("wildcards");
                    }
                    if (resolvedIndices.getRemoteClusterIndices().values().stream().anyMatch(indices -> Arrays.stream(indices.indices()).anyMatch(Regex::isSimpleMatchPattern))) {
                        usageBuilder.setFeature("wildcards");
                    }
                    if (TransportSearchAction.shouldMinimizeRoundtrips(rewritten)) {
                        usageBuilder.setFeature("mrt_on");
                    }
                    searchResponseActionListener = new SearchTelemetryListener((ActionListener<SearchResponse>)delegate, this.searchResponseMetrics, searchRequestAttributes, timeProvider.absoluteStartMillis(), this.usageService, usageBuilder);
                }
            } else {
                searchResponseActionListener = delegate;
            }
            if (resolvedIndices.getRemoteClusterIndices().isEmpty()) {
                this.executeLocalSearch(task, timeProvider, (SearchRequest)rewritten, resolvedIndices, projectState, SearchResponse.Clusters.EMPTY, (SearchPhaseProvider)searchPhaseProvider.apply(searchResponseActionListener));
            } else {
                TaskId parentTaskId = task.taskInfo(this.clusterService.localNode().getId(), false).taskId();
                if (TransportSearchAction.shouldMinimizeRoundtrips(rewritten)) {
                    this.collectRemoteResolvedIndices(resolvesCrossProject, (SearchRequest)rewritten, resolutionIdxOpts, resolvedIndices, searchResponseActionListener.delegateFailureAndWrap((searchListener, replacedIndices) -> {
                        if (replacedIndices.getRemoteClusterIndices().isEmpty()) {
                            this.executeLocalSearch(task, timeProvider, (SearchRequest)rewritten, (ResolvedIndices)replacedIndices, projectState, SearchResponse.Clusters.EMPTY, (SearchPhaseProvider)searchPhaseProvider.apply(searchResponseActionListener));
                        } else {
                            AggregationReduceContext.Builder aggregationReduceContextBuilder = rewritten.source() != null && rewritten.source().aggregations() != null ? this.searchService.aggReduceContextBuilder(task::isCancelled, rewritten.source().aggregations()) : null;
                            SearchResponse.Clusters clusters = new SearchResponse.Clusters(replacedIndices.getLocalIndices(), replacedIndices.getRemoteClusterIndices(), true, clusterAlias -> this.remoteClusterService.shouldSkipOnFailure((String)clusterAlias, rewritten.allowPartialSearchResults()));
                            if (replacedIndices.getLocalIndices() == null) {
                                task.getProgressListener().notifyListShards(Collections.emptyList(), Collections.emptyList(), clusters, false, timeProvider);
                            }
                            TransportSearchAction.ccsRemoteReduce(task, parentTaskId, rewritten, replacedIndices, clusters, timeProvider, aggregationReduceContextBuilder, this.remoteClusterService, this.threadPool, searchListener, (r, l) -> this.executeLocalSearch(task, timeProvider, (SearchRequest)r, (ResolvedIndices)replacedIndices, projectState, clusters, (SearchPhaseProvider)searchPhaseProvider.apply((ActionListener<SearchResponse>)l)), this.transportService, this.forceConnectTimeoutSecs);
                        }
                    }));
                } else {
                    SearchContextId searchContext = resolvedIndices.getSearchContextId();
                    SearchResponse.Clusters clusters = new SearchResponse.Clusters(resolvedIndices.getLocalIndices(), resolvedIndices.getRemoteClusterIndices(), false, clusterAlias -> this.remoteClusterService.shouldSkipOnFailure((String)clusterAlias, rewritten.allowPartialSearchResults()));
                    TransportSearchAction.collectSearchShards(rewritten.indicesOptions(), rewritten.preference(), rewritten.routing(), rewritten.source() != null ? rewritten.source().query() : null, Objects.requireNonNullElse(rewritten.allowPartialSearchResults(), this.searchService.defaultAllowPartialSearchResults()), searchContext, resolvedIndices.getRemoteClusterIndices(), clusters, timeProvider, this.transportService, searchResponseActionListener.delegateFailureAndWrap((finalDelegate, searchShardsResponses) -> {
                        List<SearchShardIterator> remoteShardIterators;
                        Map<String, AliasFilter> remoteAliasFilters;
                        SearchResponse.Clusters participatingProjects = clusters;
                        if (resolvesCrossProject && rewritten.getResolvedIndexExpressions() != null) {
                            participatingProjects = TransportSearchAction.reconcileProjects(rewritten.getResolvedIndexExpressions(), searchShardsResponses, participatingProjects);
                        }
                        BiFunction<String, String, DiscoveryNode> clusterNodeLookup = TransportSearchAction.getRemoteClusterNodeLookup(searchShardsResponses);
                        if (searchContext != null) {
                            remoteAliasFilters = searchContext.aliasFilter();
                            remoteShardIterators = TransportSearchAction.getRemoteShardsIteratorFromPointInTime(searchShardsResponses, searchContext, rewritten.pointInTimeBuilder().getKeepAlive(), resolvedIndices.getRemoteClusterIndices());
                        } else {
                            remoteAliasFilters = new HashMap<String, AliasFilter>();
                            for (SearchShardsResponse searchShardsResponse : searchShardsResponses.values()) {
                                remoteAliasFilters.putAll(searchShardsResponse.getAliasFilters());
                            }
                            remoteShardIterators = TransportSearchAction.getRemoteShardsIterator(searchShardsResponses, resolvedIndices.getRemoteClusterIndices(), remoteAliasFilters);
                        }
                        this.executeSearch(task, timeProvider, (SearchRequest)rewritten, resolvedIndices, remoteShardIterators, clusterNodeLookup, projectState, remoteAliasFilters, participatingProjects, (SearchPhaseProvider)searchPhaseProvider.apply((ActionListener<SearchResponse>)finalDelegate));
                    }), this.forceConnectTimeoutSecs, resolvesCrossProject, rewritten.getResolvedIndexExpressions(), rewritten.getProjectRouting());
                }
            }
        });
        boolean isExplain = source != null && source.explain() != null && source.explain() != false;
        boolean isProfile = source != null && source.profile();
        boolean allowPartialSearchResults = original.allowPartialSearchResults() != null ? original.allowPartialSearchResults().booleanValue() : this.searchService.defaultAllowPartialSearchResults();
        Rewriteable.rewriteAndFetch(original, this.searchService.getRewriteContext(timeProvider::absoluteStartMillis, clusterState.getMinTransportVersion(), original.getLocalClusterAlias(), resolvedIndices, original.pointInTimeBuilder(), TransportSearchAction.shouldMinimizeRoundtrips(original), isExplain, isProfile, allowPartialSearchResults), rewriteListener);
    }

    private boolean shouldOpenPIT(SearchSourceBuilder source) {
        if (source == null) {
            return false;
        }
        if (source.pointInTimeBuilder() != null) {
            return false;
        }
        RetrieverBuilder retriever = source.retriever();
        return retriever != null && retriever.isCompound();
    }

    static void openPIT(Client client, SearchRequest request, long keepAliveMillis, ActionListener<OpenPointInTimeResponse> listener) {
        OpenPointInTimeRequest pitReq = new OpenPointInTimeRequest(request.indices()).indicesOptions(request.indicesOptions()).preference(request.preference()).routing(request.routing()).keepAlive(TimeValue.timeValueMillis((long)keepAliveMillis));
        client.execute(TransportOpenPointInTimeAction.TYPE, pitReq, listener);
    }

    static void closePIT(Client client, PointInTimeBuilder pit, Runnable next) {
        client.execute(TransportClosePointInTimeAction.TYPE, new ClosePointInTimeRequest(pit.getEncodedId()), ActionListener.runAfter(new ActionListener<ClosePointInTimeResponse>(){

            @Override
            public void onResponse(ClosePointInTimeResponse closePointInTimeResponse) {
            }

            @Override
            public void onFailure(Exception e) {
            }
        }, next));
    }

    static void adjustSearchType(SearchRequest searchRequest, boolean singleShard) {
        if (searchRequest.hasKnnSearch()) {
            searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);
            return;
        }
        if (searchRequest.isSuggestOnly()) {
            searchRequest.requestCache(false);
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
            return;
        }
        if (singleShard) {
            searchRequest.searchType(SearchType.QUERY_THEN_FETCH);
        }
    }

    public static boolean shouldMinimizeRoundtrips(SearchRequest searchRequest) {
        if (!searchRequest.isCcsMinimizeRoundtrips()) {
            return false;
        }
        if (searchRequest.scroll() != null) {
            return false;
        }
        if (searchRequest.pointInTimeBuilder() != null) {
            return false;
        }
        if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
            return false;
        }
        if (searchRequest.hasKnnSearch()) {
            return false;
        }
        SearchSourceBuilder source = searchRequest.source();
        return source == null || source.collapse() == null || source.collapse().getInnerHits() == null || source.collapse().getInnerHits().isEmpty();
    }

    private static SubscribableListener<Transport.Connection> getListenerWithOptionalTimeout(TimeValue forceConnectTimeoutSecs, ThreadPool threadPool, Executor timeoutExecutor) {
        SubscribableListener<Transport.Connection> subscribableListener = new SubscribableListener<Transport.Connection>();
        if (forceConnectTimeoutSecs != null) {
            subscribableListener.addTimeout(forceConnectTimeoutSecs, threadPool, timeoutExecutor);
        }
        return subscribableListener;
    }

    private static boolean shouldEstablishConnection(TimeValue forceConnectTimeoutSecs, boolean skipUnavailable) {
        return forceConnectTimeoutSecs != null || !skipUnavailable;
    }

    static void ccsRemoteReduce(SearchTask task, TaskId parentTaskId, SearchRequest searchRequest, ResolvedIndices resolvedIndices, final SearchResponse.Clusters clusters, final SearchTimeProvider timeProvider, AggregationReduceContext.Builder aggReduceContextBuilder, RemoteClusterService remoteClusterService, ThreadPool threadPool, final ActionListener<SearchResponse> listener, BiConsumer<SearchRequest, ActionListener<SearchResponse>> localSearchConsumer, TransportService transportService, TimeValue forceConnectTimeoutSecs) {
        ExecutorService remoteClientResponseExecutor = threadPool.executor("search_coordination");
        if (resolvedIndices.getLocalIndices() == null && resolvedIndices.getRemoteClusterIndices().size() == 1) {
            Map.Entry<String, OriginalIndices> entry = resolvedIndices.getRemoteClusterIndices().entrySet().iterator().next();
            final String clusterAlias = entry.getKey();
            final boolean shouldSkipOnFailure = remoteClusterService.shouldSkipOnFailure(clusterAlias, searchRequest.allowPartialSearchResults());
            OriginalIndices indices = entry.getValue();
            SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, indices.indices(), indices.indicesOptions(), clusterAlias, timeProvider.absoluteStartMillis(), true);
            SubscribableListener<Transport.Connection> connectionListener = TransportSearchAction.getListenerWithOptionalTimeout(forceConnectTimeoutSecs, threadPool, remoteClientResponseExecutor);
            ActionListener<SearchResponse> searchListener = new ActionListener<SearchResponse>(){

                @Override
                public void onResponse(SearchResponse searchResponse) {
                    TransportSearchAction.ccsClusterInfoUpdate(searchResponse, clusters, clusterAlias, shouldSkipOnFailure);
                    Map<String, SearchProfileShardResult> profileResults = searchResponse.getProfileResults();
                    SearchProfileResults profile = profileResults == null || profileResults.isEmpty() ? null : new SearchProfileResults(profileResults);
                    ActionListener.respondAndRelease(listener, new SearchResponse(searchResponse.getHits(), searchResponse.getAggregations(), searchResponse.getSuggest(), searchResponse.isTimedOut(), searchResponse.isTerminatedEarly(), profile, searchResponse.getNumReducePhases(), searchResponse.getScrollId(), searchResponse.getTotalShards(), searchResponse.getSuccessfulShards(), searchResponse.getSkippedShards(), timeProvider.buildTookInMillis(), searchResponse.getShardFailures(), clusters, searchResponse.pointInTimeId()));
                }

                @Override
                public void onFailure(Exception e) {
                    ShardSearchFailure failure = new ShardSearchFailure(e);
                    TransportSearchAction.logCCSError(failure, clusterAlias, shouldSkipOnFailure);
                    TransportSearchAction.ccsClusterInfoUpdate(failure, clusters, clusterAlias, shouldSkipOnFailure);
                    if (shouldSkipOnFailure) {
                        ActionListener.respondAndRelease(listener, SearchResponse.empty(timeProvider::buildTookInMillis, clusters));
                    } else {
                        listener.onFailure(TransportSearchAction.wrapRemoteClusterFailure(clusterAlias, e));
                    }
                }
            };
            connectionListener.addListener(searchListener.delegateFailure((responseListener, connection) -> transportService.sendRequest((Transport.Connection)connection, TYPE.name(), (TransportRequest)ccsSearchRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchResponse>((ActionListener<SearchResponse>)responseListener, SearchResponse::new, remoteClientResponseExecutor))));
            remoteClusterService.maybeEnsureConnectedAndGetConnection(clusterAlias, TransportSearchAction.shouldEstablishConnection(forceConnectTimeoutSecs, shouldSkipOnFailure), connectionListener);
        } else {
            SearchResponseMerger searchResponseMerger = TransportSearchAction.createSearchResponseMerger(searchRequest.source(), timeProvider, aggReduceContextBuilder);
            task.setSearchResponseMergerSupplier(() -> TransportSearchAction.createSearchResponseMerger(searchRequest.source(), timeProvider, aggReduceContextBuilder));
            AtomicReference<Exception> exceptions = new AtomicReference<Exception>();
            int totalClusters = resolvedIndices.getRemoteClusterIndices().size() + (resolvedIndices.getLocalIndices() == null ? 0 : 1);
            CountDown countDown = new CountDown(totalClusters);
            for (Map.Entry<String, OriginalIndices> entry : resolvedIndices.getRemoteClusterIndices().entrySet()) {
                String clusterAlias = entry.getKey();
                boolean shouldSkipOnFailure = remoteClusterService.shouldSkipOnFailure(clusterAlias, searchRequest.allowPartialSearchResults());
                OriginalIndices indices = entry.getValue();
                SearchRequest ccsSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, indices.indices(), indices.indicesOptions(), clusterAlias, timeProvider.absoluteStartMillis(), false);
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener(clusterAlias, shouldSkipOnFailure, countDown, exceptions, searchResponseMerger, clusters, task.getProgressListener(), listener);
                SubscribableListener<Transport.Connection> connectionListener = TransportSearchAction.getListenerWithOptionalTimeout(forceConnectTimeoutSecs, threadPool, remoteClientResponseExecutor);
                connectionListener.addListener(ccsListener.delegateFailure((responseListener, connection) -> transportService.sendRequest((Transport.Connection)connection, REMOTE_TYPE.name(), (TransportRequest)ccsSearchRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchResponse>((ActionListener<SearchResponse>)responseListener, SearchResponse::new, remoteClientResponseExecutor))));
                remoteClusterService.maybeEnsureConnectedAndGetConnection(clusterAlias, TransportSearchAction.shouldEstablishConnection(forceConnectTimeoutSecs, shouldSkipOnFailure), connectionListener);
            }
            if (resolvedIndices.getLocalIndices() != null) {
                ActionListener<SearchResponse> ccsListener = TransportSearchAction.createCCSListener("", false, countDown, exceptions, searchResponseMerger, clusters, task.getProgressListener(), listener);
                SearchRequest ccsLocalSearchRequest = SearchRequest.subSearchRequest(parentTaskId, searchRequest, resolvedIndices.getLocalIndices().indices(), resolvedIndices.getLocalIndices().indicesOptions(), "", timeProvider.absoluteStartMillis(), false);
                localSearchConsumer.accept(ccsLocalSearchRequest, ccsListener);
            }
        }
    }

    static SearchResponseMerger createSearchResponseMerger(SearchSourceBuilder source, SearchTimeProvider timeProvider, AggregationReduceContext.Builder aggReduceContextBuilder) {
        int trackTotalHitsUpTo;
        int size;
        int from;
        if (source == null) {
            from = 0;
            size = 10;
            trackTotalHitsUpTo = 10000;
        } else {
            from = source.from() == -1 ? 0 : source.from();
            size = source.size() == -1 ? 10 : source.size();
            trackTotalHitsUpTo = source.trackTotalHitsUpTo() == null ? 10000 : source.trackTotalHitsUpTo();
            source.from(0);
            source.size(from + size);
        }
        return new SearchResponseMerger(from, size, trackTotalHitsUpTo, timeProvider, aggReduceContextBuilder);
    }

    static SearchResponse.Clusters reconcileProjects(ResolvedIndexExpressions originResolvedIdxExpressions, Map<String, SearchShardsResponse> shardResponses, SearchResponse.Clusters projects) {
        Set linkedProjectsWithResponses = shardResponses.entrySet().stream().filter(ssr -> !((SearchShardsResponse)ssr.getValue()).getGroups().isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (linkedProjectsWithResponses.isEmpty()) {
            return SearchResponse.Clusters.EMPTY;
        }
        boolean shouldIncludeOrigin = originResolvedIdxExpressions.expressions().stream().anyMatch(expr -> expr.localExpressions().localIndexResolutionResult() == ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS);
        HashMap<String, SearchResponse.Cluster> reconciledMap = new HashMap<String, SearchResponse.Cluster>();
        for (String project : projects.getClusterAliases()) {
            SearchResponse.Cluster computedProjectInfo = projects.getCluster(project);
            boolean shouldAdd = false;
            if (shouldIncludeOrigin && project.equals("")) {
                shouldAdd = true;
            } else if (linkedProjectsWithResponses.contains(project)) {
                shouldAdd = true;
            } else if (!computedProjectInfo.getFailures().isEmpty()) {
                shouldAdd = true;
            }
            if (!shouldAdd) continue;
            reconciledMap.put(project, computedProjectInfo);
        }
        return new SearchResponse.Clusters(reconciledMap, false);
    }

    void collectRemoteResolvedIndices(boolean resolvesCrossProject, SearchRequest rewritten, IndicesOptions resolutionIdxOpts, ResolvedIndices originalResolvedIndices, ActionListener<ResolvedIndices> listener) {
        if (resolvesCrossProject) {
            int numProjectsToResolve = originalResolvedIndices.getRemoteClusterIndices().size();
            assert (numProjectsToResolve > 0) : "At least one index is required to resolve cross project indices";
            assert (rewritten.getResolvedIndexExpressions() != null) : "ResolvedIndexExpressions must be set when cross project is enabled";
            ActionListener responsesByProjectListener = listener.delegateFailureAndWrap((l, responsesByProject) -> TransportSearchAction.mergeResolvedIndices(originalResolvedIndices, responsesByProject, rewritten, resolutionIdxOpts, l));
            ActionListener resolveIndexFanOutListener = numProjectsToResolve > 1 ? new GroupedActionListener(numProjectsToResolve, responsesByProjectListener) : responsesByProjectListener.map(Collections::singleton);
            originalResolvedIndices.getRemoteClusterIndices().forEach((projectName, projectIndices) -> this.resolveRemoteCrossProjectIndex(rewritten, resolutionIdxOpts, (String)projectName, (OriginalIndices)projectIndices, resolveIndexFanOutListener));
        } else {
            listener.onResponse(originalResolvedIndices);
        }
    }

    private static void mergeResolvedIndices(ResolvedIndices originalResolvedIndices, Collection<Map.Entry<String, ResolveIndexAction.Response>> responsesByProject, SearchRequest rewritten, IndicesOptions resolutionIdxOpts, ActionListener<ResolvedIndices> listener) {
        Map<String, ResolvedIndexExpressions> resolvedExpressions = responsesByProject.stream().collect(Collectors.toMap(Map.Entry::getKey, response -> {
            ResolvedIndexExpressions resolvedIndexExpressions = ((ResolveIndexAction.Response)response.getValue()).getResolvedIndexExpressions();
            assert (resolvedIndexExpressions != null) : "remote response from cluster [" + (String)response.getKey() + "] is missing resolved index expressions";
            return resolvedIndexExpressions;
        }));
        ElasticsearchException ex = CrossProjectIndexResolutionValidator.validate(rewritten.indicesOptions(), rewritten.getProjectRouting(), rewritten.getResolvedIndexExpressions(), resolvedExpressions);
        if (ex != null) {
            listener.onFailure(ex);
        } else {
            listener.onResponse(ResolvedIndices.resolveWithIndexExpressions(originalResolvedIndices.getLocalIndices(), originalResolvedIndices.getConcreteLocalIndicesMetadata(), resolvedExpressions, resolutionIdxOpts));
        }
    }

    private void resolveRemoteCrossProjectIndex(SearchRequest rewritten, IndicesOptions resolutionIdxOpts, String projectName, OriginalIndices projectIndices, ActionListener<Map.Entry<String, ResolveIndexAction.Response>> listener) {
        SubscribableListener<Transport.Connection> connectionListener = TransportSearchAction.getListenerWithOptionalTimeout(this.forceConnectTimeoutSecs, this.threadPool, this.threadPool.executor("search_coordination"));
        connectionListener.addListener(listener.delegateFailure((responseListener, connection) -> this.transportService.sendRequest((Transport.Connection)connection, ResolveIndexAction.REMOTE_TYPE.name(), (TransportRequest)new ResolveIndexAction.Request(projectIndices.indices(), resolutionIdxOpts), TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ResolveIndexAction.Response>(listener.map(response -> Map.entry(projectName, response)), ResolveIndexAction.Response::new, this.threadPool.executor("search_coordination")))));
        this.remoteClusterService.maybeEnsureConnectedAndGetConnection(projectName, TransportSearchAction.shouldEstablishConnection(this.forceConnectTimeoutSecs, this.remoteClusterService.shouldSkipOnFailure(projectName, rewritten.allowPartialSearchResults())), connectionListener);
    }

    static void collectSearchShards(final IndicesOptions originalIdxOpts, String preference, String routing, QueryBuilder query, boolean allowPartialResults, SearchContextId searchContext, Map<String, OriginalIndices> remoteIndicesByCluster, SearchResponse.Clusters clusters, final SearchTimeProvider timeProvider, TransportService transportService, ActionListener<Map<String, SearchShardsResponse>> listener, TimeValue forceConnectTimeoutSecs, final boolean resolvesCrossProject, final ResolvedIndexExpressions originResolvedIdxExpressions, final String projectRouting) {
        RemoteClusterService remoteClusterService = transportService.getRemoteClusterService();
        CountDown responsesCountDown = new CountDown(remoteIndicesByCluster.size());
        final ConcurrentHashMap searchShardsResponses = new ConcurrentHashMap();
        AtomicReference exceptions = new AtomicReference();
        for (Map.Entry<String, OriginalIndices> entry : remoteIndicesByCluster.entrySet()) {
            String clusterAlias = entry.getKey();
            boolean shouldSkipOnFailure = remoteClusterService.shouldSkipOnFailure(clusterAlias, allowPartialResults);
            CCSActionListener<SearchShardsResponse, Map<String, SearchShardsResponse>> singleListener = new CCSActionListener<SearchShardsResponse, Map<String, SearchShardsResponse>>(clusterAlias, shouldSkipOnFailure, responsesCountDown, exceptions, clusters, listener){

                @Override
                void innerOnResponse(SearchShardsResponse searchShardsResponse) {
                    assert (ThreadPool.assertCurrentThreadPool("search_coordination"));
                    TransportSearchAction.ccsClusterInfoUpdate(searchShardsResponse, this.clusters, this.clusterAlias, timeProvider);
                    searchShardsResponses.put(this.clusterAlias, searchShardsResponse);
                }

                @Override
                Map<String, SearchShardsResponse> createFinalResponse() {
                    if (resolvesCrossProject && originResolvedIdxExpressions != null) {
                        HashMap<String, ResolvedIndexExpressions> resolvedIndexExpressions = new HashMap<String, ResolvedIndexExpressions>();
                        for (Map.Entry entry : searchShardsResponses.entrySet()) {
                            if (((SearchShardsResponse)entry.getValue()).getResolvedIndexExpressions() == null) {
                                throw new IllegalArgumentException("Failed to get resolved index expressions for cluster [" + (String)entry.getKey() + "]");
                            }
                            resolvedIndexExpressions.put((String)entry.getKey(), ((SearchShardsResponse)entry.getValue()).getResolvedIndexExpressions());
                        }
                        ElasticsearchException validationEx = CrossProjectIndexResolutionValidator.validate(originalIdxOpts, projectRouting, originResolvedIdxExpressions, resolvedIndexExpressions);
                        if (validationEx != null) {
                            throw validationEx;
                        }
                    }
                    return searchShardsResponses;
                }
            };
            ThreadPool threadPool = transportService.getThreadPool();
            SubscribableListener<Transport.Connection> connectionListener = TransportSearchAction.getListenerWithOptionalTimeout(forceConnectTimeoutSecs, threadPool, threadPool.executor("search_coordination"));
            connectionListener.addListener(singleListener.delegateFailure((responseListener, connection) -> {
                IndicesOptions searchShardsIdxOpts = resolvesCrossProject ? CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(originalIdxOpts) : originalIdxOpts;
                String[] indices = ((OriginalIndices)entry.getValue()).indices();
                ExecutorService responseExecutor = transportService.getThreadPool().executor("search_coordination");
                if (searchContext == null) {
                    SearchShardsRequest searchShardsRequest = new SearchShardsRequest(indices, searchShardsIdxOpts, query, routing, preference, allowPartialResults, clusterAlias);
                    transportService.sendRequest((Transport.Connection)connection, TransportSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<SearchShardsResponse>((ActionListener<SearchShardsResponse>)responseListener, SearchShardsResponse::new, responseExecutor));
                } else {
                    ClusterSearchShardsRequest searchShardsRequest = ((ClusterSearchShardsRequest)new ClusterSearchShardsRequest(MasterNodeRequest.INFINITE_MASTER_NODE_TIMEOUT, indices).indicesOptions(searchShardsIdxOpts).local(true)).preference(preference).routing(routing);
                    transportService.sendRequest((Transport.Connection)connection, TransportClusterSearchShardsAction.TYPE.name(), (TransportRequest)searchShardsRequest, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler<ClusterSearchShardsResponse>(singleListener.map(SearchShardsResponse::fromLegacyResponse), ClusterSearchShardsResponse::new, responseExecutor));
                }
            }));
            remoteClusterService.maybeEnsureConnectedAndGetConnection(clusterAlias, TransportSearchAction.shouldEstablishConnection(forceConnectTimeoutSecs, shouldSkipOnFailure), connectionListener);
        }
    }

    private static ActionListener<SearchResponse> createCCSListener(String clusterAlias, final boolean shouldSkipOnFailure, CountDown countDown, AtomicReference<Exception> exceptions, final SearchResponseMerger searchResponseMerger, SearchResponse.Clusters clusters, final SearchProgressListener progressListener, ActionListener<SearchResponse> originalListener) {
        return new CCSActionListener<SearchResponse, SearchResponse>(clusterAlias, shouldSkipOnFailure, countDown, exceptions, clusters, ActionListener.releaseAfter(originalListener, searchResponseMerger)){

            @Override
            void innerOnResponse(SearchResponse searchResponse) {
                TransportSearchAction.ccsClusterInfoUpdate(searchResponse, this.clusters, this.clusterAlias, shouldSkipOnFailure);
                searchResponseMerger.add(searchResponse);
                progressListener.notifyClusterResponseMinimizeRoundtrips(this.clusterAlias, searchResponse);
            }

            @Override
            SearchResponse createFinalResponse() {
                return searchResponseMerger.getMergedResponse(this.clusters);
            }

            @Override
            protected void releaseResponse(SearchResponse searchResponse) {
                searchResponse.decRef();
            }
        };
    }

    static void ccsClusterInfoUpdate(ShardSearchFailure failure, SearchResponse.Clusters clusters, String clusterAlias, boolean shouldSkipOnFailure) {
        clusters.swapCluster(clusterAlias, (k, v) -> {
            SearchResponse.Cluster.Status status = shouldSkipOnFailure ? SearchResponse.Cluster.Status.SKIPPED : SearchResponse.Cluster.Status.FAILED;
            return new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(status).setFailures(CollectionUtils.appendToCopy(v.getFailures(), failure)).build();
        });
    }

    private static void ccsClusterInfoUpdate(SearchResponse searchResponse, SearchResponse.Clusters clusters, String clusterAlias, boolean shouldSkipOnFailure) {
        clusters.swapCluster(clusterAlias, (k, v) -> {
            int totalShards = searchResponse.getTotalShards();
            SearchResponse.Cluster.Status status = totalShards > 0 && searchResponse.getFailedShards() >= totalShards ? (shouldSkipOnFailure ? SearchResponse.Cluster.Status.SKIPPED : SearchResponse.Cluster.Status.FAILED) : (searchResponse.isTimedOut() ? SearchResponse.Cluster.Status.PARTIAL : (searchResponse.getFailedShards() > 0 ? SearchResponse.Cluster.Status.PARTIAL : SearchResponse.Cluster.Status.SUCCESSFUL));
            return new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(status).setTotalShards(totalShards).setSuccessfulShards(searchResponse.getSuccessfulShards()).setSkippedShards(searchResponse.getSkippedShards()).setFailedShards(searchResponse.getFailedShards()).setFailures(Arrays.asList(searchResponse.getShardFailures())).setTook(searchResponse.getTook()).setTimedOut(searchResponse.isTimedOut()).build();
        });
    }

    private static void ccsClusterInfoUpdate(SearchShardsResponse response, SearchResponse.Clusters clusters, String clusterAlias, SearchTimeProvider timeProvider) {
        if (response.getGroups().isEmpty()) {
            clusters.swapCluster(clusterAlias, (k, v) -> new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(SearchResponse.Cluster.Status.SUCCESSFUL).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).setFailures(Collections.emptyList()).setTook(new TimeValue(timeProvider.buildTookInMillis())).setTimedOut(false).build());
        }
    }

    void executeLocalSearch(Task task, SearchTimeProvider timeProvider, SearchRequest searchRequest, ResolvedIndices resolvedIndices, ProjectState projectState, SearchResponse.Clusters clusterInfo, SearchPhaseProvider searchPhaseProvider) {
        this.executeSearch((SearchTask)task, timeProvider, searchRequest, resolvedIndices, Collections.emptyList(), (clusterName, nodeId) -> null, projectState, Collections.emptyMap(), clusterInfo, searchPhaseProvider);
    }

    static BiFunction<String, String, DiscoveryNode> getRemoteClusterNodeLookup(Map<String, SearchShardsResponse> searchShardsResp) {
        HashMap<String, Map> clusterToNode = new HashMap<String, Map>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResp.entrySet()) {
            String clusterAlias2 = entry.getKey();
            for (DiscoveryNode remoteNode : entry.getValue().getNodes()) {
                clusterToNode.computeIfAbsent(clusterAlias2, k -> new HashMap()).put(remoteNode.getId(), remoteNode);
            }
        }
        return (clusterAlias, nodeId) -> {
            Map clusterNodes = (Map)clusterToNode.get(clusterAlias);
            if (clusterNodes == null) {
                throw new IllegalArgumentException("unknown remote cluster: " + clusterAlias);
            }
            return (DiscoveryNode)clusterNodes.get(nodeId);
        };
    }

    static List<SearchShardIterator> getRemoteShardsIterator(Map<String, SearchShardsResponse> searchShardsResponses, Map<String, OriginalIndices> remoteIndicesByCluster, Map<String, AliasFilter> aliasFilterMap) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (SearchShardsGroup searchShardsGroup : entry.getValue().getGroups()) {
                String[] stringArray;
                ShardId shardId = searchShardsGroup.shardId();
                AliasFilter aliasFilter = aliasFilterMap.get(shardId.getIndex().getUUID());
                String[] aliases = aliasFilter.getAliases();
                String clusterAlias = entry.getKey();
                if (aliases.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = shardId.getIndexName();
                } else {
                    stringArray = aliases;
                }
                String[] finalIndices = stringArray;
                OriginalIndices originalIndices = remoteIndicesByCluster.get(clusterAlias);
                assert (originalIndices != null) : "original indices are null for clusterAlias: " + clusterAlias;
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, searchShardsGroup.allocatedNodes(), new OriginalIndices(finalIndices, originalIndices.indicesOptions()), null, null, searchShardsGroup.preFiltered(), searchShardsGroup.skipped(), SplitShardCountSummary.UNSET);
                remoteShardIterators.add(shardIterator);
            }
        }
        return remoteShardIterators;
    }

    static List<SearchShardIterator> getRemoteShardsIteratorFromPointInTime(Map<String, SearchShardsResponse> searchShardsResponses, SearchContextId searchContextId, TimeValue searchContextKeepAlive, Map<String, OriginalIndices> remoteClusterIndices) {
        ArrayList<SearchShardIterator> remoteShardIterators = new ArrayList<SearchShardIterator>();
        for (Map.Entry<String, SearchShardsResponse> entry : searchShardsResponses.entrySet()) {
            for (SearchShardsGroup group : entry.getValue().getGroups()) {
                ShardId shardId = group.shardId();
                SearchContextIdForNode perNode = searchContextId.shards().get(shardId);
                if (perNode == null) continue;
                String clusterAlias = entry.getKey();
                assert (clusterAlias.equals(perNode.getClusterAlias())) : clusterAlias + " != " + perNode.getClusterAlias();
                ArrayList<String> targetNodes = new ArrayList<String>(group.allocatedNodes().size());
                if (perNode.getNode() != null) {
                    targetNodes.add(perNode.getNode());
                    ShardSearchContextId shardSearchContextId = perNode.getSearchContextId();
                    if (shardSearchContextId != null && shardSearchContextId.isRetryable()) {
                        for (String node : group.allocatedNodes()) {
                            if (node.equals(perNode.getNode())) continue;
                            targetNodes.add(node);
                        }
                    }
                }
                assert (remoteClusterIndices.get(clusterAlias) != null) : "original indices are null for clusterAlias: " + clusterAlias;
                OriginalIndices finalIndices = new OriginalIndices(new String[]{shardId.getIndexName()}, remoteClusterIndices.get(clusterAlias).indicesOptions());
                SearchShardIterator shardIterator = new SearchShardIterator(clusterAlias, shardId, targetNodes, finalIndices, perNode.getSearchContextId(), searchContextKeepAlive, false, false, SplitShardCountSummary.UNSET);
                remoteShardIterators.add(shardIterator);
            }
        }
        assert (TransportSearchAction.checkAllRemotePITShardsWereReturnedBySearchShards(searchContextId.shards(), searchShardsResponses)) : "search shards did not return remote shards that PIT included: " + String.valueOf(searchContextId.shards());
        return remoteShardIterators;
    }

    private static boolean checkAllRemotePITShardsWereReturnedBySearchShards(Map<ShardId, SearchContextIdForNode> searchContextIdShards, Map<String, SearchShardsResponse> searchShardsResponses) {
        HashMap<ShardId, SearchContextIdForNode> searchContextIdForNodeMap = new HashMap<ShardId, SearchContextIdForNode>(searchContextIdShards);
        for (SearchShardsResponse searchShardsResponse : searchShardsResponses.values()) {
            for (SearchShardsGroup group : searchShardsResponse.getGroups()) {
                searchContextIdForNodeMap.remove(group.shardId());
            }
        }
        return searchContextIdForNodeMap.values().stream().allMatch(searchContextIdForNode -> searchContextIdForNode.getClusterAlias() == null);
    }

    void frozenIndexCheck(ResolvedIndices resolvedIndices) {
        ArrayList<String> frozenIndices = new ArrayList<String>();
        Map<Index, IndexMetadata> indexMetadataMap = resolvedIndices.getConcreteLocalIndicesMetadata();
        for (Map.Entry<Index, IndexMetadata> entry : indexMetadataMap.entrySet()) {
            if (!entry.getValue().getSettings().getAsBoolean("index.frozen", false).booleanValue()) continue;
            frozenIndices.add(entry.getKey().getName());
        }
        if (!frozenIndices.isEmpty()) {
            DEPRECATION_LOGGER.warn(DeprecationCategory.INDICES, "search-frozen-indices", FROZEN_INDICES_DEPRECATION_MESSAGE, String.join((CharSequence)",", frozenIndices));
        }
    }

    private void executeSearch(SearchTask task, SearchTimeProvider timeProvider, SearchRequest searchRequest, ResolvedIndices resolvedIndices, List<SearchShardIterator> remoteShardIterators, BiFunction<String, String, DiscoveryNode> remoteConnections, ProjectState projectState, Map<String, AliasFilter> remoteAliasMap, SearchResponse.Clusters clusters, SearchPhaseProvider searchPhaseProvider) {
        List<SearchShardIterator> localShardIterators;
        String[] concreteLocalIndices;
        Map<String, AliasFilter> aliasFilter;
        if (searchRequest.allowPartialSearchResults() == null) {
            searchRequest.allowPartialSearchResults(this.searchService.defaultAllowPartialSearchResults());
        }
        if (resolvedIndices.getSearchContextId() != null) {
            assert (searchRequest.pointInTimeBuilder() != null);
            aliasFilter = resolvedIndices.getSearchContextId().aliasFilter();
            concreteLocalIndices = resolvedIndices.getLocalIndices() == null ? new String[]{} : resolvedIndices.getLocalIndices().indices();
            localShardIterators = TransportSearchAction.getLocalShardsIteratorFromPointInTime(projectState, searchRequest.indicesOptions(), searchRequest.getLocalClusterAlias(), resolvedIndices.getSearchContextId(), searchRequest.pointInTimeBuilder().getKeepAlive(), searchRequest.allowPartialSearchResults());
        } else {
            Index[] indices = resolvedIndices.getConcreteLocalIndices();
            concreteLocalIndices = (String[])Arrays.stream(indices).map(Index::getName).toArray(String[]::new);
            Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases = this.indexNameExpressionResolver.resolveExpressions(projectState.metadata(), searchRequest.indices());
            aliasFilter = this.buildIndexAliasFilters(projectState, indicesAndAliases, indices);
            aliasFilter.putAll(remoteAliasMap);
            localShardIterators = this.getLocalShardsIterator(projectState, searchRequest, searchRequest.getLocalClusterAlias(), indicesAndAliases, concreteLocalIndices);
            if (localShardIterators.isEmpty() && clusters != SearchResponse.Clusters.EMPTY && clusters.getCluster("") != null) {
                clusters.swapCluster("", (alias, v) -> new SearchResponse.Cluster.Builder((SearchResponse.Cluster)v).setStatus(SearchResponse.Cluster.Status.SUCCESSFUL).setTotalShards(0).setSuccessfulShards(0).setSkippedShards(0).setFailedShards(0).setFailures(Collections.emptyList()).setTook(TimeValue.timeValueMillis((long)0L)).setTimedOut(false).build());
            }
        }
        List<SearchShardIterator> shardIterators = TransportSearchAction.mergeShardsIterators(localShardIterators, remoteShardIterators);
        TransportSearchAction.failIfOverShardCountLimit(this.clusterService, shardIterators.size());
        if (!searchRequest.getWaitForCheckpoints().isEmpty()) {
            if (!remoteShardIterators.isEmpty()) {
                throw new IllegalArgumentException("Cannot use wait_for_checkpoints parameter with cross-cluster searches.");
            }
            TransportSearchAction.validateAndResolveWaitForCheckpoint(projectState, this.indexNameExpressionResolver, searchRequest, concreteLocalIndices);
        }
        Map<String, Float> concreteIndexBoosts = this.resolveIndexBoosts(searchRequest, projectState.cluster());
        TransportSearchAction.adjustSearchType(searchRequest, shardIterators.size() == 1);
        DiscoveryNodes nodes = projectState.cluster().nodes();
        BiFunction<String, String, Transport.Connection> connectionLookup = TransportSearchAction.buildConnectionLookup(searchRequest.getLocalClusterAlias(), nodes::get, remoteConnections, this.searchTransportService::getConnection);
        Executor asyncSearchExecutor = this.asyncSearchExecutor(concreteLocalIndices);
        boolean preFilterSearchShards = TransportSearchAction.shouldPreFilterSearchShards(projectState, searchRequest, concreteLocalIndices, localShardIterators.size() + remoteShardIterators.size(), this.defaultPreFilterShardSize);
        Map<String, Object> searchRequestAttributes = SearchRequestAttributesExtractor.extractAttributes(searchRequest, concreteLocalIndices);
        searchPhaseProvider.runNewSearchPhase(task, searchRequest, asyncSearchExecutor, shardIterators, timeProvider, connectionLookup, projectState.cluster(), Collections.unmodifiableMap(aliasFilter), concreteIndexBoosts, preFilterSearchShards, this.threadPool, clusters, searchRequestAttributes);
    }

    Executor asyncSearchExecutor(String[] indices) {
        boolean seenSystem = false;
        boolean seenCritical = false;
        block8: for (String index : indices) {
            String executorName;
            switch (executorName = this.executorSelector.executorForSearch(index)) {
                case "system_read": {
                    seenSystem = true;
                    continue block8;
                }
                case "system_critical_read": {
                    seenCritical = true;
                    continue block8;
                }
                default: {
                    return this.threadPool.executor(executorName);
                }
            }
        }
        String executor = !seenSystem && seenCritical ? "system_critical_read" : (seenSystem ? "system_read" : "search");
        return this.threadPool.executor(executor);
    }

    static BiFunction<String, String, Transport.Connection> buildConnectionLookup(String requestClusterAlias, Function<String, DiscoveryNode> localNodes, BiFunction<String, String, DiscoveryNode> remoteNodes, BiFunction<String, DiscoveryNode, Transport.Connection> nodeToConnection) {
        return (clusterAlias, nodeId) -> {
            boolean remoteCluster;
            DiscoveryNode discoveryNode;
            if (clusterAlias == null || requestClusterAlias != null) {
                assert (requestClusterAlias == null || requestClusterAlias.equals(clusterAlias));
                discoveryNode = (DiscoveryNode)localNodes.apply((String)nodeId);
                remoteCluster = false;
            } else {
                discoveryNode = (DiscoveryNode)remoteNodes.apply((String)clusterAlias, (String)nodeId);
                remoteCluster = true;
            }
            if (discoveryNode == null) {
                throw new IllegalStateException("no node found for id: " + nodeId);
            }
            return (Transport.Connection)nodeToConnection.apply(remoteCluster ? clusterAlias : null, discoveryNode);
        };
    }

    static boolean shouldPreFilterSearchShards(ProjectState projectState, SearchRequest searchRequest, String[] indices, int numShards, int defaultPreFilterShardSize) {
        if (searchRequest.searchType() != SearchType.QUERY_THEN_FETCH) {
            return false;
        }
        SearchSourceBuilder source = searchRequest.source();
        Integer preFilterShardSize = searchRequest.getPreFilterShardSize();
        if (preFilterShardSize == null) {
            preFilterShardSize = TransportSearchAction.hasReadOnlyIndices(indices, projectState) || FieldSortBuilder.hasPrimaryFieldSort(source) ? Integer.valueOf(1) : Integer.valueOf(defaultPreFilterShardSize);
        }
        return preFilterShardSize < numShards && (SearchService.canRewriteToMatchNone(source) || FieldSortBuilder.hasPrimaryFieldSort(source));
    }

    private static boolean hasReadOnlyIndices(String[] indices, ProjectState projectState) {
        ClusterBlocks blocks = projectState.blocks();
        if (blocks.global(projectState.projectId()).isEmpty() && blocks.indices(projectState.projectId()).isEmpty()) {
            return false;
        }
        for (String index : indices) {
            ClusterBlockException writeBlock = blocks.indexBlockedException(projectState.projectId(), ClusterBlockLevel.WRITE, index);
            if (writeBlock == null) continue;
            return true;
        }
        return false;
    }

    static List<SearchShardIterator> mergeShardsIterators(List<SearchShardIterator> localShardIterators, List<SearchShardIterator> remoteShardIterators) {
        List<SearchShardIterator> shards = remoteShardIterators.isEmpty() ? localShardIterators : CollectionUtils.concatLists(remoteShardIterators, localShardIterators);
        shards.sort(SearchShardIterator::compareTo);
        return shards;
    }

    private static void validateAndResolveWaitForCheckpoint(ProjectState projectState, IndexNameExpressionResolver resolver, SearchRequest searchRequest, String[] concreteLocalIndices) {
        HashSet<String> searchedIndices = new HashSet<String>(Arrays.asList(concreteLocalIndices));
        Map<String, long[]> newWaitForCheckpoints = Maps.newMapWithExpectedSize(searchRequest.getWaitForCheckpoints().size());
        for (Map.Entry<String, long[]> waitForCheckpointIndex : searchRequest.getWaitForCheckpoints().entrySet()) {
            Index resolved;
            long[] checkpoints = waitForCheckpointIndex.getValue();
            int checkpointsProvided = checkpoints.length;
            final String target = waitForCheckpointIndex.getKey();
            try {
                resolved = resolver.concreteSingleIndex(projectState.cluster(), new IndicesRequest(){

                    @Override
                    public String[] indices() {
                        return new String[]{target};
                    }

                    @Override
                    public IndicesOptions indicesOptions() {
                        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
                    }
                });
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to resolve wait_for_checkpoints target [" + target + "]. Configured target must resolve to a single open index.", e);
            }
            String index = resolved.getName();
            IndexMetadata indexMetadata = projectState.metadata().index(index);
            if (!searchedIndices.contains(index)) {
                throw new IllegalArgumentException("Target configured with wait_for_checkpoints must be a concrete index resolved in this search. Target [" + target + "] is not a concrete index resolved in this search.");
            }
            if (indexMetadata == null) {
                throw new IllegalArgumentException("Cannot find index configured for wait_for_checkpoints parameter [" + index + "].");
            }
            if (indexMetadata.getNumberOfShards() != checkpointsProvided) {
                throw new IllegalArgumentException("Target configured with wait_for_checkpoints must search the same number of shards as checkpoints provided. [" + checkpointsProvided + "] checkpoints provided. Target [" + target + "] which resolved to index [" + index + "] has [" + indexMetadata.getNumberOfShards() + "] shards.");
            }
            newWaitForCheckpoints.put(index, checkpoints);
        }
        searchRequest.setWaitForCheckpoints(Collections.unmodifiableMap(newWaitForCheckpoints));
    }

    private static void failIfOverShardCountLimit(ClusterService clusterService, int shardCount) {
        long shardCountLimit = clusterService.getClusterSettings().get(SHARD_COUNT_LIMIT_SETTING);
        if ((long)shardCount > shardCountLimit) {
            throw new IllegalArgumentException("Trying to query " + shardCount + " shards, which is over the limit of " + shardCountLimit + ". This limit exists because querying many shards at the same time can make the job of the coordinating node very CPU and/or memory intensive. It is usually a better idea to have a smaller number of larger shards. Update [" + SHARD_COUNT_LIMIT_SETTING.getKey() + "] to a greater value if you really want to query that many shards at the same time.");
        }
    }

    private static void logCCSError(ShardSearchFailure f, String clusterAlias, boolean shouldSkipOnFailure) {
        String errorInfo;
        try {
            errorInfo = Strings.toString(f.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS));
        }
        catch (IOException ex) {
            errorInfo = f.toString();
        }
        logger.debug("CCS remote cluster failure. Cluster [{}]. shouldSkipOnFailure: [{}]. Error: {}", (Object)clusterAlias, (Object)shouldSkipOnFailure, (Object)errorInfo);
    }

    private static RemoteTransportException wrapRemoteClusterFailure(String clusterAlias, Exception e) {
        return new RemoteTransportException("error while communicating with remote cluster [" + clusterAlias + "]", e);
    }

    static List<SearchShardIterator> getLocalShardsIteratorFromPointInTime(ProjectState projectState, IndicesOptions indicesOptions, String localClusterAlias, SearchContextId searchContext, TimeValue keepAlive, boolean allowPartialSearchResults) {
        ArrayList<SearchShardIterator> iterators = new ArrayList<SearchShardIterator>(searchContext.shards().size());
        for (Map.Entry<ShardId, SearchContextIdForNode> entry : searchContext.shards().entrySet()) {
            ArrayList<String> targetNodes;
            ShardId shardId;
            SearchContextIdForNode perNode;
            block8: {
                perNode = entry.getValue();
                if (!Strings.isEmpty(perNode.getClusterAlias())) continue;
                shardId = entry.getKey();
                targetNodes = new ArrayList<String>(2);
                if (perNode.getNode() != null) {
                    try {
                        ShardIterator shards = OperationRouting.getShards(projectState.routingTable(), shardId);
                        if (projectState.cluster().nodes().nodeExists(perNode.getNode())) {
                            targetNodes.add(perNode.getNode());
                        } else {
                            logger.debug("Node [{}] referenced in PIT context id [{}] no longer exists.", (Object)perNode.getNode(), (Object)perNode.getSearchContextId());
                        }
                        ShardSearchContextId shardSearchContextId = perNode.getSearchContextId();
                        if (shardSearchContextId.isRetryable()) {
                            for (ShardRouting shard : shards) {
                                if (shard.currentNodeId().equals(perNode.getNode())) continue;
                                targetNodes.add(shard.currentNodeId());
                            }
                        }
                    }
                    catch (IndexNotFoundException | ShardNotFoundException e) {
                        if (allowPartialSearchResults) break block8;
                        throw e;
                    }
                }
            }
            OriginalIndices finalIndices = new OriginalIndices(new String[]{shardId.getIndexName()}, indicesOptions);
            iterators.add(new SearchShardIterator(localClusterAlias, shardId, targetNodes, finalIndices, perNode.getSearchContextId(), keepAlive, false, false, SplitShardCountSummary.UNSET));
        }
        return iterators;
    }

    List<SearchShardIterator> getLocalShardsIterator(ProjectState projectState, SearchRequest searchRequest, String clusterAlias, Set<IndexNameExpressionResolver.ResolvedExpression> indicesAndAliases, String[] concreteIndices) {
        concreteIndices = TransportSearchAction.ignoreBlockedIndices(projectState, concreteIndices);
        Map<String, Set<String>> routingMap = this.indexNameExpressionResolver.resolveSearchRouting(projectState.metadata(), searchRequest.routing(), searchRequest.indices());
        List<SearchShardRouting> shardRoutings = this.clusterService.operationRouting().searchShards(projectState, concreteIndices, routingMap, searchRequest.preference(), this.responseCollectorService, this.searchTransportService.getPendingSearchRequests());
        Map<String, OriginalIndices> originalIndices = this.buildPerIndexOriginalIndices(projectState, indicesAndAliases, concreteIndices, searchRequest.indicesOptions());
        SearchShardIterator[] list = new SearchShardIterator[shardRoutings.size()];
        int i = 0;
        for (SearchShardRouting shardRouting : shardRoutings) {
            ShardId shardId = shardRouting.shardId();
            OriginalIndices finalIndices = originalIndices.get(shardId.getIndex().getName());
            assert (finalIndices != null);
            list[i++] = new SearchShardIterator(clusterAlias, shardId, shardRouting.getShardRoutings(), finalIndices, shardRouting.reshardSplitShardCountSummary());
        }
        return Arrays.asList(list);
    }

    static String[] ignoreBlockedIndices(ProjectState projectState, String[] concreteIndices) {
        boolean hasIndexBlocks;
        boolean bl = hasIndexBlocks = !projectState.blocks().indices(projectState.projectId()).isEmpty();
        if (hasIndexBlocks) {
            return (String[])Arrays.stream(concreteIndices).filter(index -> !projectState.blocks().hasIndexBlock(projectState.projectId(), (String)index, IndexMetadata.INDEX_REFRESH_BLOCK)).toArray(String[]::new);
        }
        return concreteIndices;
    }

    public record SearchTimeProvider(long absoluteStartMillis, long relativeStartNanos, LongSupplier relativeCurrentNanosProvider) {
        public long buildTookInMillis() {
            return TimeUnit.NANOSECONDS.toMillis(this.relativeCurrentNanosProvider.getAsLong() - this.relativeStartNanos);
        }
    }

    static abstract class CCSActionListener<Response, FinalResponse>
    implements ActionListener<Response> {
        protected final String clusterAlias;
        protected final boolean skipOnFailure;
        private final CountDown countDown;
        private final AtomicReference<Exception> exceptions;
        protected final SearchResponse.Clusters clusters;
        private final ActionListener<FinalResponse> originalListener;

        CCSActionListener(String clusterAlias, boolean skipOnFailure, CountDown countDown, AtomicReference<Exception> exceptions, SearchResponse.Clusters clusters, ActionListener<FinalResponse> originalListener) {
            this.clusterAlias = clusterAlias;
            this.skipOnFailure = skipOnFailure;
            this.countDown = countDown;
            this.exceptions = exceptions;
            this.clusters = clusters;
            this.originalListener = originalListener;
        }

        @Override
        public final void onResponse(Response response) {
            this.innerOnResponse(response);
            this.maybeFinish();
        }

        abstract void innerOnResponse(Response var1);

        @Override
        public final void onFailure(Exception e) {
            ShardSearchFailure f = new ShardSearchFailure(e);
            TransportSearchAction.logCCSError(f, this.clusterAlias, this.skipOnFailure);
            SearchResponse.Cluster cluster = this.clusters.getCluster(this.clusterAlias);
            if (this.skipOnFailure && !ExceptionsHelper.isTaskCancelledException(e)) {
                if (cluster != null) {
                    TransportSearchAction.ccsClusterInfoUpdate(f, this.clusters, this.clusterAlias, true);
                }
            } else {
                if (cluster != null) {
                    TransportSearchAction.ccsClusterInfoUpdate(f, this.clusters, this.clusterAlias, false);
                }
                Exception exception = e;
                if (!"".equals(this.clusterAlias) && !ExceptionsHelper.isTaskCancelledException(e)) {
                    exception = TransportSearchAction.wrapRemoteClusterFailure(this.clusterAlias, e);
                }
                if (!this.exceptions.compareAndSet(null, exception)) {
                    this.exceptions.accumulateAndGet(exception, (previous, current) -> {
                        current.addSuppressed((Throwable)previous);
                        return current;
                    });
                }
            }
            this.maybeFinish();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void maybeFinish() {
            if (this.countDown.countDown()) {
                Exception exception = this.exceptions.get();
                if (exception == null) {
                    FinalResponse response;
                    try {
                        response = this.createFinalResponse();
                    }
                    catch (Exception e) {
                        this.originalListener.onFailure(e);
                        return;
                    }
                    try {
                        this.originalListener.onResponse(response);
                    }
                    finally {
                        this.releaseResponse(response);
                    }
                }
                this.originalListener.onFailure(this.exceptions.get());
            }
        }

        protected void releaseResponse(FinalResponse response) {
        }

        abstract FinalResponse createFinalResponse();
    }

    static interface SearchPhaseProvider {
        public void runNewSearchPhase(SearchTask var1, SearchRequest var2, Executor var3, List<SearchShardIterator> var4, SearchTimeProvider var5, BiFunction<String, String, Transport.Connection> var6, ClusterState var7, Map<String, AliasFilter> var8, Map<String, Float> var9, boolean var10, ThreadPool var11, SearchResponse.Clusters var12, Map<String, Object> var13);
    }

    private static class SearchTelemetryListener
    extends DelegatingActionListener<SearchResponse, SearchResponse> {
        private final CCSUsage.Builder usageBuilder;
        private final SearchResponseMetrics searchResponseMetrics;
        private final long nowInMillis;
        private final UsageService usageService;
        private final boolean collectCCSTelemetry;
        private final Map<String, Object> searchRequestAttributes;

        SearchTelemetryListener(ActionListener<SearchResponse> listener, SearchResponseMetrics searchResponseMetrics, Map<String, Object> searchRequestAttributes, long nowInMillis, UsageService usageService, CCSUsage.Builder usageBuilder) {
            super(listener);
            this.searchResponseMetrics = searchResponseMetrics;
            this.searchRequestAttributes = searchRequestAttributes;
            this.nowInMillis = nowInMillis;
            this.collectCCSTelemetry = true;
            this.usageService = usageService;
            this.usageBuilder = usageBuilder;
        }

        SearchTelemetryListener(ActionListener<SearchResponse> listener, SearchResponseMetrics searchResponseMetrics, Map<String, Object> searchRequestAttributes, long nowInMillis) {
            super(listener);
            this.searchResponseMetrics = searchResponseMetrics;
            this.searchRequestAttributes = searchRequestAttributes;
            this.nowInMillis = nowInMillis;
            this.collectCCSTelemetry = false;
            this.usageService = null;
            this.usageBuilder = null;
        }

        @Override
        public void onResponse(SearchResponse searchResponse) {
            try {
                this.searchResponseMetrics.recordTookTime(searchResponse.getTookInMillis(), searchResponse.getTimeRangeFilterFromMillis(), this.nowInMillis, this.searchRequestAttributes);
                SearchResponseMetrics.ResponseCountTotalStatus responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.SUCCESS;
                if (searchResponse.getShardFailures() != null && searchResponse.getShardFailures().length > 0) {
                    ShardOperationFailedException[] groupedFailures;
                    for (ShardOperationFailedException f : groupedFailures = ExceptionsHelper.groupBy(searchResponse.getShardFailures())) {
                        boolean causeHas500Status = false;
                        if (f.getCause() != null) {
                            boolean bl = causeHas500Status = ExceptionsHelper.status(f.getCause()).getStatus() >= 500;
                        }
                        if (f.status().getStatus() < 500 && !causeHas500Status || ExceptionsHelper.isNodeOrShardUnavailableTypeException(f.getCause())) continue;
                        logger.warn("TransportSearchAction shard failure (partial results response)", (Throwable)f);
                        responseCountTotalStatus = SearchResponseMetrics.ResponseCountTotalStatus.PARTIAL_FAILURE;
                    }
                }
                this.searchResponseMetrics.incrementResponseCount(responseCountTotalStatus, this.searchRequestAttributes);
                if (this.collectCCSTelemetry) {
                    this.extractCCSTelemetry(searchResponse);
                    this.recordTelemetry();
                }
            }
            catch (Exception e) {
                this.onFailure(e);
                return;
            }
            this.delegate.onResponse(searchResponse);
        }

        @Override
        public void onFailure(Exception e) {
            this.searchResponseMetrics.incrementResponseCount(SearchResponseMetrics.ResponseCountTotalStatus.FAILURE, this.searchRequestAttributes);
            if (this.collectCCSTelemetry) {
                this.usageBuilder.setFailure(e);
                this.recordTelemetry();
            }
            super.onFailure(e);
        }

        private void recordTelemetry() {
            this.usageService.getCcsUsageHolder().updateUsage(this.usageBuilder.build());
        }

        private void extractCCSTelemetry(SearchResponse searchResponse) {
            this.usageBuilder.took(searchResponse.getTookInMillis());
            for (String clusterAlias : searchResponse.getClusters().getClusterAliases()) {
                SearchResponse.Cluster cluster = searchResponse.getClusters().getCluster(clusterAlias);
                if (cluster.getStatus() == SearchResponse.Cluster.Status.SKIPPED) {
                    this.usageBuilder.skippedRemote(clusterAlias);
                    continue;
                }
                this.usageBuilder.perClusterUsage(clusterAlias, cluster.getTook());
            }
        }
    }

    private class AsyncSearchActionProvider
    implements SearchPhaseProvider {
        private final ActionListener<SearchResponse> listener;

        AsyncSearchActionProvider(ActionListener<SearchResponse> listener) {
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runNewSearchPhase(SearchTask task, SearchRequest searchRequest, Executor executor, List<SearchShardIterator> shardIterators, SearchTimeProvider timeProvider, BiFunction<String, String, Transport.Connection> connectionLookup, ClusterState clusterState, Map<String, AliasFilter> aliasFilter, Map<String, Float> concreteIndexBoosts, boolean preFilter, ThreadPool threadPool, SearchResponse.Clusters clusters, Map<String, Object> searchRequestAttributes) {
            if (preFilter) {
                boolean requireAtLeastOneMatch = searchRequest.source() != null && searchRequest.source().aggregations() != null;
                CanMatchPreFilterSearchPhase.execute(logger, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, threadPool.executor("search_coordination"), searchRequest, shardIterators, timeProvider, task, requireAtLeastOneMatch, TransportSearchAction.this.searchService.getCoordinatorRewriteContextProvider(timeProvider::absoluteStartMillis), TransportSearchAction.this.searchResponseMetrics, searchRequestAttributes).addListener(this.listener.delegateFailureAndWrap((l, iters) -> this.runNewSearchPhase(task, searchRequest, executor, (List<SearchShardIterator>)iters, timeProvider, connectionLookup, clusterState, aliasFilter, concreteIndexBoosts, false, threadPool, clusters, searchRequestAttributes)));
                return;
            }
            if (!clusters.isCcsMinimizeRoundtrips().booleanValue() && clusters.hasRemoteClusters() && task.getProgressListener() == SearchProgressListener.NOOP) {
                task.setProgressListener(new CCSSingleCoordinatorSearchProgressListener());
            }
            SearchPhaseResults<SearchPhaseResult> queryResultConsumer = TransportSearchAction.this.searchPhaseController.newSearchPhaseResults(executor, TransportSearchAction.this.circuitBreaker, task::isCancelled, task.getProgressListener(), searchRequest, shardIterators.size(), exc -> TransportSearchAction.this.searchTransportService.cancelSearchTask(task, "failed to merge result [" + exc.getMessage() + "]"));
            boolean success = false;
            try {
                AbstractSearchAsyncAction searchPhase;
                if (searchRequest.searchType() == SearchType.DFS_QUERY_THEN_FETCH) {
                    searchPhase = new SearchDfsQueryThenFetchAsyncAction(logger, TransportSearchAction.this.namedWriteableRegistry, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, queryResultConsumer, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, clusters, TransportSearchAction.this.client, TransportSearchAction.this.searchResponseMetrics, searchRequestAttributes);
                } else {
                    assert (searchRequest.searchType() == SearchType.QUERY_THEN_FETCH) : searchRequest.searchType();
                    searchPhase = new SearchQueryThenFetchAsyncAction(logger, TransportSearchAction.this.namedWriteableRegistry, TransportSearchAction.this.searchTransportService, connectionLookup, aliasFilter, concreteIndexBoosts, executor, queryResultConsumer, searchRequest, this.listener, shardIterators, timeProvider, clusterState, task, clusters, TransportSearchAction.this.client, TransportSearchAction.this.searchService.batchQueryPhase(), TransportSearchAction.this.searchResponseMetrics, searchRequestAttributes);
                }
                success = true;
                searchPhase.start();
            }
            finally {
                if (!success) {
                    queryResultConsumer.close();
                }
            }
        }
    }
}

