/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.util.Collections;
import java.util.Map;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.profile.SearchProfileResults;
import org.elasticsearch.search.profile.SearchProfileShardResult;
import org.elasticsearch.search.suggest.Suggest;

public class SearchResponseSections
implements Releasable {
    public static final SearchResponseSections EMPTY_WITH_TOTAL_HITS = new SearchResponseSections(SearchHits.EMPTY_WITH_TOTAL_HITS, null, null, false, null, null, 1, null);
    public static final SearchResponseSections EMPTY_WITHOUT_TOTAL_HITS = new SearchResponseSections(SearchHits.EMPTY_WITHOUT_TOTAL_HITS, null, null, false, null, null, 1, null);
    protected final SearchHits hits;
    protected final InternalAggregations aggregations;
    protected final Suggest suggest;
    protected final SearchProfileResults profileResults;
    protected final boolean timedOut;
    protected final Boolean terminatedEarly;
    protected final int numReducePhases;
    protected final Long timeRangeFilterFromMillis;

    public SearchResponseSections(SearchHits hits, InternalAggregations aggregations, Suggest suggest, boolean timedOut, Boolean terminatedEarly, SearchProfileResults profileResults, int numReducePhases, Long timeRangeFilterFromMillis) {
        this.hits = hits;
        this.aggregations = aggregations;
        this.suggest = suggest;
        this.profileResults = profileResults;
        this.timedOut = timedOut;
        this.terminatedEarly = terminatedEarly;
        this.numReducePhases = numReducePhases;
        this.timeRangeFilterFromMillis = timeRangeFilterFromMillis;
    }

    public final SearchHits hits() {
        return this.hits;
    }

    public final Suggest suggest() {
        return this.suggest;
    }

    public final Map<String, SearchProfileShardResult> profile() {
        if (this.profileResults == null) {
            return Collections.emptyMap();
        }
        return this.profileResults.getShardResults();
    }

    public void close() {
        this.hits.decRef();
    }
}

