/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.internal.ShardSearchContextId;

public final class SearchContextIdForNode
implements Writeable {
    private final String node;
    private final ShardSearchContextId searchContextId;
    private final String clusterAlias;

    SearchContextIdForNode(@Nullable String clusterAlias, @Nullable String node, @Nullable ShardSearchContextId searchContextId) {
        this.node = node;
        this.clusterAlias = clusterAlias;
        this.searchContextId = searchContextId;
    }

    SearchContextIdForNode(StreamInput in) throws IOException {
        this.node = in.readOptionalString();
        this.clusterAlias = in.readOptionalString();
        this.searchContextId = in.readOptionalWriteable(ShardSearchContextId::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.node);
        out.writeOptionalString(this.clusterAlias);
        out.writeOptionalWriteable(this.searchContextId);
    }

    @Nullable
    public String getNode() {
        return this.node;
    }

    @Nullable
    public String getClusterAlias() {
        return this.clusterAlias;
    }

    @Nullable
    public ShardSearchContextId getSearchContextId() {
        return this.searchContextId;
    }

    public String toString() {
        return "SearchContextIdForNode{node='" + this.node + "', seachContextId=" + String.valueOf(this.searchContextId) + ", clusterAlias='" + this.clusterAlias + "'}";
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchContextIdForNode that = (SearchContextIdForNode)o;
        return Objects.equals(this.node, that.node) && Objects.equals(this.searchContextId, that.searchContextId) && Objects.equals(this.clusterAlias, that.clusterAlias);
    }

    public int hashCode() {
        return Objects.hash(this.node, this.searchContextId, this.clusterAlias);
    }
}

