/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.automaton.TooComplexToDeterminizeException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.ResolvedIndexExpression;
import org.elasticsearch.action.ResolvedIndexExpressions;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFailure;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesFetcher;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeResponse;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.fieldcaps.RequestDispatcher;
import org.elasticsearch.action.search.TransportSearchHelper;
import org.elasticsearch.action.support.AbstractThreadedActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.RefCountingRunnable;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThrottledTaskRunner;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.crossproject.CrossProjectIndexResolutionValidator;
import org.elasticsearch.search.crossproject.CrossProjectModeDecider;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesAction
extends HandledTransportAction<FieldCapabilitiesRequest, FieldCapabilitiesResponse> {
    public static final String EXCLUSION = "-";
    public static final String NAME = "indices:data/read/field_caps";
    public static final ActionType<FieldCapabilitiesResponse> TYPE = new ActionType("indices:data/read/field_caps");
    public static final RemoteClusterActionType<FieldCapabilitiesResponse> REMOTE_TYPE = new RemoteClusterActionType<FieldCapabilitiesResponse>("indices:data/read/field_caps", FieldCapabilitiesResponse::new);
    public static final String ACTION_NODE_NAME = "indices:data/read/field_caps[n]";
    public static final Logger LOGGER = LogManager.getLogger(TransportFieldCapabilitiesAction.class);
    private final Executor searchCoordinationExecutor;
    private final TransportService transportService;
    private final ClusterService clusterService;
    private final ProjectResolver projectResolver;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final IndicesService indicesService;
    private final boolean ccsCheckCompatibility;
    private final ThreadPool threadPool;
    private final TimeValue forceConnectTimeoutSecs;
    private final CrossProjectModeDecider crossProjectModeDecider;

    @Inject
    public TransportFieldCapabilitiesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndicesService indicesService, ProjectResolver projectResolver, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(NAME, transportService, actionFilters, FieldCapabilitiesRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.searchCoordinationExecutor = threadPool.executor("search_coordination");
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.projectResolver = projectResolver;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indicesService = indicesService;
        transportService.registerRequestHandler(ACTION_NODE_NAME, this.searchCoordinationExecutor, FieldCapabilitiesNodeRequest::new, new NodeTransportHandler());
        this.ccsCheckCompatibility = SearchService.CCS_VERSION_CHECK_SETTING.get(clusterService.getSettings());
        this.threadPool = threadPool;
        this.forceConnectTimeoutSecs = clusterService.getSettings().getAsTime("search.ccs.force_connect_timeout", null);
        this.crossProjectModeDecider = new CrossProjectModeDecider(clusterService.getSettings());
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesRequest request, ActionListener<FieldCapabilitiesResponse> listener) {
        this.executeRequest(task, request, new LinkedRequestExecutor<FieldCapabilitiesResponse>(this){

            @Override
            public void executeRemoteRequest(TransportService transportService, Transport.Connection conn, FieldCapabilitiesRequest remoteRequest, ActionListenerResponseHandler<FieldCapabilitiesResponse> responseHandler) {
                transportService.sendRequest(conn, REMOTE_TYPE.name(), (TransportRequest)remoteRequest, TransportRequestOptions.EMPTY, responseHandler);
            }

            @Override
            public FieldCapabilitiesResponse read(StreamInput in) throws IOException {
                return new FieldCapabilitiesResponse(in);
            }

            @Override
            public FieldCapabilitiesResponse wrapPrimary(FieldCapabilitiesResponse primary) {
                return primary;
            }

            @Override
            public FieldCapabilitiesResponse unwrapPrimary(FieldCapabilitiesResponse fieldCapabilitiesResponse) {
                return fieldCapabilitiesResponse;
            }
        }, listener);
    }

    public <R extends ActionResponse> void executeRequest(Task task, FieldCapabilitiesRequest request, LinkedRequestExecutor<R> linkedRequestExecutor, ActionListener<R> listener) {
        this.searchCoordinationExecutor.execute(ActionRunnable.wrap(listener, l -> this.doExecuteForked(task, request, linkedRequestExecutor, (ActionListener)l)));
    }

    private <R extends ActionResponse> void doExecuteForked(Task task, FieldCapabilitiesRequest request, LinkedRequestExecutor<R> linkedRequestExecutor, ActionListener<R> listener) {
        String[] concreteLocalIndices;
        List<ResolvedIndexExpression> resolvedLocallyList;
        if (this.ccsCheckCompatibility) {
            TransportSearchHelper.checkCCSVersionCompatibility(request);
        }
        Executor singleThreadedExecutor = this.buildSingleThreadedExecutor();
        assert (task instanceof CancellableTask);
        CancellableTask fieldCapTask = (CancellableTask)task;
        long nowInMillis = request.nowInMillis() == null ? System.currentTimeMillis() : request.nowInMillis();
        ProjectState projectState = this.projectResolver.getProjectState(this.clusterService.state());
        AtomicReference<TransportVersion> minTransportVersion = new AtomicReference<TransportVersion>(this.clusterService.state().getMinTransportVersion());
        IndicesOptions originalIndicesOptions = request.indicesOptions();
        boolean resolveCrossProject = this.crossProjectModeDecider.resolvesCrossProject(request);
        Map<String, OriginalIndices> remoteClusterIndices = this.transportService.getRemoteClusterService().groupIndices(resolveCrossProject ? CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(originalIndicesOptions) : originalIndicesOptions, request.indices(), request.returnLocalAll());
        OriginalIndices localIndices = remoteClusterIndices.remove("");
        if (request.getResolvedIndexExpressions() != null) {
            resolvedLocallyList = request.getResolvedIndexExpressions().expressions();
            concreteLocalIndices = (String[])resolvedLocallyList.stream().map(r -> r.localExpressions().indices()).flatMap(Collection::stream).distinct().toArray(String[]::new);
        } else {
            resolvedLocallyList = new ArrayList<ResolvedIndexExpression>();
            if (localIndices == null) {
                concreteLocalIndices = Strings.EMPTY_ARRAY;
            } else {
                concreteLocalIndices = this.indexNameExpressionResolver.concreteIndexNames(projectState.metadata(), (IndicesRequest)localIndices);
                if (request.includeResolvedTo()) {
                    ProjectMetadata projectMetadata = projectState.metadata();
                    IndicesOptions indicesOptions = localIndices.indicesOptions();
                    String[] localIndexNames = localIndices.indices();
                    if (localIndexNames.length == 0) {
                        String[] concreteIndexNames = this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, indicesOptions, new String[0]);
                        resolvedLocallyList.add(TransportFieldCapabilitiesAction.createResolvedIndexExpression("_all", concreteIndexNames));
                    } else if (!IndexNameExpressionResolver.isNoneExpression(localIndexNames)) {
                        for (String localIndexName : localIndexNames) {
                            if (localIndexName.startsWith(EXCLUSION)) continue;
                            String[] concreteIndexNames = this.indexNameExpressionResolver.concreteIndexNames(projectMetadata, indicesOptions, localIndices.includeDataStreams(), localIndexName);
                            resolvedLocallyList.add(TransportFieldCapabilitiesAction.createResolvedIndexExpression(localIndexName, concreteIndexNames));
                        }
                    }
                }
            }
        }
        if (concreteLocalIndices.length == 0 && remoteClusterIndices.isEmpty()) {
            FieldCapabilitiesResponse.Builder responseBuilder = FieldCapabilitiesResponse.builder();
            responseBuilder.withMinTransportVersion(minTransportVersion.get());
            if (request.includeResolvedTo()) {
                responseBuilder.withResolvedLocally(new ResolvedIndexExpressions(resolvedLocallyList));
            }
            listener.onResponse(linkedRequestExecutor.wrapPrimary(responseBuilder.build()));
            return;
        }
        TransportFieldCapabilitiesAction.checkIndexBlocks(projectState, concreteLocalIndices);
        FailureCollector indexFailures = new FailureCollector();
        HashMap indexResponses = new HashMap();
        HashMap indexMappingHashToResponses = new HashMap();
        Runnable releaseResourcesOnCancel = () -> {
            LOGGER.trace("clear index responses on cancellation");
            indexFailures.clear();
            indexResponses.clear();
            indexMappingHashToResponses.clear();
        };
        ConcurrentHashMap<String, ResolvedIndexExpressions.Builder> resolvedRemotelyBuilder = new ConcurrentHashMap<String, ResolvedIndexExpressions.Builder>();
        for (String clusterAlias : remoteClusterIndices.keySet()) {
            resolvedRemotelyBuilder.put(clusterAlias, ResolvedIndexExpressions.builder());
        }
        Consumer<FieldCapabilitiesIndexResponse> handleIndexResponse = resp -> {
            FieldCapabilitiesIndexResponse curr;
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            if (resp.canMatch() && resp.getIndexMappingHash() != null && (curr = indexMappingHashToResponses.putIfAbsent(resp.getIndexMappingHash(), resp)) != null) {
                resp = new FieldCapabilitiesIndexResponse(resp.getIndexName(), curr.getIndexMappingHash(), curr.get(), true, curr.getIndexMode());
            }
            if (request.includeEmptyFields()) {
                indexResponses.putIfAbsent(resp.getIndexName(), resp);
            } else {
                indexResponses.merge(resp.getIndexName(), resp, (a, b) -> {
                    if (a.get().equals(b.get())) {
                        return a;
                    }
                    HashMap<String, IndexFieldCapabilities> mergedCaps = new HashMap<String, IndexFieldCapabilities>(a.get());
                    mergedCaps.putAll(b.get());
                    return new FieldCapabilitiesIndexResponse(a.getIndexName(), a.getIndexMappingHash(), mergedCaps, true, a.getIndexMode());
                });
            }
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        BiConsumer<String, Exception> handleIndexFailure = (index, error) -> {
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
                return;
            }
            indexFailures.collect((String)index, (Exception)error);
            if (fieldCapTask.isCancelled()) {
                releaseResourcesOnCancel.run();
            }
        };
        AtomicBoolean finishedOrCancelled = new AtomicBoolean();
        fieldCapTask.addListener(() -> {
            if (finishedOrCancelled.compareAndSet(false, true)) {
                singleThreadedExecutor.execute(releaseResourcesOnCancel);
                LOGGER.trace("clear index responses on cancellation submitted");
            }
        });
        try (RefCountingRunnable refs = new RefCountingRunnable(() -> {
            finishedOrCancelled.set(true);
            if (fieldCapTask.notifyIfCancelled(listener)) {
                releaseResourcesOnCancel.run();
            } else {
                ElasticsearchException ex;
                Map<String, ResolvedIndexExpressions> resolvedRemotely = resolvedRemotelyBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResolvedIndexExpressions.Builder)e.getValue()).build()));
                ResolvedIndexExpressions resolvedLocally = new ResolvedIndexExpressions(resolvedLocallyList);
                if (resolveCrossProject && (ex = CrossProjectIndexResolutionValidator.validate(request.indicesOptions(), request.getProjectRouting(), resolvedLocally, resolvedRemotely)) != null) {
                    listener.onFailure(ex);
                    return;
                }
                TransportFieldCapabilitiesAction.mergeIndexResponses(request, fieldCapTask, indexResponses, indexFailures, resolvedLocally, resolvedRemotely, minTransportVersion, listener.map(linkedRequestExecutor::wrapPrimary));
            }
        });){
            RequestDispatcher requestDispatcher = new RequestDispatcher(this.clusterService, this.transportService, this.projectResolver, this.indicesService.getCoordinatorRewriteContextProvider(() -> nowInMillis), task, request, localIndices, nowInMillis, concreteLocalIndices, singleThreadedExecutor, handleIndexResponse, handleIndexFailure, () -> ((Releasable)refs.acquire()).close());
            requestDispatcher.execute();
            for (Map.Entry<String, OriginalIndices> remoteIndices : remoteClusterIndices.entrySet()) {
                String clusterAlias = remoteIndices.getKey();
                OriginalIndices originalIndices = remoteIndices.getValue();
                FieldCapabilitiesRequest remoteRequest = TransportFieldCapabilitiesAction.prepareRemoteRequest(clusterAlias, request, originalIndices, nowInMillis, resolveCrossProject);
                ActionListener remoteListener = ActionListener.wrap(response -> {
                    ResolvedIndexExpressions resolvedOnRemoteProject;
                    if (request.includeResolvedTo() && response.getResolvedLocally() != null && (resolvedOnRemoteProject = response.getResolvedLocally()) != null) {
                        for (ResolvedIndexExpression remoteResolvedExpression : resolvedOnRemoteProject.expressions()) {
                            resolvedRemotelyBuilder.computeIfPresent(clusterAlias, (k, v) -> {
                                v.addExpression(remoteResolvedExpression);
                                return v;
                            });
                        }
                    }
                    for (FieldCapabilitiesIndexResponse resp : response.getIndexResponses()) {
                        String indexName = RemoteClusterAware.buildRemoteIndexName(clusterAlias, resp.getIndexName());
                        handleIndexResponse.accept(new FieldCapabilitiesIndexResponse(indexName, resp.getIndexMappingHash(), resp.get(), resp.canMatch(), resp.getIndexMode()));
                    }
                    for (FieldCapabilitiesFailure failure : response.getFailures()) {
                        Exception ex = failure.getException();
                        for (String index : failure.getIndices()) {
                            handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index), ex);
                            if (!request.includeResolvedTo()) continue;
                            ResolvedIndexExpression err = new ResolvedIndexExpression(index, new ResolvedIndexExpression.LocalExpressions(Set.of(), ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE, null), Set.of());
                            resolvedRemotelyBuilder.computeIfPresent(clusterAlias, (k, v) -> {
                                v.addExpression(err);
                                return v;
                            });
                        }
                    }
                    minTransportVersion.accumulateAndGet(response.minTransportVersion(), (lhs, rhs) -> {
                        if (lhs == null || rhs == null) {
                            return null;
                        }
                        return TransportVersion.min(lhs, rhs);
                    });
                }, ex -> {
                    for (String index : originalIndices.indices()) {
                        handleIndexFailure.accept(RemoteClusterAware.buildRemoteIndexName(clusterAlias, index), (Exception)ex);
                        if (!request.includeResolvedTo()) continue;
                        ResolvedIndexExpression err = new ResolvedIndexExpression(index, new ResolvedIndexExpression.LocalExpressions(Set.of(), ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE, null), Set.of());
                        resolvedRemotelyBuilder.computeIfPresent(clusterAlias, (k, v) -> {
                            v.addExpression(err);
                            return v;
                        });
                    }
                });
                SubscribableListener<Transport.Connection> connectionListener = new SubscribableListener<Transport.Connection>();
                if (this.forceConnectTimeoutSecs != null) {
                    connectionListener.addTimeout(this.forceConnectTimeoutSecs, this.threadPool, singleThreadedExecutor);
                }
                connectionListener.addListener(new ForkingOnFailureActionListener(singleThreadedExecutor, true, ActionListener.releaseAfter(remoteListener, refs.acquire())).delegateFailure((responseListener, conn) -> linkedRequestExecutor.executeRemoteRequest(this.transportService, (Transport.Connection)conn, remoteRequest, new ActionListenerResponseHandler<FieldCapabilitiesResponse>((ActionListener<FieldCapabilitiesResponse>)responseListener, in -> linkedRequestExecutor.unwrapPrimary(linkedRequestExecutor.read(in)), singleThreadedExecutor))));
                boolean ensureConnected = this.forceConnectTimeoutSecs != null || this.transportService.getRemoteClusterService().isSkipUnavailable(clusterAlias).orElse(true) == false;
                this.transportService.getRemoteClusterService().maybeEnsureConnectedAndGetConnection(clusterAlias, ensureConnected, connectionListener);
            }
        }
    }

    private static ResolvedIndexExpression createResolvedIndexExpression(String original, String[] concreteIndexNames) {
        boolean isWildcard = Regex.isSimpleMatchPattern(original);
        ResolvedIndexExpression.LocalIndexResolutionResult resolutionResult = concreteIndexNames.length > 0 || isWildcard ? ResolvedIndexExpression.LocalIndexResolutionResult.SUCCESS : ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE;
        return new ResolvedIndexExpression(original, new ResolvedIndexExpression.LocalExpressions(Set.of(concreteIndexNames), resolutionResult, null), Collections.emptySet());
    }

    private Executor buildSingleThreadedExecutor() {
        ThrottledTaskRunner throttledTaskRunner = new ThrottledTaskRunner("field_caps", 1, this.searchCoordinationExecutor);
        return r -> throttledTaskRunner.enqueueTask(new ActionListener<Releasable>(){

            @Override
            public void onResponse(Releasable releasable) {
                try (Releasable releasable2 = releasable;){
                    r.run();
                }
            }

            @Override
            public void onFailure(Exception e) {
                if (r instanceof AbstractRunnable) {
                    AbstractRunnable abstractRunnable = (AbstractRunnable)r;
                    abstractRunnable.onFailure(e);
                } else {
                    TransportFieldCapabilitiesAction.this.logger.error("unexpected failure running " + String.valueOf(r), (Throwable)e);
                    assert (false) : new AssertionError("unexpected failure running " + String.valueOf(r), e);
                }
            }
        });
    }

    private static void checkIndexBlocks(ProjectState projectState, String[] concreteIndices) {
        ProjectId projectId;
        ClusterBlocks blocks = projectState.blocks();
        if (blocks.global(projectId = projectState.projectId()).isEmpty() && blocks.indices(projectId).isEmpty()) {
            return;
        }
        blocks.globalBlockedRaiseException(projectId, ClusterBlockLevel.READ);
        for (String index : concreteIndices) {
            blocks.indexBlockedRaiseException(projectState.projectId(), ClusterBlockLevel.READ, index);
        }
    }

    private static void mergeIndexResponses(FieldCapabilitiesRequest request, CancellableTask task, Map<String, FieldCapabilitiesIndexResponse> indexResponses, FailureCollector indexFailures, ResolvedIndexExpressions resolvedLocally, Map<String, ResolvedIndexExpressions> resolvedRemotely, AtomicReference<TransportVersion> minTransportVersion, ActionListener<FieldCapabilitiesResponse> listener) {
        List<FieldCapabilitiesFailure> failures = indexFailures.build(indexResponses.keySet());
        if (!indexResponses.isEmpty()) {
            if (request.isMergeResults()) {
                ActionListener.completeWith(listener, () -> TransportFieldCapabilitiesAction.merge(indexResponses, resolvedLocally, resolvedRemotely, task, request, failures, minTransportVersion));
            } else {
                listener.onResponse(FieldCapabilitiesResponse.builder().withIndexResponses(new ArrayList<FieldCapabilitiesIndexResponse>(indexResponses.values())).withResolvedLocally(resolvedLocally).withResolvedRemotely(resolvedRemotely).withMinTransportVersion(minTransportVersion.get()).withFailures(failures).build());
            }
        } else if (!indexFailures.isEmpty()) {
            if (failures.stream().anyMatch(failure -> {
                IllegalStateException ise;
                Exception patt0$temp = failure.getException();
                return patt0$temp instanceof IllegalStateException && (ise = (IllegalStateException)patt0$temp).getCause() instanceof ElasticsearchTimeoutException;
            })) {
                listener.onResponse(FieldCapabilitiesResponse.builder().withFailures(failures).withResolvedLocally(resolvedLocally).withResolvedRemotely(resolvedRemotely).withMinTransportVersion(minTransportVersion.get()).build());
            } else {
                listener.onFailure(failures.get(0).getException());
            }
        } else {
            listener.onResponse(FieldCapabilitiesResponse.builder().withMinTransportVersion(minTransportVersion.get()).build());
        }
    }

    private static FieldCapabilitiesRequest prepareRemoteRequest(String clusterAlias, FieldCapabilitiesRequest request, OriginalIndices originalIndices, long nowInMillis, boolean resolveCrossProject) {
        IndicesOptions indicesOptions = originalIndices.indicesOptions();
        if (indicesOptions.resolveCrossProjectIndexExpression()) {
            indicesOptions = CrossProjectIndexResolutionValidator.indicesOptionsForCrossProjectFanout(indicesOptions);
        }
        FieldCapabilitiesRequest remoteRequest = new FieldCapabilitiesRequest();
        remoteRequest.clusterAlias(clusterAlias);
        remoteRequest.setMergeResults(false);
        remoteRequest.indicesOptions(indicesOptions);
        remoteRequest.indices(originalIndices.indices());
        remoteRequest.fields(request.fields());
        remoteRequest.filters(request.filters());
        remoteRequest.types(request.types());
        remoteRequest.runtimeFields(request.runtimeFields());
        remoteRequest.indexFilter(request.indexFilter());
        remoteRequest.nowInMillis(nowInMillis);
        remoteRequest.includeEmptyFields(request.includeEmptyFields());
        remoteRequest.includeResolvedTo(request.includeResolvedTo() || resolveCrossProject);
        return remoteRequest;
    }

    private static boolean hasSameMappingHash(FieldCapabilitiesIndexResponse r1, FieldCapabilitiesIndexResponse r2) {
        return r1.getIndexMappingHash() != null && r2.getIndexMappingHash() != null && r1.getIndexMappingHash().equals(r2.getIndexMappingHash());
    }

    private static FieldCapabilitiesResponse merge(Map<String, FieldCapabilitiesIndexResponse> indexResponsesMap, ResolvedIndexExpressions resolvedLocally, Map<String, ResolvedIndexExpressions> resolvedRemotely, CancellableTask task, FieldCapabilitiesRequest request, List<FieldCapabilitiesFailure> failures, AtomicReference<TransportVersion> minTransportVersion) {
        assert (ThreadPool.assertCurrentThreadPool("search_coordination"));
        task.ensureNotCancelled();
        FieldCapabilitiesIndexResponse[] indexResponses = indexResponsesMap.values().toArray(new FieldCapabilitiesIndexResponse[0]);
        Arrays.sort(indexResponses, Comparator.comparing(FieldCapabilitiesIndexResponse::getIndexName));
        Object[] indices = (String[])Arrays.stream(indexResponses).map(FieldCapabilitiesIndexResponse::getIndexName).toArray(String[]::new);
        HashMap<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder = new HashMap<String, Map<String, FieldCapabilities.Builder>>();
        int lastPendingIndex = 0;
        for (int i = 1; i <= indexResponses.length; ++i) {
            if (i != indexResponses.length && TransportFieldCapabilitiesAction.hasSameMappingHash(indexResponses[lastPendingIndex], indexResponses[i])) continue;
            Object[] subIndices = lastPendingIndex == 0 && i == indexResponses.length ? indices : (String[])ArrayUtil.copyOfSubArray((Object[])indices, (int)lastPendingIndex, (int)i);
            TransportFieldCapabilitiesAction.innerMerge((String[])subIndices, fieldsBuilder, indexResponses[lastPendingIndex]);
            lastPendingIndex = i;
        }
        task.ensureNotCancelled();
        Map<String, Map<String, FieldCapabilities>> fields = Maps.newMapWithExpectedSize(fieldsBuilder.size());
        if (request.includeUnmapped()) {
            TransportFieldCapabilitiesAction.collectFieldsIncludingUnmapped((String[])indices, fieldsBuilder, fields, request.includeIndices());
        } else {
            TransportFieldCapabilitiesAction.collectFields(fieldsBuilder, fields, request.includeIndices());
        }
        List failedIndices = failures.stream().flatMap(f -> Arrays.stream(f.getIndices())).toList();
        List<ResolvedIndexExpression> collect = resolvedLocally.expressions().stream().map(expression -> {
            if (failedIndices.contains(expression.original())) {
                return new ResolvedIndexExpression(expression.original(), new ResolvedIndexExpression.LocalExpressions(Set.of(), ResolvedIndexExpression.LocalIndexResolutionResult.CONCRETE_RESOURCE_NOT_VISIBLE, null), expression.remoteExpressions());
            }
            return expression;
        }).toList();
        for (FieldCapabilitiesFailure failure : failures) {
            if (!TransportFieldCapabilitiesAction.shouldLogException(failure.getException())) continue;
            LOGGER.warn("Field caps partial-results Exception for indices " + Arrays.toString(failure.getIndices()), (Throwable)failure.getException());
        }
        FieldCapabilitiesResponse.Builder responseBuilder = FieldCapabilitiesResponse.builder().withIndices((String[])indices).withFields(Collections.unmodifiableMap(fields)).withFailures(failures).withMinTransportVersion(minTransportVersion.get());
        if (request.includeResolvedTo() && minTransportVersion.get().supports(FieldCapabilitiesRequest.RESOLVED_FIELDS_CAPS)) {
            responseBuilder.withResolvedLocally(new ResolvedIndexExpressions(collect)).withResolvedRemotely(resolvedRemotely);
        }
        return responseBuilder.build();
    }

    private static boolean shouldLogException(Exception e) {
        return !(e instanceof ConnectTransportException) && ExceptionsHelper.status(e).getStatus() >= 500 && !ExceptionsHelper.isNodeOrShardUnavailableTypeException(e);
    }

    private static void collectFieldsIncludingUnmapped(String[] indices, Map<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder, Map<String, Map<String, FieldCapabilities>> fieldsMap, boolean includeIndices) {
        HashSet<String> mappedScratch = new HashSet<String>();
        for (Map.Entry<String, Map<String, FieldCapabilities.Builder>> entry : fieldsBuilder.entrySet()) {
            Set<Map.Entry<String, FieldCapabilities.Builder>> typeMapBuilder = entry.getValue().entrySet();
            mappedScratch.clear();
            for (Map.Entry<String, FieldCapabilities.Builder> b : typeMapBuilder) {
                b.getValue().getIndices(mappedScratch);
            }
            Function<Boolean, FieldCapabilities> unmapped = TransportFieldCapabilitiesAction.getUnmappedFields(indices, entry.getKey(), mappedScratch);
            int resSize = typeMapBuilder.size() + (unmapped == null ? 0 : 1);
            Map<String, FieldCapabilities> res = TransportFieldCapabilitiesAction.capabilities(resSize, typeMapBuilder, includeIndices);
            if (unmapped != null) {
                res.put("unmapped", unmapped.apply(resSize > 1));
            }
            fieldsMap.put(entry.getKey(), Collections.unmodifiableMap(res));
        }
    }

    private static void collectFields(Map<String, Map<String, FieldCapabilities.Builder>> fieldsBuilder, Map<String, Map<String, FieldCapabilities>> fields, boolean includeIndices) {
        for (Map.Entry<String, Map<String, FieldCapabilities.Builder>> entry : fieldsBuilder.entrySet()) {
            Set<Map.Entry<String, FieldCapabilities.Builder>> typeMapBuilder = entry.getValue().entrySet();
            fields.put(entry.getKey(), Collections.unmodifiableMap(TransportFieldCapabilitiesAction.capabilities(typeMapBuilder.size(), typeMapBuilder, includeIndices)));
        }
    }

    private static Map<String, FieldCapabilities> capabilities(int resSize, Set<Map.Entry<String, FieldCapabilities.Builder>> builders, boolean includeIndices) {
        boolean multiTypes = resSize > 1;
        boolean withIndices = multiTypes || includeIndices;
        Map<String, FieldCapabilities> res = Maps.newHashMapWithExpectedSize(resSize);
        for (Map.Entry<String, FieldCapabilities.Builder> e : builders) {
            res.put(e.getKey(), e.getValue().build(withIndices));
        }
        return res;
    }

    @Nullable
    private static Function<Boolean, FieldCapabilities> getUnmappedFields(String[] indices, String field, Set<String> mappedIndices) {
        if (mappedIndices.size() != indices.length) {
            return mt -> {
                String[] diff;
                if (mt.booleanValue()) {
                    diff = new String[indices.length - mappedIndices.size()];
                    Iterator<String> indicesIter = Iterators.forArray(indices);
                    for (int i = 0; i < diff.length; ++i) {
                        diff[i] = TransportFieldCapabilitiesAction.nextIndex(indicesIter, mappedIndices);
                    }
                } else {
                    diff = null;
                }
                return new FieldCapabilities(field, "unmapped", false, false, false, false, null, diff, null, null, null, null, Map.of());
            };
        }
        return null;
    }

    private static String nextIndex(Iterator<String> iter, Set<String> filtered) {
        String index;
        while (filtered.contains(index = iter.next())) {
        }
        return index;
    }

    private static void innerMerge(String[] indices, Map<String, Map<String, FieldCapabilities.Builder>> responseMapBuilder, FieldCapabilitiesIndexResponse response) {
        Map<String, IndexFieldCapabilities> fields = response.get();
        for (Map.Entry<String, IndexFieldCapabilities> entry : fields.entrySet()) {
            String field = entry.getKey();
            IndexFieldCapabilities fieldCap = entry.getValue();
            Map typeMap = responseMapBuilder.computeIfAbsent(field, f -> new HashMap());
            FieldCapabilities.Builder builder = typeMap.computeIfAbsent(fieldCap.type(), key -> new FieldCapabilities.Builder(field, (String)key));
            builder.add(indices, fieldCap.isMetadatafield(), fieldCap.isSearchable(), fieldCap.isAggregatable(), fieldCap.isDimension(), fieldCap.metricType(), fieldCap.meta());
        }
    }

    private class NodeTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesNodeRequest> {
        private NodeTransportHandler() {
        }

        @Override
        public void messageReceived(FieldCapabilitiesNodeRequest request, TransportChannel channel, Task task) {
            assert (task instanceof CancellableTask);
            ChannelActionListener listener = new ChannelActionListener(channel);
            ActionListener.completeWith(listener, () -> {
                Predicate<String> fieldNameFilter;
                ArrayList<FieldCapabilitiesIndexResponse> allResponses = new ArrayList<FieldCapabilitiesIndexResponse>();
                HashMap<ShardId, Exception> allFailures = new HashMap<ShardId, Exception>();
                HashSet<ShardId> allUnmatchedShardIds = new HashSet<ShardId>();
                Map<String, List<ShardId>> groupedShardIds = request.shardIds().stream().collect(Collectors.groupingBy(ShardId::getIndexName));
                FieldCapabilitiesFetcher fetcher = new FieldCapabilitiesFetcher(TransportFieldCapabilitiesAction.this.indicesService, request.includeEmptyFields());
                try {
                    fieldNameFilter = Regex.simpleMatcher(request.fields());
                }
                catch (TooComplexToDeterminizeException e) {
                    throw new IllegalArgumentException("The field names are too complex to process. " + e.getMessage());
                }
                for (List<ShardId> shardIds : groupedShardIds.values()) {
                    HashMap<ShardId, Exception> failures = new HashMap<ShardId, Exception>();
                    HashSet<ShardId> unmatched = new HashSet<ShardId>();
                    for (ShardId shardId : shardIds) {
                        try {
                            FieldCapabilitiesIndexResponse response = fetcher.fetch((CancellableTask)task, shardId, fieldNameFilter, request.filters(), request.allowedTypes(), request.indexFilter(), request.nowInMillis(), request.runtimeFields());
                            if (response.canMatch()) {
                                allResponses.add(response);
                                if (!request.includeEmptyFields()) continue;
                                unmatched.clear();
                                failures.clear();
                                break;
                            }
                            unmatched.add(shardId);
                        }
                        catch (Exception e) {
                            failures.put(shardId, e);
                        }
                    }
                    allUnmatchedShardIds.addAll(unmatched);
                    allFailures.putAll(failures);
                }
                return new FieldCapabilitiesNodeResponse(allResponses, allFailures, allUnmatchedShardIds);
            });
        }
    }

    public static interface LinkedRequestExecutor<R extends ActionResponse> {
        public void executeRemoteRequest(TransportService var1, Transport.Connection var2, FieldCapabilitiesRequest var3, ActionListenerResponseHandler<FieldCapabilitiesResponse> var4);

        public R read(StreamInput var1) throws IOException;

        public R wrapPrimary(FieldCapabilitiesResponse var1);

        public FieldCapabilitiesResponse unwrapPrimary(R var1);
    }

    private static final class FailureCollector {
        private final Map<String, Exception> failuresByIndex = new HashMap<String, Exception>();

        private FailureCollector() {
        }

        List<FieldCapabilitiesFailure> build(Set<String> successfulIndices) {
            HashMap<Tuple, FieldCapabilitiesFailure> indexFailures = new HashMap<Tuple, FieldCapabilitiesFailure>();
            for (Map.Entry<String, Exception> failure : this.failuresByIndex.entrySet()) {
                String index = failure.getKey();
                Exception e = failure.getValue();
                if (e instanceof ElasticsearchTimeoutException) {
                    ElasticsearchTimeoutException ete = (ElasticsearchTimeoutException)e;
                    e = new IllegalStateException("Unable to open any connections", ete);
                }
                if (successfulIndices.contains(index)) continue;
                Throwable cause = ExceptionsHelper.unwrapCause(e);
                Tuple groupingKey = new Tuple((Object)cause.getMessage(), (Object)cause.getClass().getName());
                Exception ex = e;
                indexFailures.compute(groupingKey, (k, v) -> v == null ? new FieldCapabilitiesFailure(new String[]{index}, ex) : v.addIndex(index));
            }
            return new ArrayList<FieldCapabilitiesFailure>(indexFailures.values());
        }

        void collect(String index, Exception e) {
            this.failuresByIndex.putIfAbsent(index, e);
        }

        void clear() {
            this.failuresByIndex.clear();
        }

        boolean isEmpty() {
            return this.failuresByIndex.isEmpty();
        }
    }

    private static class ForkingOnFailureActionListener<Response>
    extends AbstractThreadedActionListener<Response> {
        ForkingOnFailureActionListener(Executor executor, boolean forceExecution, ActionListener<Response> delegate) {
            super(executor, forceExecution, delegate);
        }

        @Override
        public void onResponse(Response response) {
            this.delegate.onResponse(response);
        }
    }
}

