/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams.lifecycle;

import java.io.IOException;
import java.util.function.LongSupplier;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record ErrorEntry(long firstOccurrenceTimestamp, String error, long recordedTimestamp, int retryCount) implements Writeable,
ToXContentObject,
Comparable<ErrorEntry>
{
    public static final ParseField FIRST_OCCURRENCE_FIELD = new ParseField("first_occurrence", new String[0]);
    public static final ParseField FIRST_OCCURRENCE_MILLIS_FIELD = new ParseField("first_occurrence_millis", new String[0]);
    public static final ParseField MESSAGE_FIELD = new ParseField("message", new String[0]);
    public static final ParseField LAST_RECORDED_MILLIS_FIELD = new ParseField("last_recorded_millis", new String[0]);
    public static final ParseField LAST_RECORDED_FIELD = new ParseField("last_recorded", new String[0]);
    public static final ParseField RETRY_COUNT_FIELD = new ParseField("retry_count", new String[0]);

    public ErrorEntry(StreamInput in) throws IOException {
        this(in.readLong(), in.readString(), in.readLong(), in.readInt());
    }

    public static ErrorEntry incrementRetryCount(ErrorEntry existingRecord, LongSupplier nowSupplier) {
        return new ErrorEntry(existingRecord.firstOccurrenceTimestamp(), existingRecord.error(), nowSupplier.getAsLong(), existingRecord.retryCount() + 1);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.humanReadableField(FIRST_OCCURRENCE_MILLIS_FIELD.getPreferredName(), FIRST_OCCURRENCE_FIELD.getPreferredName(), (Object)new TimeValue(this.firstOccurrenceTimestamp));
        builder.field(MESSAGE_FIELD.getPreferredName(), this.error);
        builder.humanReadableField(LAST_RECORDED_MILLIS_FIELD.getPreferredName(), LAST_RECORDED_FIELD.getPreferredName(), (Object)new TimeValue(this.recordedTimestamp));
        builder.field(RETRY_COUNT_FIELD.getPreferredName(), this.retryCount);
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.firstOccurrenceTimestamp);
        out.writeString(this.error);
        out.writeLong(this.recordedTimestamp);
        out.writeInt(this.retryCount);
    }

    @Override
    public int compareTo(ErrorEntry o) {
        return Integer.compare(o.retryCount, this.retryCount);
    }
}

