/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.index.Index;

public class DataStreamsActionUtil {
    public static List<String> getDataStreamNames(IndexNameExpressionResolver indexNameExpressionResolver, ProjectMetadata project, String[] names, IndicesOptions indicesOptions) {
        indicesOptions = DataStreamsActionUtil.updateIndicesOptions(indicesOptions);
        return indexNameExpressionResolver.dataStreamNames(project, indicesOptions, names);
    }

    public static IndicesOptions updateIndicesOptions(IndicesOptions indicesOptions) {
        if (!indicesOptions.expandWildcardsOpen()) {
            indicesOptions = IndicesOptions.builder(indicesOptions).wildcardOptions(IndicesOptions.WildcardOptions.builder(indicesOptions.wildcardOptions()).matchOpen(true)).build();
        }
        return indicesOptions;
    }

    public static List<String> resolveConcreteIndexNames(IndexNameExpressionResolver indexNameExpressionResolver, ProjectMetadata project, String[] names, IndicesOptions indicesOptions) {
        List<IndexNameExpressionResolver.ResolvedExpression> resolvedDataStreamExpressions = indexNameExpressionResolver.dataStreams(project, DataStreamsActionUtil.updateIndicesOptions(indicesOptions), names);
        SortedMap<String, IndexAbstraction> indicesLookup = project.getIndicesLookup();
        ArrayList<String> results = new ArrayList<String>(resolvedDataStreamExpressions.size());
        for (IndexNameExpressionResolver.ResolvedExpression resolvedExpression : resolvedDataStreamExpressions) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(resolvedExpression.resource());
            assert (indexAbstraction != null);
            if (indexAbstraction.getType() != IndexAbstraction.Type.DATA_STREAM) continue;
            DataStream dataStream = (DataStream)indexAbstraction;
            if (IndexNameExpressionResolver.shouldIncludeRegularIndices(indicesOptions, resolvedExpression.selector())) {
                DataStreamsActionUtil.selectDataStreamIndicesNames(dataStream, false, results);
            }
            if (!IndexNameExpressionResolver.shouldIncludeFailureIndices(indicesOptions, resolvedExpression.selector())) continue;
            DataStreamsActionUtil.selectDataStreamIndicesNames(dataStream, true, results);
        }
        return results;
    }

    private static void selectDataStreamIndicesNames(DataStream indexAbstraction, boolean failureStore, List<String> accumulator) {
        for (Index index : indexAbstraction.getDataStreamIndices(failureStore).getIndices()) {
            accumulator.add(index.getName());
        }
    }
}

