/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.ObjLongConsumer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkPrimaryExecutionContext;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.bulk.MappingUpdatePerformer;
import org.elasticsearch.action.bulk.ShardBulkSplitHelper;
import org.elasticsearch.action.bulk.WriteAckDelay;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.PostWriteRefresh;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexingPressure;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.mapper.MappingLookup;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.ExecutorSelector;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.plugins.internal.DocumentParsingProvider;
import org.elasticsearch.plugins.internal.XContentMeteringParserDecorator;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentType;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    public static final ActionType<BulkShardResponse> TYPE = new ActionType("indices:data/write/bulk[s]");
    private static final Logger logger = LogManager.getLogger(TransportShardBulkAction.class);
    private static final int MAX_EXPANDED_OPERATION_MEMORY_OVERHEAD_FACTOR = 4;
    private final UpdateHelper updateHelper;
    private final MappingUpdatedAction mappingUpdatedAction;
    private final Consumer<Runnable> postWriteAction;
    private final DocumentParsingProvider documentParsingProvider;
    private static final TransportRequestOptions TRANSPORT_REQUEST_OPTIONS = TransportRequestOptions.of(null, TransportRequestOptions.Type.BULK);

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexingPressure indexingPressure, SystemIndices systemIndices, ProjectResolver projectResolver, DocumentParsingProvider documentParsingProvider) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, BulkShardRequest::new, BulkShardRequest::new, ExecutorSelector.getWriteExecutorForShard(threadPool), TransportReplicationAction.PrimaryActionExecution.RejectOnOverload, indexingPressure, systemIndices, projectResolver, TransportReplicationAction.ReplicaActionExecution.SubjectToCircuitBreaker);
        this.updateHelper = updateHelper;
        this.mappingUpdatedAction = mappingUpdatedAction;
        this.postWriteAction = WriteAckDelay.create(settings, threadPool);
        this.documentParsingProvider = documentParsingProvider;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return TRANSPORT_REQUEST_OPTIONS;
    }

    @Override
    protected BulkShardResponse newResponseInstance(StreamInput in) throws IOException {
        return new BulkShardResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(BulkShardRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener) {
        primary.ensureMutable(listener.delegateFailure((l, ignored) -> super.shardOperationOnPrimary(request, primary, l)), true);
    }

    @Override
    protected Map<ShardId, BulkShardRequest> splitRequestOnPrimary(BulkShardRequest request) {
        return ShardBulkSplitHelper.splitRequests(request, this.projectResolver.getProjectMetadata(this.clusterService.state()));
    }

    @Override
    protected Tuple<BulkShardResponse, Exception> combineSplitResponses(BulkShardRequest originalRequest, Map<ShardId, BulkShardRequest> splitRequests, Map<ShardId, Tuple<BulkShardResponse, Exception>> responses) {
        return ShardBulkSplitHelper.combineResponses(originalRequest, splitRequests, responses);
    }

    @Override
    protected void dispatchedShardOperationOnPrimary(BulkShardRequest request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> outerListener) {
        ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener = ActionListener.releaseBefore(this.indexingPressure.trackPrimaryOperationExpansion(this.primaryOperationCount(request), TransportShardBulkAction.getMaxOperationMemoryOverhead(request), this.force(request)), outerListener);
        ClusterStateObserver observer = new ClusterStateObserver(this.clusterService, request.timeout(), logger, this.threadPool.getThreadContext());
        TransportShardBulkAction.performOnPrimary(request, primary, this.updateHelper, this.threadPool::absoluteTimeInMillis, (update, shardId, mappingListener) -> {
            assert (update != null);
            assert (shardId != null);
            this.mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), update, mappingListener);
        }, (mappingUpdateListener, initialMappingVersion) -> observer.waitForNextChange(new ClusterStateObserver.Listener(){
            final /* synthetic */ ActionListener val$mappingUpdateListener;
            {
                this.val$mappingUpdateListener = actionListener;
            }

            @Override
            public void onNewClusterState(ClusterState state) {
                this.val$mappingUpdateListener.onResponse(null);
            }

            @Override
            public void onClusterServiceClose() {
                this.val$mappingUpdateListener.onFailure(new NodeClosedException(TransportShardBulkAction.this.clusterService.localNode()));
            }

            @Override
            public void onTimeout(TimeValue timeout) {
                this.val$mappingUpdateListener.onFailure(new MapperException("timed out while waiting for a dynamic mapping update"));
            }
        }, clusterState -> {
            Index index = primary.shardId().getIndex();
            IndexMetadata indexMetadata = clusterState.metadata().lookupProject(index).map(p -> p.index(index)).orElse(null);
            return indexMetadata == null || indexMetadata.mapping() != null && indexMetadata.getMappingVersion() != initialMappingVersion;
        }), listener, this.executor(primary), this.postWriteRefresh, this.postWriteAction, this.documentParsingProvider);
    }

    @Override
    protected long primaryOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    @Override
    protected int primaryOperationCount(BulkShardRequest request) {
        return request.items().length;
    }

    @Override
    protected long primaryLargestOperationSize(BulkShardRequest request) {
        return request.largestOperationSize();
    }

    @Override
    protected boolean primaryAllowsOperationsBeyondSizeLimit(BulkShardRequest request) {
        return false;
    }

    public static void performOnPrimary(BulkShardRequest request, IndexShard primary, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, ObjLongConsumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, Executor executor) {
        TransportShardBulkAction.performOnPrimary(request, primary, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, listener, executor, null, null, DocumentParsingProvider.EMPTY_INSTANCE);
    }

    public static void performOnPrimary(final BulkShardRequest request, final IndexShard primary, final UpdateHelper updateHelper, final LongSupplier nowInMillisSupplier, final MappingUpdatePerformer mappingUpdater, final ObjLongConsumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>> listener, final Executor executor, final @Nullable PostWriteRefresh postWriteRefresh, final @Nullable Consumer<Runnable> postWriteAction, final DocumentParsingProvider documentParsingProvider) {
        new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(listener){
            private final BulkPrimaryExecutionContext context;
            final long startBulkTime;
            private final ActionListener<Void> onMappingUpdateDone;
            {
                super(listener);
                this.context = new BulkPrimaryExecutionContext(request, primary);
                this.startBulkTime = System.nanoTime();
                this.onMappingUpdateDone = ActionListener.wrap(v -> executor.execute(this), this::onRejection);
            }

            @Override
            protected void doRun() throws Exception {
                while (this.context.hasMoreOperationsToExecute()) {
                    if (!TransportShardBulkAction.executeBulkItemRequest(this.context, updateHelper, nowInMillisSupplier, mappingUpdater, waitForMappingUpdate, this.onMappingUpdateDone, documentParsingProvider)) {
                        return;
                    }
                    assert (this.context.isInitial());
                }
                primary.getBulkOperationListener().afterBulk(request.totalSizeInBytes(), System.nanoTime() - this.startBulkTime);
                this.finishRequest();
            }

            @Override
            public void onRejection(final Exception e) {
                executor.execute(new ActionRunnable<TransportReplicationAction.PrimaryResult<BulkShardRequest, BulkShardResponse>>(this.listener){

                    @Override
                    protected void doRun() {
                        while (context.hasMoreOperationsToExecute()) {
                            context.setRequestToExecute(context.getCurrent());
                            Object docWriteRequest = context.getRequestToExecute();
                            TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, docWriteRequest.opType() == DocWriteRequest.OpType.DELETE, docWriteRequest.version(), docWriteRequest.id()), context, null);
                        }
                        this.finishRequest();
                    }

                    @Override
                    public boolean isForceExecution() {
                        return true;
                    }
                });
            }

            private void finishRequest() {
                ActionListener.completeWith(this.listener, () -> new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(this.context.getBulkShardRequest(), this.context.buildShardResponse(), this.context.getLocationToSync(), this.context.getPrimary(), logger, postWriteRefresh, postWriteAction));
            }
        }.run();
    }

    static boolean executeBulkItemRequest(BulkPrimaryExecutionContext context, UpdateHelper updateHelper, LongSupplier nowInMillisSupplier, MappingUpdatePerformer mappingUpdater, ObjLongConsumer<ActionListener<Void>> waitForMappingUpdate, ActionListener<Void> itemDoneListener, DocumentParsingProvider documentParsingProvider) throws Exception {
        Engine.Result result;
        boolean isDelete;
        UpdateHelper.Result updateResult;
        DocWriteRequest.OpType opType = context.getCurrent().opType();
        if (opType == DocWriteRequest.OpType.UPDATE) {
            UpdateRequest updateRequest = (UpdateRequest)context.getCurrent();
            try {
                updateResult = updateHelper.prepare(updateRequest, context.getPrimary(), nowInMillisSupplier, FetchSourceContext.FETCH_ALL_SOURCE);
            }
            catch (Exception failure) {
                Engine.IndexResult result2 = new Engine.IndexResult(failure, updateRequest.version(), updateRequest.id());
                context.setRequestToExecute(updateRequest);
                context.markOperationAsExecuted(result2);
                context.markAsCompleted(context.getExecutionResult());
                return true;
            }
            if (updateResult.getResponseResult() == DocWriteResponse.Result.NOOP) {
                context.markOperationAsNoOp((DocWriteResponse)updateResult.action());
                context.markAsCompleted(context.getExecutionResult());
                context.getPrimary().noopUpdate();
                return true;
            }
            context.setRequestToExecute((DocWriteRequest)updateResult.action());
        } else {
            context.setRequestToExecute(context.getCurrent());
            updateResult = null;
        }
        assert (context.getRequestToExecute() != null);
        IndexShard primary = context.getPrimary();
        long version = context.getRequestToExecute().version();
        boolean bl = isDelete = context.getRequestToExecute().opType() == DocWriteRequest.OpType.DELETE;
        if (isDelete) {
            DeleteRequest request = (DeleteRequest)context.getRequestToExecute();
            result = primary.applyDeleteOperationOnPrimary(version, request.id(), request.versionType(), request.ifSeqNo(), request.ifPrimaryTerm());
        } else {
            IndexRequest request = (IndexRequest)context.getRequestToExecute();
            XContentMeteringParserDecorator meteringParserDecorator = documentParsingProvider.newMeteringParserDecorator(request);
            SourceToParse sourceToParse = new SourceToParse(request.id(), request.source(), request.getContentType(), request.routing(), request.getDynamicTemplates(), request.getDynamicTemplateParams(), request.getIncludeSourceOnError(), meteringParserDecorator, request.tsid());
            result = primary.applyIndexOperationOnPrimary(version, request.versionType(), sourceToParse, request.ifSeqNo(), request.ifPrimaryTerm(), request.getAutoGeneratedTimestamp(), request.isRetry());
            if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                return TransportShardBulkAction.handleMappingUpdateRequired(context, mappingUpdater, waitForMappingUpdate, itemDoneListener, primary, result, version, updateResult);
            }
        }
        TransportShardBulkAction.onComplete(result, context, updateResult);
        return true;
    }

    private static boolean handleMappingUpdateRequired(final BulkPrimaryExecutionContext context, MappingUpdatePerformer mappingUpdater, final ObjLongConsumer<ActionListener<Void>> waitForMappingUpdate, final ActionListener<Void> itemDoneListener, final IndexShard primary, final Engine.Result result, final long version, final UpdateHelper.Result updateResult) {
        MapperService mapperService = primary.mapperService();
        final long initialMappingVersion = mapperService.mappingVersion();
        try {
            CompressedXContent mergedSource = mapperService.merge("_doc", new CompressedXContent((ToXContent)result.getRequiredMappingUpdate()), MapperService.MergeReason.MAPPING_AUTO_UPDATE_PREFLIGHT).mappingSource();
            DocumentMapper existingDocumentMapper = mapperService.documentMapper();
            if (existingDocumentMapper != null && mergedSource.equals(existingDocumentMapper.mappingSource())) {
                context.resetForNoopMappingUpdateRetry(mapperService.mappingVersion());
                return true;
            }
        }
        catch (Exception e) {
            logger.info(() -> Strings.format((String)"%s mapping update rejected by primary", (Object[])new Object[]{primary.shardId()}), (Throwable)e);
            assert (result.getId() != null);
            TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, false, version, result.getId()), context, updateResult);
            return true;
        }
        mappingUpdater.updateMappings(result.getRequiredMappingUpdate(), primary.shardId(), new ActionListener<Void>(){

            @Override
            public void onResponse(Void v) {
                context.markAsRequiringMappingUpdate();
                waitForMappingUpdate.accept(ActionListener.runAfter(new ActionListener<Void>(){

                    @Override
                    public void onResponse(Void v) {
                        assert (context.requiresWaitingForMappingUpdate());
                        context.resetForMappingUpdateRetry();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        context.failOnMappingUpdate(e);
                    }
                }, () -> itemDoneListener.onResponse(null)), initialMappingVersion);
            }

            @Override
            public void onFailure(Exception e) {
                TransportShardBulkAction.onComplete(TransportShardBulkAction.exceptionToResult(e, primary, false, version, result.getId()), context, updateResult);
                assert (context.isInitial());
                itemDoneListener.onResponse(null);
            }
        });
        return false;
    }

    private static Engine.Result exceptionToResult(Exception e, IndexShard primary, boolean isDelete, long version, String id) {
        assert (id != null);
        return isDelete ? primary.getFailedDeleteResult(e, version, id) : primary.getFailedIndexResult(e, version, id);
    }

    private static void onComplete(Engine.Result r, BulkPrimaryExecutionContext context, UpdateHelper.Result updateResult) {
        BulkItemResponse response;
        context.markOperationAsExecuted(r);
        DocWriteRequest<?> docWriteRequest = context.getCurrent();
        DocWriteRequest.OpType opType = docWriteRequest.opType();
        boolean isUpdate = opType == DocWriteRequest.OpType.UPDATE;
        BulkItemResponse executionResult = context.getExecutionResult();
        boolean isFailed = executionResult.isFailed();
        if (isUpdate && isFailed && TransportShardBulkAction.isConflictException(executionResult.getFailure().getCause()) && context.getUpdateRetryCounter() < ((UpdateRequest)docWriteRequest).retryOnConflict()) {
            context.resetForUpdateRetry();
            return;
        }
        if (isUpdate) {
            assert (context.getPrimary().mapperService() != null);
            MappingLookup mappingLookup = context.getPrimary().mapperService().mappingLookup();
            assert (mappingLookup != null);
            response = TransportShardBulkAction.processUpdateResponse((UpdateRequest)docWriteRequest, context.getConcreteIndex(), mappingLookup, executionResult, updateResult);
        } else {
            if (isFailed) {
                Exception failure = executionResult.getFailure().getCause();
                Level level = TransportShardBulkAction.isConflictException(failure) ? Level.TRACE : Level.DEBUG;
                logger.log(level, () -> Strings.format((String)"%s failed to execute bulk item (%s) %s", (Object[])new Object[]{context.getPrimary().shardId(), opType.getLowercase(), docWriteRequest}), (Throwable)failure);
            }
            response = executionResult;
        }
        context.markAsCompleted(response);
        assert (context.isInitial());
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    private static BulkItemResponse processUpdateResponse(UpdateRequest updateRequest, String concreteIndex, MappingLookup mappingLookup, BulkItemResponse operationResponse, UpdateHelper.Result translate) {
        BulkItemResponse response;
        if (operationResponse.isFailed()) {
            response = BulkItemResponse.failure(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, operationResponse.getFailure());
        } else {
            UpdateResponse updateResponse;
            DocWriteResponse.Result translatedResult = translate.getResponseResult();
            if (translatedResult == DocWriteResponse.Result.CREATED || translatedResult == DocWriteResponse.Result.UPDATED) {
                IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                IndexResponse indexResponse = (IndexResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getId(), indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), indexResponse.getResult());
                if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource()) {
                    BytesReference indexSourceAsBytes = updateIndexRequest.source();
                    Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                    updateResponse.setGetResult(UpdateHelper.extractGetResult(updateRequest, concreteIndex, mappingLookup, indexResponse.getSeqNo(), indexResponse.getPrimaryTerm(), indexResponse.getVersion(), (Map)sourceAndContent.v2(), (XContentType)sourceAndContent.v1(), indexSourceAsBytes));
                }
            } else if (translatedResult == DocWriteResponse.Result.DELETED) {
                DeleteResponse deleteResponse = (DeleteResponse)operationResponse.getResponse();
                updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getId(), deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), deleteResponse.getResult());
                GetResult getResult = UpdateHelper.extractGetResult(updateRequest, concreteIndex, mappingLookup, deleteResponse.getSeqNo(), deleteResponse.getPrimaryTerm(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null);
                updateResponse.setGetResult(getResult);
            } else {
                throw new IllegalArgumentException("unknown operation type: " + String.valueOf(translatedResult));
            }
            response = BulkItemResponse.success(operationResponse.getItemId(), DocWriteRequest.OpType.UPDATE, updateResponse);
        }
        return response;
    }

    @Override
    protected void dispatchedShardOperationOnReplica(BulkShardRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> outerListener) {
        ActionListener<TransportReplicationAction.ReplicaResult> listener = ActionListener.releaseBefore(this.indexingPressure.trackReplicaOperationExpansion(TransportShardBulkAction.getMaxOperationMemoryOverhead(request), this.force(request)), outerListener);
        ActionListener.completeWith(listener, () -> {
            long startBulkTime = System.nanoTime();
            Translog.Location location = TransportShardBulkAction.performOnReplica(request, replica);
            replica.getBulkOperationListener().afterBulk(request.totalSizeInBytes(), System.nanoTime() - startBulkTime);
            return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, logger, this.postWriteAction);
        });
    }

    private static long getMaxOperationMemoryOverhead(BulkShardRequest request) {
        return request.maxOperationSizeInBytes() * 4L;
    }

    @Override
    protected long replicaOperationSize(BulkShardRequest request) {
        return request.ramBytesUsed();
    }

    @Override
    protected int replicaOperationCount(BulkShardRequest request) {
        return request.items().length;
    }

    public static Translog.Location performOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            Engine.Result operationResult;
            BulkItemRequest item = request.items()[i];
            BulkItemResponse response = item.getPrimaryResponse();
            if (item.getPrimaryResponse().isFailed()) {
                if (response.getFailure().getSeqNo() == -2L) continue;
                long primaryTerm = response.getFailure().getTerm() == 0L ? replica.getOperationPrimaryTerm() : response.getFailure().getTerm();
                operationResult = replica.markSeqNoAsNoop(response.getFailure().getSeqNo(), primaryTerm, response.getFailure().getMessage());
            } else {
                if (((DocWriteResponse)response.getResponse()).getResult() == DocWriteResponse.Result.NOOP) continue;
                assert (((DocWriteResponse)response.getResponse()).getSeqNo() != -2L);
                operationResult = TransportShardBulkAction.performOpOnReplica(response.getResponse(), item.request(), replica);
            }
            assert (operationResult != null) : "operation result must never be null when primary response has no failure";
            location = TransportShardBulkAction.syncOperationResultOrThrow(operationResult, location);
        }
        return location;
    }

    private static Engine.Result performOpOnReplica(DocWriteResponse primaryResponse, DocWriteRequest<?> docWriteRequest, IndexShard replica) throws Exception {
        Engine.Result result = switch (docWriteRequest.opType()) {
            case DocWriteRequest.OpType.CREATE, DocWriteRequest.OpType.INDEX -> {
                IndexRequest indexRequest = (IndexRequest)docWriteRequest;
                SourceToParse sourceToParse = new SourceToParse(indexRequest.id(), indexRequest.source(), indexRequest.getContentType(), indexRequest.routing(), Map.of(), Map.of(), true, XContentMeteringParserDecorator.NOOP, indexRequest.tsid());
                yield replica.applyIndexOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), indexRequest.getAutoGeneratedTimestamp(), indexRequest.isRetry(), sourceToParse);
            }
            case DocWriteRequest.OpType.DELETE -> {
                DeleteRequest deleteRequest = (DeleteRequest)docWriteRequest;
                yield replica.applyDeleteOperationOnReplica(primaryResponse.getSeqNo(), primaryResponse.getPrimaryTerm(), primaryResponse.getVersion(), deleteRequest.id());
            }
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected request operation type on replica: " + String.valueOf(docWriteRequest) + ";primary result: " + String.valueOf(primaryResponse)));
                }
                throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
            }
        };
        if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
            throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update: " + String.valueOf(result.getRequiredMappingUpdate()));
        }
        return result;
    }
}

