/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.IndexDocFailureStoreStatus;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.ingest.SimulateIndexResponse;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class BulkItemResponse
implements Writeable,
ToXContentObject {
    private static final String _INDEX = "_index";
    private static final String _ID = "_id";
    static final String STATUS = "status";
    static final String ERROR = "error";
    private final int id;
    private final DocWriteRequest.OpType opType;
    private final DocWriteResponse response;
    private final Failure failure;
    public static final Writeable.Writer<BulkItemResponse> THIN_WRITER = (out, item) -> {
        out.writeVInt(item.id);
        out.writeByte(item.opType.getId());
        if (item.response == null) {
            out.writeByte((byte)2);
        } else {
            item.writeResponseType(out);
            item.response.writeThin(out);
        }
        out.writeOptionalWriteable(item.failure);
    };

    public RestStatus status() {
        return this.failure == null ? this.response.status() : this.failure.getStatus();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject(this.opType.getLowercase());
        if (this.failure == null) {
            this.response.innerToXContent(builder, params);
            builder.field(STATUS, this.response.status().getStatus());
        } else {
            builder.field(_INDEX, this.failure.getIndex());
            builder.field(_ID, this.failure.getId());
            builder.field(STATUS, this.failure.getStatus().getStatus());
            this.failure.getFailureStoreStatus().toXContent(builder, params);
            builder.startObject(ERROR);
            ElasticsearchException.generateThrowableXContent(builder, params, this.failure.getCause());
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    BulkItemResponse(ShardId shardId, StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = DocWriteRequest.OpType.fromId(in.readByte());
        this.response = BulkItemResponse.readResponse(shardId, in);
        this.failure = in.readOptionalWriteable(Failure::new);
        this.assertConsistent();
    }

    BulkItemResponse(StreamInput in) throws IOException {
        this.id = in.readVInt();
        this.opType = DocWriteRequest.OpType.fromId(in.readByte());
        this.response = BulkItemResponse.readResponse(in);
        this.failure = in.readOptionalWriteable(Failure::new);
        this.assertConsistent();
    }

    private BulkItemResponse(int id, DocWriteRequest.OpType opType, DocWriteResponse response, Failure failure) {
        this.id = id;
        this.response = response;
        this.opType = opType;
        this.failure = failure;
        this.assertConsistent();
    }

    private void assertConsistent() {
        assert (this.response == null ^ this.failure == null) : "only one of response or failure may be set";
    }

    public static BulkItemResponse success(int id, DocWriteRequest.OpType opType, DocWriteResponse response) {
        return new BulkItemResponse(id, opType, response, null);
    }

    public static BulkItemResponse failure(int id, DocWriteRequest.OpType opType, Failure failure) {
        return new BulkItemResponse(id, opType, null, failure);
    }

    public int getItemId() {
        return this.id;
    }

    public DocWriteRequest.OpType getOpType() {
        return this.opType;
    }

    public String getIndex() {
        if (this.failure != null) {
            return this.failure.getIndex();
        }
        return this.response.getIndex();
    }

    public String getId() {
        if (this.failure != null) {
            return this.failure.getId();
        }
        return this.response.getId();
    }

    public long getVersion() {
        if (this.failure != null) {
            return -1L;
        }
        return this.response.getVersion();
    }

    public IndexDocFailureStoreStatus getFailureStoreStatus() {
        if (this.response != null) {
            return this.response.getFailureStoreStatus();
        }
        return this.failure.getFailureStoreStatus();
    }

    public <T extends DocWriteResponse> T getResponse() {
        return (T)this.response;
    }

    public boolean isFailed() {
        return this.failure != null;
    }

    public String getFailureMessage() {
        if (this.failure != null) {
            return this.failure.getMessage();
        }
        return null;
    }

    public Failure getFailure() {
        return this.failure;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.id);
        out.writeByte(this.opType.getId());
        if (this.response == null) {
            out.writeByte((byte)2);
        } else {
            this.writeResponseType(out);
            this.response.writeTo(out);
        }
        out.writeOptionalWriteable(this.failure);
    }

    private void writeResponseType(StreamOutput out) throws IOException {
        if (this.response instanceof SimulateIndexResponse) {
            out.writeByte((byte)4);
        } else if (this.response instanceof IndexResponse) {
            out.writeByte((byte)0);
        } else if (this.response instanceof DeleteResponse) {
            out.writeByte((byte)1);
        } else if (this.response instanceof UpdateResponse) {
            out.writeByte((byte)3);
        } else {
            throw new IllegalStateException("Unexpected response type found [" + String.valueOf(this.response.getClass()) + "]");
        }
    }

    private static DocWriteResponse readResponse(ShardId shardId, StreamInput in) throws IOException {
        byte type = in.readByte();
        return switch (type) {
            case 0 -> new IndexResponse(shardId, in);
            case 1 -> new DeleteResponse(shardId, in);
            case 2 -> null;
            case 3 -> new UpdateResponse(shardId, in);
            case 4 -> new SimulateIndexResponse(in);
            default -> throw new IllegalArgumentException("Unexpected type [" + type + "]");
        };
    }

    private static DocWriteResponse readResponse(StreamInput in) throws IOException {
        byte type = in.readByte();
        return switch (type) {
            case 0 -> new IndexResponse(in);
            case 1 -> new DeleteResponse(in);
            case 2 -> null;
            case 3 -> new UpdateResponse(in);
            case 4 -> new SimulateIndexResponse(in);
            default -> throw new IllegalArgumentException("Unexpected type [" + type + "]");
        };
    }

    public static class Failure
    implements Writeable,
    ToXContentFragment {
        public static final String INDEX_FIELD = "index";
        public static final String ID_FIELD = "id";
        public static final String CAUSE_FIELD = "cause";
        public static final String STATUS_FIELD = "status";
        private final String index;
        private final String id;
        private final Exception cause;
        private final RestStatus status;
        private final long seqNo;
        private final long term;
        private final boolean aborted;
        private IndexDocFailureStoreStatus failureStoreStatus;

        public Failure(String index, String id, Exception cause) {
            this(index, id, cause, ExceptionsHelper.status(cause), -2L, 0L, false, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        }

        public Failure(String index, String id, Exception cause, IndexDocFailureStoreStatus failureStoreStatus) {
            this(index, id, cause, ExceptionsHelper.status(cause), -2L, 0L, false, failureStoreStatus);
        }

        public Failure(String index, String id, Exception cause, boolean aborted) {
            this(index, id, cause, ExceptionsHelper.status(cause), -2L, 0L, aborted, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        }

        public Failure(String index, String id, Exception cause, RestStatus status) {
            this(index, id, cause, status, -2L, 0L, false, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        }

        public Failure(String index, String id, Exception cause, long seqNo, long term) {
            this(index, id, cause, ExceptionsHelper.status(cause), seqNo, term, false, IndexDocFailureStoreStatus.NOT_APPLICABLE_OR_UNKNOWN);
        }

        private Failure(String index, String id, Exception cause, RestStatus status, long seqNo, long term, boolean aborted, IndexDocFailureStoreStatus failureStoreStatus) {
            this.index = index;
            this.id = id;
            this.cause = cause;
            this.status = status;
            this.seqNo = seqNo;
            this.term = term;
            this.aborted = aborted;
            this.failureStoreStatus = failureStoreStatus;
        }

        public Failure(StreamInput in) throws IOException {
            this.index = in.readString();
            this.id = in.readOptionalString();
            this.cause = in.readException();
            this.status = ExceptionsHelper.status(this.cause);
            this.seqNo = in.readZLong();
            this.term = in.readVLong();
            this.aborted = in.readBoolean();
            this.failureStoreStatus = IndexDocFailureStoreStatus.read(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalString(this.id);
            out.writeException(this.cause);
            out.writeZLong(this.seqNo);
            out.writeVLong(this.term);
            out.writeBoolean(this.aborted);
            this.failureStoreStatus.writeTo(out);
        }

        public String getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.cause.toString();
        }

        public RestStatus getStatus() {
            return this.status;
        }

        public Exception getCause() {
            return this.cause;
        }

        public long getSeqNo() {
            return this.seqNo;
        }

        public long getTerm() {
            return this.term;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public IndexDocFailureStoreStatus getFailureStoreStatus() {
            return this.failureStoreStatus;
        }

        public void setFailureStoreStatus(IndexDocFailureStoreStatus failureStoreStatus) {
            this.failureStoreStatus = failureStoreStatus;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(INDEX_FIELD, this.index);
            if (this.id != null) {
                builder.field(ID_FIELD, this.id);
            }
            builder.startObject(CAUSE_FIELD);
            ElasticsearchException.generateThrowableXContent(builder, params, this.cause);
            builder.endObject();
            builder.field("status", this.status.getStatus());
            this.failureStoreStatus.toXContent(builder, params);
            return builder;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

