/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ClusterStatsLevel;
import org.elasticsearch.action.admin.indices.stats.CommonStats;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.ChunkedBroadcastResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class IndicesStatsResponse
extends ChunkedBroadcastResponse {
    private final Map<String, ClusterHealthStatus> indexHealthMap;
    private final Map<String, IndexMetadata.State> indexStateMap;
    private final ShardStats[] shards;
    private Map<ShardRouting, ShardStats> shardStatsMap;
    private Map<String, IndexStats> indicesStats;
    private CommonStats total = null;
    private CommonStats primary = null;

    IndicesStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readArray(ShardStats::new, ShardStats[]::new);
        this.indexHealthMap = in.readMap(ClusterHealthStatus::readFrom);
        this.indexStateMap = in.readMap(IndexMetadata.State::readFrom);
    }

    IndicesStatsResponse(ShardStats[] shards, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures, Metadata metadata, RoutingTable routingTable) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(routingTable);
        Objects.requireNonNull(shards);
        HashMap<String, ClusterHealthStatus> indexHealthModifiableMap = new HashMap<String, ClusterHealthStatus>();
        HashMap<String, IndexMetadata.State> indexStateModifiableMap = new HashMap<String, IndexMetadata.State>();
        for (ShardStats shard : shards) {
            Index index = shard.getShardRouting().index();
            IndexMetadata indexMetadata = metadata.findIndex(index).orElse(null);
            if (indexMetadata == null) continue;
            indexHealthModifiableMap.computeIfAbsent(index.getName(), ignored -> new ClusterIndexHealth(indexMetadata, routingTable.index(index)).getStatus());
            indexStateModifiableMap.computeIfAbsent(index.getName(), ignored -> indexMetadata.getState());
        }
        this.indexHealthMap = Collections.unmodifiableMap(indexHealthModifiableMap);
        this.indexStateMap = Collections.unmodifiableMap(indexStateModifiableMap);
    }

    public Map<ShardRouting, ShardStats> asMap() {
        if (this.shardStatsMap == null) {
            HashMap<ShardRouting, ShardStats> shardStatsMap = new HashMap<ShardRouting, ShardStats>();
            for (ShardStats ss : this.shards) {
                shardStatsMap.put(ss.getShardRouting(), ss);
            }
            this.shardStatsMap = Collections.unmodifiableMap(shardStatsMap);
        }
        return this.shardStatsMap;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public ShardStats getAt(int position) {
        return this.shards[position];
    }

    public IndexStats getIndex(String index) {
        return this.getIndices().get(index);
    }

    public Map<String, IndexStats> getIndices() {
        if (this.indicesStats != null) {
            return this.indicesStats;
        }
        HashMap<String, IndexStats.IndexStatsBuilder> indexToIndexStatsBuilder = new HashMap<String, IndexStats.IndexStatsBuilder>();
        for (ShardStats shard : this.shards) {
            Index index = shard.getShardRouting().index();
            IndexStats.IndexStatsBuilder indexStatsBuilder = indexToIndexStatsBuilder.computeIfAbsent(index.getName(), k -> new IndexStats.IndexStatsBuilder((String)k, index.getUUID(), this.indexHealthMap.get(index.getName()), this.indexStateMap.get(index.getName())));
            indexStatsBuilder.add(shard);
        }
        this.indicesStats = indexToIndexStatsBuilder.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((IndexStats.IndexStatsBuilder)entry.getValue()).build()));
        return this.indicesStats;
    }

    public CommonStats getTotal() {
        if (this.total != null) {
            return this.total;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            stats.add(shard.getStats());
        }
        this.total = stats;
        return stats;
    }

    public CommonStats getPrimaries() {
        if (this.primary != null) {
            return this.primary;
        }
        CommonStats stats = new CommonStats();
        for (ShardStats shard : this.shards) {
            if (!shard.getShardRouting().primary()) continue;
            stats.add(shard.getStats());
        }
        this.primary = stats;
        return stats;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.shards);
        out.writeMap(this.indexHealthMap, StreamOutput::writeWriteable);
        out.writeMap(this.indexStateMap, StreamOutput::writeWriteable);
    }

    @Override
    protected Iterator<ToXContent> customXContentChunks(ToXContent.Params outerParams) {
        ToXContent.Params params;
        ClusterStatsLevel level;
        if (outerParams.param("include_off_heap") == null) {
            outerParams = new ToXContent.DelegatingMapParams(Map.of("include_off_heap", "true"), outerParams);
        }
        if ((level = ClusterStatsLevel.of(params = outerParams, ClusterStatsLevel.INDICES)) == ClusterStatsLevel.INDICES || level == ClusterStatsLevel.SHARDS) {
            return Iterators.concat(ChunkedToXContentHelper.chunk((builder, p) -> {
                this.commonStats(builder, params);
                return builder.startObject("indices");
            }), Iterators.flatMap(this.getIndices().values().iterator(), indexStats -> Iterators.concat(ChunkedToXContentHelper.chunk((builder, p) -> {
                builder.startObject(indexStats.getIndex());
                builder.field("uuid", indexStats.getUuid());
                if (indexStats.getHealth() != null) {
                    builder.field("health", indexStats.getHealth().toString().toLowerCase(Locale.ROOT));
                }
                if (indexStats.getState() != null) {
                    builder.field("status", indexStats.getState().toString().toLowerCase(Locale.ROOT));
                }
                builder.startObject("primaries");
                ToXContent.DelegatingMapParams pp = new ToXContent.DelegatingMapParams(Map.of("include_per_field_stats", "true"), params);
                indexStats.getPrimaries().toXContent(builder, (ToXContent.Params)pp);
                builder.endObject();
                builder.startObject("total");
                indexStats.getTotal().toXContent(builder, (ToXContent.Params)pp);
                builder.endObject();
                return builder;
            }), level == ClusterStatsLevel.SHARDS ? ChunkedToXContentHelper.object("shards", Iterators.flatMap(indexStats.iterator(), indexShardStats -> ChunkedToXContentHelper.array(Integer.toString(indexShardStats.getShardId().id()), Iterators.map(indexShardStats.iterator(), shardStats -> (builder, p) -> {
                builder.startObject();
                shardStats.toXContent(builder, p);
                builder.endObject();
                return builder;
            })))) : Collections.emptyIterator(), ChunkedToXContentHelper.endObject())), ChunkedToXContentHelper.endObject());
        }
        return ChunkedToXContentHelper.chunk((builder, p) -> {
            this.commonStats(builder, p);
            return builder;
        });
    }

    private void commonStats(XContentBuilder builder, ToXContent.Params p) throws IOException {
        builder.startObject("_all");
        builder.startObject("primaries");
        this.getPrimaries().toXContent(builder, p);
        builder.endObject();
        builder.startObject("total");
        this.getTotal().toXContent(builder, p);
        builder.endObject();
        builder.endObject();
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    static final class Fields {
        static final String INDICES = "indices";
        static final String SHARDS = "shards";

        Fields() {
        }
    }
}

