/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.sampling;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class DeleteSampleConfigurationAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "indices:admin/sample/config/delete";
    public static final DeleteSampleConfigurationAction INSTANCE = new DeleteSampleConfigurationAction();

    private DeleteSampleConfigurationAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private String index;

        public Request(@Nullable TimeValue masterNodeTimeout, @Nullable TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesRequest indices(String ... indices) {
            if (indices == null || indices.length != 1) {
                throw new IllegalArgumentException("[indices] must contain only one index");
            }
            this.index = indices[0];
            return this;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED_ALLOW_SELECTORS;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Objects.equals(this.index, request.index) && Objects.equals(this.masterNodeTimeout(), request.masterNodeTimeout()) && Objects.equals(this.ackTimeout(), request.ackTimeout());
        }

        public int hashCode() {
            return Objects.hash(this.index, this.masterNodeTimeout(), this.ackTimeout());
        }
    }
}

