/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.refresh;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.broadcast.unpromotable.BroadcastUnpromotableRequest;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class UnpromotableShardRefreshRequest
extends BroadcastUnpromotableRequest {
    private final long primaryTerm;
    private final long segmentGeneration;
    private final TimeValue timeout;

    public UnpromotableShardRefreshRequest(IndexShardRoutingTable indexShardRoutingTable, long primaryTerm, long segmentGeneration, boolean failShardOnError) {
        this(indexShardRoutingTable, primaryTerm, segmentGeneration, failShardOnError, null);
    }

    public UnpromotableShardRefreshRequest(IndexShardRoutingTable indexShardRoutingTable, long primaryTerm, long segmentGeneration, boolean failShardOnError, @Nullable TimeValue timeout) {
        super(indexShardRoutingTable, failShardOnError);
        this.primaryTerm = primaryTerm;
        this.segmentGeneration = segmentGeneration;
        this.timeout = timeout;
    }

    public UnpromotableShardRefreshRequest(StreamInput in) throws IOException {
        super(in);
        this.segmentGeneration = in.readVLong();
        this.primaryTerm = in.readVLong();
        this.timeout = null;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if ((this.segmentGeneration != -1L || this.primaryTerm != -1L) && this.segmentGeneration == -1L) {
            validationException = ValidateActions.addValidationError("segment generation is unknown", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.segmentGeneration);
        out.writeVLong(this.primaryTerm);
    }

    public long getSegmentGeneration() {
        return this.segmentGeneration;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    @Nullable
    public TimeValue getTimeout() {
        return this.timeout;
    }

    @Override
    public String toString() {
        return Strings.format("UnpromotableShardRefreshRequest{shardId=%s, primaryTerm=%d, segmentGeneration=%d}", this.shardId(), this.primaryTerm, this.segmentGeneration);
    }
}

