/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.readonly;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class RemoveIndexBlockResponse
extends AcknowledgedResponse {
    public static final RemoveIndexBlockResponse EMPTY = new RemoveIndexBlockResponse(true, List.of());
    private final List<RemoveBlockResult> results;

    public RemoveIndexBlockResponse(StreamInput in) throws IOException {
        super(in);
        this.results = in.readCollectionAsImmutableList(RemoveBlockResult::new);
    }

    public RemoveIndexBlockResponse(boolean acknowledged, List<RemoveBlockResult> results) {
        super(acknowledged);
        this.results = List.copyOf((Collection)Objects.requireNonNull(results, "results must not be null"));
    }

    public List<RemoveBlockResult> getResults() {
        return this.results;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeCollection(this.results);
    }

    @Override
    protected void addCustomFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("indices");
        for (RemoveBlockResult result : this.results) {
            result.toXContent(builder, params);
        }
        builder.endArray();
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class RemoveBlockResult
    implements Writeable,
    ToXContentObject {
        private final Index index;
        @Nullable
        private final Exception exception;

        public RemoveBlockResult(Index index) {
            this.index = Objects.requireNonNull(index);
            this.exception = null;
        }

        public RemoveBlockResult(Index index, Exception failure) {
            this.index = Objects.requireNonNull(index);
            this.exception = Objects.requireNonNull(failure);
        }

        RemoveBlockResult(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.exception = in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeException(this.exception);
        }

        public Index getIndex() {
            return this.index;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean hasFailures() {
            return this.exception != null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.index.getName());
            if (this.hasFailures()) {
                builder.startObject("exception");
                ElasticsearchException.generateFailureXContent(builder, params, this.exception, true);
                builder.endObject();
            } else {
                builder.field("unblocked", true);
            }
            return builder.endObject();
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

