/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.flush.ShardFlushRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.replication.ReplicationRequestSplitHelper;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportShardFlushAction
extends TransportReplicationAction<ShardFlushRequest, ShardFlushRequest, ReplicationResponse> {
    public static final String NAME = "indices:admin/flush[s]";
    public static final ActionType<ReplicationResponse> TYPE = new ActionType("indices:admin/flush[s]");
    private final ProjectResolver projectResolver;

    @Inject
    public TransportShardFlushAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, ActionFilters actionFilters, ProjectResolver projectResolver) {
        super(settings, NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, ShardFlushRequest::new, ShardFlushRequest::new, threadPool.executor("flush"), TransportReplicationAction.SyncGlobalCheckpointAfterOperation.DoNotSync, TransportReplicationAction.PrimaryActionExecution.RejectOnOverload, TransportReplicationAction.ReplicaActionExecution.SubjectToCircuitBreaker);
        this.projectResolver = projectResolver;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    @Override
    protected void shardOperationOnPrimary(ShardFlushRequest shardRequest, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<ShardFlushRequest, ReplicationResponse>> listener) {
        primary.flush(shardRequest.getRequest(), listener.map(flushed -> {
            this.logger.trace("{} flush request executed on primary", (Object)primary.shardId());
            return new TransportReplicationAction.PrimaryResult<ShardFlushRequest, ReplicationResponse>(shardRequest, new ReplicationResponse());
        }));
    }

    @Override
    protected Map<ShardId, ShardFlushRequest> splitRequestOnPrimary(ShardFlushRequest request) {
        return ReplicationRequestSplitHelper.splitRequest(request, this.projectResolver.getProjectMetadata(this.clusterService.state()), (targetShard, shardCountSummary) -> new ShardFlushRequest(request.getRequest(), (ShardId)targetShard, (SplitShardCountSummary)shardCountSummary));
    }

    @Override
    protected Tuple<ReplicationResponse, Exception> combineSplitResponses(ShardFlushRequest originalRequest, Map<ShardId, ShardFlushRequest> splitRequests, Map<ShardId, Tuple<ReplicationResponse, Exception>> responses) {
        return ReplicationRequestSplitHelper.combineSplitResponses(originalRequest, splitRequests, responses);
    }

    @Override
    protected void shardOperationOnReplica(ShardFlushRequest request, IndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        replica.flush(request.getRequest(), listener.map(flushed -> {
            this.logger.trace("{} flush request executed on replica", (Object)replica.shardId());
            return new TransportReplicationAction.ReplicaResult();
        }));
    }
}

