/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.flush;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.cluster.routing.SplitShardCountSummary;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class ShardFlushRequest
extends ReplicationRequest<ShardFlushRequest> {
    private final FlushRequest request;

    public ShardFlushRequest(FlushRequest request, ShardId shardId, SplitShardCountSummary reshardSplitShardCountSummary) {
        super(shardId, reshardSplitShardCountSummary);
        this.request = request;
        this.waitForActiveShards = ActiveShardCount.NONE;
    }

    public ShardFlushRequest(StreamInput in) throws IOException {
        super(in);
        this.request = new FlushRequest(in);
    }

    FlushRequest getRequest() {
        return this.request;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.request.writeTo(out);
    }

    @Override
    public String toString() {
        return "flush {" + String.valueOf(this.shardId) + "}";
    }
}

