/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.diskusage;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class IndexDiskUsageStats
implements ToXContentFragment,
Writeable {
    public static final String TOTAL = "total";
    public static final String TOTAL_IN_BYTES = "total_in_bytes";
    public static final String INVERTED_INDEX = "inverted_index";
    public static final String STORED_FIELDS = "stored_fields";
    public static final String STORED_FIELDS_IN_BYTES = "stored_fields_in_bytes";
    public static final String DOC_VALUES = "doc_values";
    public static final String DOC_VALUES_IN_BYTES = "doc_values_in_bytes";
    public static final String POINTS = "points";
    public static final String POINTS_IN_BYTES = "points_in_bytes";
    public static final String NORMS = "norms";
    public static final String NORMS_IN_BYTES = "norms_in_bytes";
    public static final String TERM_VECTORS = "term_vectors";
    public static final String TERM_VECTORS_IN_BYTES = "term_vectors_in_bytes";
    public static final String KNN_VECTORS = "knn_vectors";
    public static final String KNN_VECTORS_IN_BYTES = "knn_vectors_in_bytes";
    public static final String STORE_SIZE = "store_size";
    public static final String STORE_SIZE_IN_BYTES = "store_size_in_bytes";
    private final Map<String, PerFieldDiskUsage> fields;
    private long indexSizeInBytes;

    public IndexDiskUsageStats(long indexSizeInBytes) {
        this.fields = new HashMap<String, PerFieldDiskUsage>();
        this.indexSizeInBytes = indexSizeInBytes;
    }

    public IndexDiskUsageStats(StreamInput in) throws IOException {
        this.fields = new HashMap<String, PerFieldDiskUsage>(in.readMap(PerFieldDiskUsage::new));
        this.indexSizeInBytes = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.fields, StreamOutput::writeWriteable);
        out.writeVLong(this.indexSizeInBytes);
    }

    PerFieldDiskUsage total() {
        PerFieldDiskUsage total = new PerFieldDiskUsage();
        for (PerFieldDiskUsage value : this.fields.values()) {
            total.add(value);
        }
        return total;
    }

    Map<String, PerFieldDiskUsage> getFields() {
        return this.fields;
    }

    long getIndexSizeInBytes() {
        return this.indexSizeInBytes;
    }

    private static void checkByteSize(long bytes) {
        if (bytes < 0L) {
            throw new IllegalArgumentException("Bytes must be non-negative; got " + bytes);
        }
    }

    private PerFieldDiskUsage getOrAdd(String fieldName) {
        Objects.requireNonNull(fieldName, "fieldName must be non-null");
        return this.fields.computeIfAbsent(fieldName, k -> new PerFieldDiskUsage());
    }

    public void addInvertedIndex(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).invertedIndexBytes += bytes;
    }

    public void addStoredField(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).storedFieldBytes += bytes;
    }

    public void addDocValues(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).docValuesBytes += bytes;
    }

    public void addPoints(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).pointsBytes += bytes;
    }

    public void addNorms(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).normsBytes += bytes;
    }

    public void addTermVectors(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).termVectorsBytes += bytes;
    }

    public void addKnnVectors(String fieldName, long bytes) {
        IndexDiskUsageStats.checkByteSize(bytes);
        this.getOrAdd((String)fieldName).knnVectorsBytes += bytes;
    }

    public IndexDiskUsageStats add(IndexDiskUsageStats other) {
        other.fields.forEach((k, v) -> this.getOrAdd((String)k).add((PerFieldDiskUsage)v));
        this.indexSizeInBytes += other.indexSizeInBytes;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        PerFieldDiskUsage total = this.total();
        builder.field(STORE_SIZE, (ToXContent)ByteSizeValue.ofBytes(this.indexSizeInBytes));
        builder.field(STORE_SIZE_IN_BYTES, this.indexSizeInBytes);
        builder.startObject("all_fields");
        total.toXContent(builder, params);
        builder.endObject();
        builder.startObject("fields");
        List entries = this.fields.entrySet().stream().sorted(Map.Entry.comparingByKey()).toList();
        for (Map.Entry entry : entries) {
            builder.startObject((String)entry.getKey());
            ((PerFieldDiskUsage)entry.getValue()).toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static final class PerFieldDiskUsage
    implements ToXContentFragment,
    Writeable {
        private long invertedIndexBytes;
        private long storedFieldBytes;
        private long docValuesBytes;
        private long pointsBytes;
        private long normsBytes;
        private long termVectorsBytes;
        private long knnVectorsBytes;

        private PerFieldDiskUsage() {
        }

        private PerFieldDiskUsage(StreamInput in) throws IOException {
            this.invertedIndexBytes = in.readVLong();
            this.storedFieldBytes = in.readVLong();
            this.docValuesBytes = in.readVLong();
            this.pointsBytes = in.readVLong();
            this.normsBytes = in.readVLong();
            this.termVectorsBytes = in.readVLong();
            this.knnVectorsBytes = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.invertedIndexBytes);
            out.writeVLong(this.storedFieldBytes);
            out.writeVLong(this.docValuesBytes);
            out.writeVLong(this.pointsBytes);
            out.writeVLong(this.normsBytes);
            out.writeVLong(this.termVectorsBytes);
            out.writeVLong(this.knnVectorsBytes);
        }

        private void add(PerFieldDiskUsage other) {
            this.invertedIndexBytes += other.invertedIndexBytes;
            this.storedFieldBytes += other.storedFieldBytes;
            this.docValuesBytes += other.docValuesBytes;
            this.pointsBytes += other.pointsBytes;
            this.normsBytes += other.normsBytes;
            this.termVectorsBytes += other.termVectorsBytes;
            this.knnVectorsBytes += other.knnVectorsBytes;
        }

        public long getInvertedIndexBytes() {
            return this.invertedIndexBytes;
        }

        public long getStoredFieldBytes() {
            return this.storedFieldBytes;
        }

        public long getDocValuesBytes() {
            return this.docValuesBytes;
        }

        public long getPointsBytes() {
            return this.pointsBytes;
        }

        public long getNormsBytes() {
            return this.normsBytes;
        }

        public long getTermVectorsBytes() {
            return this.termVectorsBytes;
        }

        public long getKnnVectorsBytes() {
            return this.knnVectorsBytes;
        }

        long totalBytes() {
            return this.invertedIndexBytes + this.storedFieldBytes + this.docValuesBytes + this.pointsBytes + this.normsBytes + this.termVectorsBytes + this.knnVectorsBytes;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            long totalBytes = this.totalBytes();
            builder.field(IndexDiskUsageStats.TOTAL, (ToXContent)ByteSizeValue.ofBytes(totalBytes));
            builder.field(IndexDiskUsageStats.TOTAL_IN_BYTES, totalBytes);
            builder.startObject(IndexDiskUsageStats.INVERTED_INDEX);
            builder.field(IndexDiskUsageStats.TOTAL, (ToXContent)ByteSizeValue.ofBytes(this.invertedIndexBytes));
            builder.field(IndexDiskUsageStats.TOTAL_IN_BYTES, this.invertedIndexBytes);
            builder.endObject();
            builder.field(IndexDiskUsageStats.STORED_FIELDS, (ToXContent)ByteSizeValue.ofBytes(this.storedFieldBytes));
            builder.field(IndexDiskUsageStats.STORED_FIELDS_IN_BYTES, this.storedFieldBytes);
            builder.field(IndexDiskUsageStats.DOC_VALUES, (ToXContent)ByteSizeValue.ofBytes(this.docValuesBytes));
            builder.field(IndexDiskUsageStats.DOC_VALUES_IN_BYTES, this.docValuesBytes);
            builder.field(IndexDiskUsageStats.POINTS, (ToXContent)ByteSizeValue.ofBytes(this.pointsBytes));
            builder.field(IndexDiskUsageStats.POINTS_IN_BYTES, this.pointsBytes);
            builder.field(IndexDiskUsageStats.NORMS, (ToXContent)ByteSizeValue.ofBytes(this.normsBytes));
            builder.field(IndexDiskUsageStats.NORMS_IN_BYTES, this.normsBytes);
            builder.field(IndexDiskUsageStats.TERM_VECTORS, (ToXContent)ByteSizeValue.ofBytes(this.termVectorsBytes));
            builder.field(IndexDiskUsageStats.TERM_VECTORS_IN_BYTES, this.termVectorsBytes);
            builder.field(IndexDiskUsageStats.KNN_VECTORS, (ToXContent)ByteSizeValue.ofBytes(this.knnVectorsBytes));
            builder.field(IndexDiskUsageStats.KNN_VECTORS_IN_BYTES, this.knnVectorsBytes);
            return builder;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

