/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.usage;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.usage.NodeUsageStatsForThreadPoolsAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.allocator.DesiredBalanceMetrics;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.util.concurrent.TaskExecutionTimeTrackingEsThreadPoolExecutor;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.telemetry.metric.LongWithAttributes;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodeUsageStatsForThreadPoolsAction
extends TransportNodesAction<NodeUsageStatsForThreadPoolsAction.Request, NodeUsageStatsForThreadPoolsAction.Response, NodeUsageStatsForThreadPoolsAction.NodeRequest, NodeUsageStatsForThreadPoolsAction.NodeResponse, Void> {
    public static final String NAME = "internal:monitor/thread_pool/stats";
    public static final ActionType<NodeUsageStatsForThreadPoolsAction.Response> TYPE = new ActionType("internal:monitor/thread_pool/stats");
    private static final int NO_VALUE = -1;
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AtomicLong lastMaxQueueLatencyMillis = new AtomicLong(-1L);

    @Inject
    public TransportNodeUsageStatsForThreadPoolsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, DesiredBalanceMetrics desiredBalanceMetrics) {
        super(NAME, clusterService, transportService, actionFilters, NodeUsageStatsForThreadPoolsAction.NodeRequest::new, threadPool.executor("management"));
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        desiredBalanceMetrics.registerWriteLoadDeciderMaxLatencyGauge(this::getMaxQueueLatencyMetric);
    }

    @Override
    protected NodeUsageStatsForThreadPoolsAction.Response newResponse(NodeUsageStatsForThreadPoolsAction.Request request, List<NodeUsageStatsForThreadPoolsAction.NodeResponse> nodeResponses, List<FailedNodeException> nodeFailures) {
        return new NodeUsageStatsForThreadPoolsAction.Response(this.clusterService.getClusterName(), nodeResponses, nodeFailures);
    }

    @Override
    protected NodeUsageStatsForThreadPoolsAction.NodeRequest newNodeRequest(NodeUsageStatsForThreadPoolsAction.Request request) {
        return new NodeUsageStatsForThreadPoolsAction.NodeRequest();
    }

    @Override
    protected NodeUsageStatsForThreadPoolsAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeUsageStatsForThreadPoolsAction.NodeResponse(in);
    }

    @Override
    protected NodeUsageStatsForThreadPoolsAction.NodeResponse nodeOperation(NodeUsageStatsForThreadPoolsAction.NodeRequest request, Task task) {
        DiscoveryNode localNode = this.clusterService.localNode();
        ExecutorService writeExecutor = this.threadPool.executor("write");
        assert (writeExecutor instanceof TaskExecutionTimeTrackingEsThreadPoolExecutor);
        TaskExecutionTimeTrackingEsThreadPoolExecutor trackingForWriteExecutor = (TaskExecutionTimeTrackingEsThreadPoolExecutor)writeExecutor;
        long maxQueueLatencyMillis = Math.max(trackingForWriteExecutor.getMaxQueueLatencyMillisSinceLastPollAndReset(), trackingForWriteExecutor.peekMaxQueueLatencyInQueueMillis());
        this.lastMaxQueueLatencyMillis.set(maxQueueLatencyMillis);
        NodeUsageStatsForThreadPools.ThreadPoolUsageStats threadPoolUsageStats = new NodeUsageStatsForThreadPools.ThreadPoolUsageStats(trackingForWriteExecutor.getMaximumPoolSize(), (float)trackingForWriteExecutor.pollUtilization(TaskExecutionTimeTrackingEsThreadPoolExecutor.UtilizationTrackingPurpose.ALLOCATION), maxQueueLatencyMillis);
        return new NodeUsageStatsForThreadPoolsAction.NodeResponse(localNode, new NodeUsageStatsForThreadPools(localNode.getId(), Map.of("write", threadPoolUsageStats)));
    }

    private Collection<LongWithAttributes> getMaxQueueLatencyMetric() {
        long maxQueueLatencyValue = this.lastMaxQueueLatencyMillis.getAndSet(-1L);
        if (maxQueueLatencyValue != -1L) {
            return Set.of(new LongWithAttributes(maxQueueLatencyValue));
        }
        return Set.of();
    }
}

