/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.coordination;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.coordination.CoordinationDiagnosticsService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;

public class CoordinationDiagnosticsAction
extends ActionType<Response> {
    public static final CoordinationDiagnosticsAction INSTANCE = new CoordinationDiagnosticsAction();
    public static final String NAME = "internal:cluster/coordination_diagnostics/info";

    private CoordinationDiagnosticsAction() {
        super(NAME);
    }

    public static class TransportAction
    extends HandledTransportAction<Request, Response> {
        private final CoordinationDiagnosticsService coordinationDiagnosticsService;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, CoordinationDiagnosticsService coordinationDiagnosticsService) {
            super(CoordinationDiagnosticsAction.NAME, transportService, actionFilters, Request::new, transportService.getThreadPool().executor("cluster_coordination"));
            this.coordinationDiagnosticsService = coordinationDiagnosticsService;
        }

        @Override
        protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
            listener.onResponse(new Response(this.coordinationDiagnosticsService.diagnoseMasterStability(request.explain)));
        }
    }

    public static class Response
    extends ActionResponse {
        private final CoordinationDiagnosticsService.CoordinationDiagnosticsResult result;

        public Response(StreamInput in) throws IOException {
            this.result = new CoordinationDiagnosticsService.CoordinationDiagnosticsResult(in);
        }

        public Response(CoordinationDiagnosticsService.CoordinationDiagnosticsResult result) {
            this.result = result;
        }

        public CoordinationDiagnosticsService.CoordinationDiagnosticsResult getCoordinationDiagnosticsResult() {
            return this.result;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.result.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return this.result.equals(response.result);
        }

        public int hashCode() {
            return Objects.hash(this.result);
        }
    }

    public static class Request
    extends LegacyActionRequest {
        final boolean explain;

        public Request(boolean explain) {
            this.explain = explain;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.explain = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.explain);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.explain == ((Request)o).explain;
        }

        public int hashCode() {
            return Objects.hashCode(this.explain);
        }
    }
}

