/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;

public class ClearVotingConfigExclusionsRequest
extends MasterNodeRequest<ClearVotingConfigExclusionsRequest> {
    private boolean waitForRemoval = true;
    private TimeValue timeout = TimeValue.timeValueSeconds((long)30L);

    public ClearVotingConfigExclusionsRequest(TimeValue masterNodeTimeout) {
        super(masterNodeTimeout);
    }

    public ClearVotingConfigExclusionsRequest(StreamInput in) throws IOException {
        super(in);
        this.waitForRemoval = in.readBoolean();
        this.timeout = in.readTimeValue();
    }

    public boolean getWaitForRemoval() {
        return this.waitForRemoval;
    }

    public void setWaitForRemoval(boolean waitForRemoval) {
        this.waitForRemoval = waitForRemoval;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.waitForRemoval);
        out.writeTimeValue(this.timeout);
    }

    @Override
    public String toString() {
        return "ClearVotingConfigExclusionsRequest{, waitForRemoval=" + this.waitForRemoval + ", timeout=" + String.valueOf(this.timeout) + "}";
    }
}

