/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.allocation;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequestParameters;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.routing.allocation.AllocationStatsService;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationStats;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CancellableSingleObjectCache;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAllocationStatsAction
extends TransportMasterNodeReadAction<Request, Response> {
    public static final ActionType<Response> TYPE = new ActionType("cluster:monitor/allocation/stats");
    public static final TimeValue DEFAULT_CACHE_TTL = TimeValue.timeValueMinutes((long)1L);
    public static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting("cluster.routing.allocation.stats.cache.ttl", DEFAULT_CACHE_TTL, TimeValue.ZERO, TimeValue.timeValueMinutes((long)10L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final AllocationStatsCache allocationStatsCache;
    private final DiskThresholdSettings diskThresholdSettings;

    @Inject
    public TransportGetAllocationStatsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, AllocationStatsService allocationStatsService) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, Request::new, Response::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.allocationStatsCache = new AllocationStatsCache(threadPool, allocationStatsService, DEFAULT_CACHE_TTL);
        this.diskThresholdSettings = new DiskThresholdSettings(clusterService.getSettings(), clusterService.getClusterSettings());
        clusterService.getClusterSettings().initializeAndWatch(CACHE_TTL_SETTING, this.allocationStatsCache::setTTL);
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        super.doExecute(task, request, listener);
    }

    @Override
    protected void masterOperation(Task task, Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
        assert (task instanceof CancellableTask);
        CancellableTask cancellableTask = (CancellableTask)task;
        SubscribableListener allocationStatsStep = request.metrics().contains((Object)NodesStatsRequestParameters.Metric.ALLOCATIONS) ? SubscribableListener.newForked(l -> this.allocationStatsCache.get(cancellableTask::isCancelled, (ActionListener<Map<String, NodeAllocationStats>>)l)) : SubscribableListener.newSucceeded(Map.of());
        allocationStatsStep.andThenApply(allocationStats -> new Response((Map<String, NodeAllocationStats>)allocationStats, request.metrics().contains((Object)NodesStatsRequestParameters.Metric.FS) ? this.diskThresholdSettings : null)).addListener(listener);
    }

    @Override
    protected ClusterBlockException checkBlock(Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    private static class AllocationStatsCache
    extends CancellableSingleObjectCache<Long, Long, Map<String, NodeAllocationStats>> {
        private volatile long ttlMillis;
        private final ThreadPool threadPool;
        private final Executor executor;
        private final AllocationStatsService allocationStatsService;

        AllocationStatsCache(ThreadPool threadPool, AllocationStatsService allocationStatsService, TimeValue ttl) {
            super(threadPool.getThreadContext());
            this.threadPool = threadPool;
            this.executor = threadPool.executor("management");
            this.allocationStatsService = allocationStatsService;
            this.setTTL(ttl);
        }

        void setTTL(TimeValue ttl) {
            this.ttlMillis = ttl.millis();
            this.clearCacheIfDisabled();
        }

        void get(BooleanSupplier isCancelled, ActionListener<Map<String, NodeAllocationStats>> listener) {
            this.get(this.threadPool.relativeTimeInMillis(), isCancelled, listener);
        }

        @Override
        protected void refresh(Long aLong, Runnable ensureNotCancelled, BooleanSupplier supersedeIfStale, ActionListener<Map<String, NodeAllocationStats>> listener) {
            if (!supersedeIfStale.getAsBoolean()) {
                this.executor.execute(ActionRunnable.supply(ActionListener.runBefore(listener, this::clearCacheIfDisabled), () -> this.allocationStatsService.stats(ensureNotCancelled)));
            }
        }

        @Override
        protected Long getKey(Long timestampMillis) {
            return timestampMillis;
        }

        @Override
        protected boolean isFresh(Long currentKey, Long newKey) {
            return this.ttlMillis == 0L || newKey - currentKey <= this.ttlMillis;
        }

        private void clearCacheIfDisabled() {
            if (this.ttlMillis == 0L) {
                this.clearCurrentCachedItem();
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final EnumSet<NodesStatsRequestParameters.Metric> metrics;

        public Request(TimeValue masterNodeTimeout, TaskId parentTaskId, EnumSet<NodesStatsRequestParameters.Metric> metrics) {
            super(masterNodeTimeout);
            this.setParentTask(parentTaskId);
            this.metrics = metrics;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.metrics = in.readEnumSet(NodesStatsRequestParameters.Metric.class);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeEnumSet(this.metrics);
        }

        public EnumSet<NodesStatsRequestParameters.Metric> metrics() {
            return this.metrics;
        }

        @Override
        public ActionRequestValidationException validate() {
            return null;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, NodeAllocationStats> nodeAllocationStats;
        @Nullable
        private final DiskThresholdSettings diskThresholdSettings;

        public Response(Map<String, NodeAllocationStats> nodeAllocationStats, DiskThresholdSettings diskThresholdSettings) {
            this.nodeAllocationStats = nodeAllocationStats;
            this.diskThresholdSettings = diskThresholdSettings;
        }

        public Response(StreamInput in) throws IOException {
            this.nodeAllocationStats = in.readImmutableMap(StreamInput::readString, NodeAllocationStats::new);
            this.diskThresholdSettings = in.readOptionalWriteable(DiskThresholdSettings::readFrom);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.nodeAllocationStats, StreamOutput::writeString, StreamOutput::writeWriteable);
            out.writeOptionalWriteable(this.diskThresholdSettings);
        }

        public Map<String, NodeAllocationStats> getNodeAllocationStats() {
            return this.nodeAllocationStats;
        }

        @Nullable
        public DiskThresholdSettings getDiskThresholdSettings() {
            return this.diskThresholdSettings;
        }
    }
}

