/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.nativeaccess.AbstractNativeAccess;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.lib.Kernel32Library;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;

public class WindowsNativeAccess
extends AbstractNativeAccess {
    private static final int PAGE_NOACCESS = 1;
    private static final int PAGE_GUARD = 256;
    private static final int MEM_COMMIT = 4096;
    private static final int INVALID_FILE_SIZE = -1;
    private static final int JOBOBJECT_BASIC_LIMIT_INFORMATION_CLASS = 2;
    private static final int JOB_OBJECT_LIMIT_ACTIVE_PROCESS = 8;
    private final Kernel32Library kernel;

    WindowsNativeAccess(NativeLibraryProvider libraryProvider) {
        super("Windows", libraryProvider);
        this.kernel = libraryProvider.getLibrary(Kernel32Library.class);
    }

    public String getShortPathName(String path) {
        String longPath = "\\\\?\\" + path;
        int length = this.kernel.GetShortPathNameW(longPath, null, 0);
        if (length == 0) {
            logger.warn("failed to get short path name: {}", new Object[]{this.kernel.GetLastError()});
            return path;
        }
        char[] shortPath = new char[length];
        if (this.kernel.GetShortPathNameW(longPath, shortPath, length) > 0) {
            assert (shortPath[length - 1] == '\u0000');
            return new String(shortPath, 0, length - 1);
        }
        logger.warn("failed to get short path name: {}", new Object[]{this.kernel.GetLastError()});
        return path;
    }

    public boolean addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        return this.kernel.SetConsoleCtrlHandler(dwCtrlType -> {
            if (logger.isDebugEnabled()) {
                logger.debug("console control handler received event [{}]", new Object[]{dwCtrlType});
            }
            return handler.handle(dwCtrlType);
        }, true);
    }

    @Override
    public boolean definitelyRunningAsRoot() {
        return false;
    }

    @Override
    public void tryLockMemory() {
        long size;
        Kernel32Library.Handle process = this.kernel.GetCurrentProcess();
        if (!this.kernel.SetProcessWorkingSetSize(process, size = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getInit() + 0x100000L, size)) {
            logger.warn("Unable to lock JVM memory. Failed to set working set size. Error code {}", new Object[]{this.kernel.GetLastError()});
        } else {
            Kernel32Library.MemoryBasicInformation memInfo = this.kernel.newMemoryBasicInformation();
            Kernel32Library.Address address = memInfo.BaseAddress();
            while (this.kernel.VirtualQueryEx(process, address, memInfo) != 0) {
                boolean lockable;
                boolean bl = lockable = memInfo.State() == 4096L && (memInfo.Protect() & 1L) != 1L && (memInfo.Protect() & 0x100L) != 256L;
                if (lockable) {
                    this.kernel.VirtualLock(memInfo.BaseAddress(), memInfo.RegionSize());
                }
                address = address.add(memInfo.RegionSize());
            }
            this.isMemoryLocked = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tryInstallExecSandbox() {
        Kernel32Library.Handle job = this.kernel.CreateJobObjectW();
        if (job == null) {
            throw new UnsupportedOperationException("CreateJobObject: " + this.kernel.GetLastError());
        }
        try {
            int clazz = 2;
            Kernel32Library.JobObjectBasicLimitInformation info = this.kernel.newJobObjectBasicLimitInformation();
            if (!this.kernel.QueryInformationJobObject(job, clazz, info)) {
                throw new UnsupportedOperationException("QueryInformationJobObject: " + this.kernel.GetLastError());
            }
            info.setActiveProcessLimit(1);
            info.setLimitFlags(8);
            if (!this.kernel.SetInformationJobObject(job, clazz, info)) {
                throw new UnsupportedOperationException("SetInformationJobObject: " + this.kernel.GetLastError());
            }
            if (!this.kernel.AssignProcessToJobObject(job, this.kernel.GetCurrentProcess())) {
                throw new UnsupportedOperationException("AssignProcessToJobObject: " + this.kernel.GetLastError());
            }
        }
        finally {
            this.kernel.CloseHandle(job);
        }
        this.execSandboxState = NativeAccess.ExecSandboxState.ALL_THREADS;
        logger.debug("Windows ActiveProcessLimit initialization successful");
    }

    @Override
    public OptionalLong allocatedSizeInBytes(Path path) {
        assert (Files.isRegularFile(path, new LinkOption[0])) : path;
        String fileName = "\\\\?\\" + String.valueOf(path);
        AtomicInteger lpFileSizeHigh = new AtomicInteger();
        int lpFileSizeLow = this.kernel.GetCompressedFileSizeW(fileName, lpFileSizeHigh::set);
        if (lpFileSizeLow == -1) {
            logger.warn("Unable to get allocated size of file [{}]. Error code {}", new Object[]{path, this.kernel.GetLastError()});
            return OptionalLong.empty();
        }
        long allocatedSize = (long)lpFileSizeHigh.get() << 32 | Integer.toUnsignedLong(lpFileSizeLow);
        if (logger.isTraceEnabled()) {
            logger.trace("executing native method GetCompressedFileSizeW returned [high={}, low={}, allocated={}] for file [{}]", new Object[]{lpFileSizeHigh.get(), lpFileSizeLow, allocatedSize, path});
        }
        return OptionalLong.of(allocatedSize);
    }

    @Override
    public void tryPreallocate(Path file, long size) {
        logger.warn("Cannot preallocate file size because operation is not available on Windows");
    }

    @Override
    public ProcessLimits getProcessLimits() {
        return new ProcessLimits(-1L, -1L, -1L);
    }

    @Override
    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions() {
        return Optional.empty();
    }

    public static interface ConsoleCtrlHandler {
        public static final int CTRL_CLOSE_EVENT = 2;

        public boolean handle(int var1);
    }
}

