/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.nativeaccess.AbstractNativeAccess;
import org.elasticsearch.nativeaccess.PosixConstants;
import org.elasticsearch.nativeaccess.ProcessLimits;
import org.elasticsearch.nativeaccess.VectorSimilarityFunctions;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;
import org.elasticsearch.nativeaccess.lib.VectorLibrary;

public abstract class PosixNativeAccess
extends AbstractNativeAccess {
    private static final int MCL_CURRENT = 1;
    private static final int ENOMEM = 12;
    private static final int O_RDONLY = 0;
    private static final int O_WRONLY = 1;
    protected final PosixCLibrary libc;
    protected final VectorSimilarityFunctions vectorDistance;
    protected final PosixConstants constants;
    protected final ProcessLimits processLimits;
    static final String ENABLE_JDK_VECTOR_LIBRARY = "org.elasticsearch.nativeaccess.enableVectorLibrary";

    PosixNativeAccess(String name, NativeLibraryProvider libraryProvider, PosixConstants constants) {
        super(name, libraryProvider);
        this.libc = libraryProvider.getLibrary(PosixCLibrary.class);
        this.vectorDistance = PosixNativeAccess.vectorSimilarityFunctionsOrNull(libraryProvider);
        this.constants = constants;
        this.processLimits = new ProcessLimits(this.getMaxThreads(), this.getRLimit(constants.RLIMIT_AS(), "max size virtual memory"), this.getRLimit(constants.RLIMIT_FSIZE(), "max file size"));
    }

    protected abstract long getMaxThreads();

    protected long getRLimit(int resource, String description) {
        PosixCLibrary.RLimit rlimit = this.libc.newRLimit();
        if (this.libc.getrlimit(resource, rlimit) == 0) {
            long value = rlimit.rlim_cur();
            return value == this.constants.RLIMIT_INFINITY() ? Long.MAX_VALUE : value;
        }
        logger.warn("unable to retrieve " + description + " [" + this.libc.strerror(this.libc.errno()) + "]");
        return -1L;
    }

    static VectorSimilarityFunctions vectorSimilarityFunctionsOrNull(NativeLibraryProvider libraryProvider) {
        if (PosixNativeAccess.isNativeVectorLibSupported()) {
            VectorSimilarityFunctions lib = libraryProvider.getLibrary(VectorLibrary.class).getVectorSimilarityFunctions();
            logger.info("Using native vector library; to disable start with -Dorg.elasticsearch.nativeaccess.enableVectorLibrary=false");
            return lib;
        }
        return null;
    }

    @Override
    public boolean definitelyRunningAsRoot() {
        return this.libc.geteuid() == 0;
    }

    @Override
    public ProcessLimits getProcessLimits() {
        return this.processLimits;
    }

    @Override
    public void tryLockMemory() {
        int result = this.libc.mlockall(1);
        if (result == 0) {
            this.isMemoryLocked = true;
            return;
        }
        int errno = this.libc.errno();
        String errMsg = this.libc.strerror(errno);
        logger.warn("Unable to lock JVM Memory: error={}, reason={}", new Object[]{errno, errMsg});
        logger.warn("This can result in part of the JVM being swapped out.");
        if (errno == 12) {
            boolean rlimitSuccess = false;
            long softLimit = 0L;
            long hardLimit = 0L;
            PosixCLibrary.RLimit rlimit = this.libc.newRLimit();
            if (this.libc.getrlimit(this.constants.RLIMIT_MEMLOCK(), rlimit) == 0) {
                rlimitSuccess = true;
                softLimit = rlimit.rlim_cur();
                hardLimit = rlimit.rlim_max();
            } else {
                logger.warn("Unable to retrieve resource limits: {}", new Object[]{this.libc.strerror(this.libc.errno())});
            }
            if (rlimitSuccess) {
                logger.warn("Increase RLIMIT_MEMLOCK, soft limit: {}, hard limit: {}", new Object[]{this.rlimitToString(softLimit), this.rlimitToString(hardLimit)});
                this.logMemoryLimitInstructions();
            } else {
                logger.warn("Increase RLIMIT_MEMLOCK (ulimit).");
            }
        }
    }

    protected abstract void logMemoryLimitInstructions();

    @Override
    public OptionalLong allocatedSizeInBytes(Path path) {
        assert (Files.isRegularFile(path, new LinkOption[0])) : path;
        PosixCLibrary.Stat64 stats = this.libc.newStat64(this.constants.statStructSize(), this.constants.statStructSizeOffset(), this.constants.statStructBlocksOffset());
        int fd = this.libc.open(path.toAbsolutePath().toString(), 0);
        if (fd == -1) {
            logger.warn("Could not open file [" + String.valueOf(path) + "] to get allocated size: " + this.libc.strerror(this.libc.errno()));
            return OptionalLong.empty();
        }
        if (this.libc.fstat64(fd, stats) != 0) {
            logger.warn("Could not get stats for file [" + String.valueOf(path) + "] to get allocated size: " + this.libc.strerror(this.libc.errno()));
            return OptionalLong.empty();
        }
        if (this.libc.close(fd) != 0) {
            logger.warn("Failed to close file [" + String.valueOf(path) + "] after getting stats: " + this.libc.strerror(this.libc.errno()));
        }
        return OptionalLong.of(stats.st_blocks() * 512L);
    }

    @Override
    @SuppressForbidden(reason="Using mkdirs")
    public void tryPreallocate(Path file, long newSize) {
        Path absolutePath = file.toAbsolutePath();
        Path directory = absolutePath.getParent();
        directory.toFile().mkdirs();
        int fd = this.libc.open(absolutePath.toString(), 1 | this.constants.O_CREAT(), 438);
        if (fd == -1) {
            logger.warn("Could not open file [" + String.valueOf(file) + "] to preallocate size: " + this.libc.strerror(this.libc.errno()));
            return;
        }
        PosixCLibrary.Stat64 stats = this.libc.newStat64(this.constants.statStructSize(), this.constants.statStructSizeOffset(), this.constants.statStructBlocksOffset());
        if (this.libc.fstat64(fd, stats) != 0) {
            logger.warn("Could not get stats for file [" + String.valueOf(file) + "] to preallocate size: " + this.libc.strerror(this.libc.errno()));
        } else if (this.nativePreallocate(fd, stats.st_size(), newSize)) {
            logger.debug("pre-allocated file [{}] to {} bytes", new Object[]{file, newSize});
        }
        if (this.libc.close(fd) != 0) {
            logger.warn("Could not close file [" + String.valueOf(file) + "] after trying to preallocate size: " + this.libc.strerror(this.libc.errno()));
        }
    }

    protected abstract boolean nativePreallocate(int var1, long var2, long var4);

    @Override
    public Optional<VectorSimilarityFunctions> getVectorSimilarityFunctions() {
        return Optional.ofNullable(this.vectorDistance);
    }

    String rlimitToString(long value) {
        if (value == this.constants.RLIMIT_INFINITY()) {
            return "unlimited";
        }
        return Long.toUnsignedString(value);
    }

    static boolean isNativeVectorLibSupported() {
        return Runtime.version().feature() >= 21 && (PosixNativeAccess.isMacOrLinuxAarch64() || PosixNativeAccess.isLinuxAmd64()) && PosixNativeAccess.checkEnableSystemProperty();
    }

    static boolean isLinuxAmd64() {
        String name = System.getProperty("os.name");
        return name.startsWith("Linux") && System.getProperty("os.arch").equals("amd64");
    }

    static boolean isMacOrLinuxAarch64() {
        String name = System.getProperty("os.name");
        return (name.startsWith("Mac") || name.startsWith("Linux")) && System.getProperty("os.arch").equals("aarch64");
    }

    @SuppressForbidden(reason="TODO Deprecate any lenient usage of Boolean#parseBoolean https://github.com/elastic/elasticsearch/issues/128993")
    static boolean checkEnableSystemProperty() {
        return Optional.ofNullable(System.getProperty(ENABLE_JDK_VECTOR_LIBRARY)).map(Boolean::valueOf).orElse(Boolean.TRUE);
    }
}

