/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.nativeaccess.NativeAccess;
import org.elasticsearch.nativeaccess.PosixConstants;
import org.elasticsearch.nativeaccess.PosixNativeAccess;
import org.elasticsearch.nativeaccess.lib.MacCLibrary;
import org.elasticsearch.nativeaccess.lib.NativeLibraryProvider;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;

public class MacNativeAccess
extends PosixNativeAccess {
    private static final int F_PREALLOCATE = 42;
    private static final int F_ALLOCATECONTIG = 2;
    private static final int F_ALLOCATEALL = 4;
    private static final int F_PEOFPOSMODE = 3;
    static final int SANDBOX_NAMED = 1;
    static final String SANDBOX_RULES = "(version 1) (allow default) (deny process-fork) (deny process-exec)";
    private final MacCLibrary macLibc;

    MacNativeAccess(NativeLibraryProvider libraryProvider) {
        super("MacOS", libraryProvider, new PosixConstants(Long.MAX_VALUE, 5, 1, 6, 512, 144, 96, 104));
        this.macLibc = libraryProvider.getLibrary(MacCLibrary.class);
    }

    @Override
    protected long getMaxThreads() {
        return -1L;
    }

    @Override
    protected void logMemoryLimitInstructions() {
    }

    @Override
    protected boolean nativePreallocate(int fd, long currentSize, long newSize) {
        PosixCLibrary.FStore fst = this.libc.newFStore();
        fst.set_flags(2);
        fst.set_posmode(3);
        fst.set_offset(0L);
        fst.set_length(newSize);
        if (this.libc.fcntl(fd, 42, fst) != 0) {
            fst.set_flags(4);
            if (this.libc.fcntl(fd, 42, fst) != 0) {
                logger.warn("Could not allocate non-contiguous size: " + this.libc.strerror(this.libc.errno()));
                return false;
            }
        }
        if (this.libc.ftruncate(fd, newSize) != 0) {
            logger.warn("Could not truncate file: " + this.libc.strerror(this.libc.errno()));
            return false;
        }
        return true;
    }

    @Override
    public void tryInstallExecSandbox() {
        this.initBsdSandbox();
        this.initMacSandbox();
        this.execSandboxState = NativeAccess.ExecSandboxState.ALL_THREADS;
    }

    @SuppressForbidden(reason="Java tmp dir is ok")
    private static Path createTempRulesFile() throws IOException {
        return Files.createTempFile("es", "sb", new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMacSandbox() {
        Path rules;
        try {
            rules = MacNativeAccess.createTempRulesFile();
            Files.write(rules, Collections.singleton(SANDBOX_RULES), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            MacCLibrary.ErrorReference errorRef = this.macLibc.newErrorReference();
            int ret = this.macLibc.sandbox_init(rules.toAbsolutePath().toString(), 1L, errorRef);
            if (ret != 0) {
                UnsupportedOperationException e = new UnsupportedOperationException("sandbox_init(): " + errorRef.toString());
                this.macLibc.sandbox_free_error(errorRef);
                throw e;
            }
            logger.debug("OS X seatbelt initialization successful");
        }
        catch (Throwable throwable) {
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{rules});
            throw throwable;
        }
        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{rules});
    }

    private void initBsdSandbox() {
        PosixCLibrary.RLimit limit = this.libc.newRLimit();
        limit.rlim_cur(0L);
        limit.rlim_max(0L);
        int RLIMIT_NPROC = 7;
        if (this.libc.setrlimit(7, limit) != 0) {
            throw new UnsupportedOperationException("RLIMIT_NPROC unavailable: " + this.libc.strerror(this.libc.errno()));
        }
        logger.debug("BSD RLIMIT_NPROC initialization successful");
    }
}

