/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle.test;

import java.util.List;
import org.elasticsearch.gradle.test.SystemPropertyCommandLineArgumentProvider;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.testing.Test;

public class GradleTestPolicySetupPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        Gradle gradle = project.getGradle();
        project.getTasks().withType(Test.class).configureEach(test -> {
            test.systemProperty("tests.gradle", (Object)true);
            test.systemProperty("tests.task", (Object)test.getPath());
            test.getJvmArgumentProviders().add(() -> {
                if (test.getJavaVersion().compareTo((Enum)JavaVersion.VERSION_23) <= 0) {
                    return List.of("-Djava.security.manager=allow");
                }
                return List.of();
            });
            SystemPropertyCommandLineArgumentProvider nonInputProperties = new SystemPropertyCommandLineArgumentProvider();
            nonInputProperties.systemProperty("gradle.dist.lib", gradle.getGradleHomeDir().getAbsolutePath() + "/lib");
            nonInputProperties.systemProperty("gradle.worker.jar", gradle.getGradleUserHomeDir().getAbsolutePath() + "/caches/" + gradle.getGradleVersion() + "/workerMain/gradle-worker.jar");
            test.getJvmArgumentProviders().add(nonInputProperties);
        });
    }
}

