/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gradle;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.function.Supplier;

public enum OS {
    WINDOWS("windows"),
    MAC("darwin"),
    LINUX("linux");

    public final String javaOsReference;

    private OS(String javaOsReference) {
        this.javaOsReference = javaOsReference;
    }

    public static OS current() {
        String os = System.getProperty("os.name", "");
        if (os.startsWith("Windows")) {
            return WINDOWS;
        }
        if (os.startsWith("Linux") || os.startsWith("LINUX")) {
            return LINUX;
        }
        if (os.startsWith("Mac")) {
            return MAC;
        }
        throw new IllegalStateException("Can't determine OS from: " + os);
    }

    public static <T> Conditional<T> conditional() {
        return new Conditional();
    }

    public static Conditional<String> conditionalString() {
        return OS.conditional();
    }

    public static class Conditional<T> {
        private final Map<OS, Supplier<T>> conditions = new EnumMap<OS, Supplier<T>>(OS.class);

        public Conditional<T> onWindows(Supplier<T> supplier) {
            this.conditions.put(WINDOWS, supplier);
            return this;
        }

        public Conditional<T> onLinux(Supplier<T> supplier) {
            this.conditions.put(LINUX, supplier);
            return this;
        }

        public Conditional<T> onMac(Supplier<T> supplier) {
            this.conditions.put(MAC, supplier);
            return this;
        }

        public Conditional<T> onUnix(Supplier<T> supplier) {
            this.conditions.put(MAC, supplier);
            this.conditions.put(LINUX, supplier);
            return this;
        }

        public T supply() {
            EnumSet<OS> missingOS = EnumSet.allOf(OS.class);
            missingOS.removeAll(this.conditions.keySet());
            if (!missingOS.isEmpty()) {
                throw new IllegalArgumentException("No condition specified for " + String.valueOf(missingOS));
            }
            return this.conditions.get((Object)OS.current()).get();
        }
    }
}

