/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.ObservabilityOptions;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import okhttp3.Request;

class ObservabilityHelper {
    ObservabilityHelper() {
    }

    static Span getSpanForRequest(@Nonnull Request request, @Nonnull String spanName) {
        return ObservabilityHelper.getSpanForRequest(request, spanName, null);
    }

    static Span getSpanForRequest(@Nonnull Request request, @Nonnull String spanName, @Nullable Span parentSpan) {
        Objects.requireNonNull(request, "parameter request cannot be null");
        Objects.requireNonNull(spanName, "parameter spanName cannot be null");
        ObservabilityOptions obsOptions = (ObservabilityOptions)request.tag(ObservabilityOptions.class);
        Span span = null;
        if (obsOptions != null) {
            Span parentToUse = parentSpan;
            if (parentToUse == null) {
                parentToUse = (Span)request.tag(Span.class);
            }
            SpanBuilder builder = GlobalOpenTelemetry.getTracer((String)obsOptions.getTracerInstrumentationName()).spanBuilder(spanName);
            if (parentToUse != null) {
                builder.setParent(Context.current().with((ImplicitContextKeyed)parentToUse));
            }
            span = builder.startSpan();
        }
        return span;
    }
}

