/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import java.io.IOException;
import java.net.InetAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.discovery.ec2.AwsEc2Utils;

class Ec2NameResolver
implements NetworkService.CustomNameResolver {
    private static final String IMDS_ADDRESS_PATH_PREFIX = "/latest/meta-data/";

    Ec2NameResolver() {
    }

    public InetAddress[] resolveDefault() {
        return null;
    }

    public InetAddress[] resolveIfPossible(String value) throws IOException {
        for (Ec2HostnameType type : Ec2HostnameType.values()) {
            if (!type.configName.equals(value)) continue;
            String metadataPath = IMDS_ADDRESS_PATH_PREFIX + type.ec2Name;
            try {
                return new InetAddress[]{InetAddress.getByName(AwsEc2Utils.getInstanceMetadata(metadataPath))};
            }
            catch (Exception e) {
                throw new IOException("Exception caught when resolving EC2 address from [" + metadataPath + "]", e);
            }
        }
        return null;
    }

    private static enum Ec2HostnameType {
        PRIVATE_IPv4("ec2:privateIpv4", "local-ipv4"),
        PRIVATE_DNS("ec2:privateDns", "local-hostname"),
        PUBLIC_IPv4("ec2:publicIpv4", "public-ipv4"),
        PUBLIC_DNS("ec2:publicDns", "public-hostname"),
        PUBLIC_IP("ec2:publicIp", Ec2HostnameType.PUBLIC_IPv4.ec2Name),
        PRIVATE_IP("ec2:privateIp", Ec2HostnameType.PRIVATE_IPv4.ec2Name),
        EC2("ec2", Ec2HostnameType.PRIVATE_IPv4.ec2Name);

        final String configName;
        final String ec2Name;

        private Ec2HostnameType(String configName, String ec2Name) {
            this.configName = configName;
            this.ec2Name = ec2Name;
        }
    }
}

