/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.ec2;

import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.client.utils.URIBuilder;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.discovery.ec2.AmazonEc2Reference;
import org.elasticsearch.discovery.ec2.AwsEc2Service;
import org.elasticsearch.discovery.ec2.Ec2ClientSettings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.Ec2ClientBuilder;

class AwsEc2ServiceImpl
implements AwsEc2Service {
    private static final Logger LOGGER = LogManager.getLogger(AwsEc2ServiceImpl.class);
    private final AtomicReference<LazyInitializable<AmazonEc2Reference, ElasticsearchException>> lazyClientReference = new AtomicReference();

    AwsEc2ServiceImpl() {
    }

    private Ec2Client buildClient(Ec2ClientSettings clientSettings) {
        ApacheHttpClient.Builder httpClientBuilder = this.getHttpClientBuilder();
        httpClientBuilder.socketTimeout(Duration.of(clientSettings.readTimeoutMillis, ChronoUnit.MILLIS));
        if (Strings.hasText((String)clientSettings.proxyHost)) {
            AwsEc2ServiceImpl.applyProxyConfiguration(clientSettings, httpClientBuilder);
        }
        Ec2ClientBuilder ec2ClientBuilder = this.getEc2ClientBuilder();
        ec2ClientBuilder.credentialsProvider(AwsEc2ServiceImpl.getAwsCredentialsProvider(clientSettings));
        ec2ClientBuilder.httpClientBuilder((SdkHttpClient.Builder)httpClientBuilder);
        ec2ClientBuilder.overrideConfiguration(b -> b.retryStrategy(c -> c.maxAttempts(10)));
        if (Strings.hasText((String)clientSettings.endpoint)) {
            LOGGER.debug("using explicit ec2 endpoint [{}]", new Object[]{clientSettings.endpoint});
            Endpoint endpoint = Endpoint.builder().url(URI.create(clientSettings.endpoint)).build();
            ec2ClientBuilder.endpointProvider(endpointParams -> CompletableFuture.completedFuture(endpoint));
        }
        return (Ec2Client)ec2ClientBuilder.build();
    }

    private static void applyProxyConfiguration(Ec2ClientSettings clientSettings, ApacheHttpClient.Builder httpClientBuilder) {
        URI proxyUri;
        URIBuilder uriBuilder = new URIBuilder();
        uriBuilder.setScheme(clientSettings.proxyScheme.getSchemeString()).setHost(clientSettings.proxyHost).setPort(clientSettings.proxyPort);
        try {
            proxyUri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        httpClientBuilder.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(proxyUri).scheme(clientSettings.proxyScheme.getSchemeString()).username(clientSettings.proxyUsername).password(clientSettings.proxyPassword).build());
    }

    Ec2ClientBuilder getEc2ClientBuilder() {
        return Ec2Client.builder();
    }

    ApacheHttpClient.Builder getHttpClientBuilder() {
        return ApacheHttpClient.builder();
    }

    private static AwsCredentialsProvider getAwsCredentialsProvider(Ec2ClientSettings clientSettings) {
        DefaultCredentialsProvider credentialsProvider;
        AwsCredentials credentials = clientSettings.credentials;
        if (credentials == null) {
            LOGGER.debug("Using default provider chain");
            credentialsProvider = DefaultCredentialsProvider.create();
        } else {
            LOGGER.debug("Using basic key/secret credentials");
            credentialsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        }
        return credentialsProvider;
    }

    @Override
    public AmazonEc2Reference client() {
        LazyInitializable<AmazonEc2Reference, ElasticsearchException> clientReference = this.lazyClientReference.get();
        if (clientReference == null) {
            throw new IllegalStateException("Missing ec2 client configs");
        }
        return (AmazonEc2Reference)((Object)clientReference.getOrCompute());
    }

    @Override
    public void refreshAndClearCache(Ec2ClientSettings clientSettings) {
        LazyInitializable newClient = new LazyInitializable(() -> new AmazonEc2Reference(this.buildClient(clientSettings)), AbstractRefCounted::incRef, AbstractRefCounted::decRef);
        LazyInitializable<AmazonEc2Reference, ElasticsearchException> oldClient = this.lazyClientReference.getAndSet((LazyInitializable<AmazonEc2Reference, ElasticsearchException>)newClient);
        if (oldClient != null) {
            oldClient.reset();
        }
    }

    @Override
    public void close() {
        LazyInitializable clientReference = this.lazyClientReference.getAndSet(null);
        if (clientReference != null) {
            clientReference.reset();
        }
    }
}

