/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cloud.azure.classic.management;

import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.core.Builder;
import com.microsoft.windowsazure.core.DefaultBuilder;
import com.microsoft.windowsazure.core.utils.KeyStoreType;
import com.microsoft.windowsazure.management.compute.ComputeManagementClient;
import com.microsoft.windowsazure.management.compute.ComputeManagementService;
import com.microsoft.windowsazure.management.compute.models.HostedServiceGetDetailedResponse;
import com.microsoft.windowsazure.management.configuration.ManagementConfiguration;
import java.io.IOException;
import java.net.URI;
import java.util.ServiceLoader;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.cloud.azure.classic.AzureServiceRemoteException;
import org.elasticsearch.cloud.azure.classic.management.AzureComputeService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;

public class AzureComputeServiceImpl
extends AbstractLifecycleComponent
implements AzureComputeService {
    private static final Logger logger = LogManager.getLogger(AzureComputeServiceImpl.class);
    private final ComputeManagementClient client;
    private final String serviceName;

    public AzureComputeServiceImpl(Settings settings) {
        String subscriptionId = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.SUBSCRIPTION_ID_SETTING);
        this.serviceName = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.SERVICE_NAME_SETTING);
        String keystorePath = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.KEYSTORE_PATH_SETTING);
        String keystorePassword = AzureComputeServiceImpl.getRequiredSetting(settings, AzureComputeService.Management.KEYSTORE_PASSWORD_SETTING);
        KeyStoreType keystoreType = (KeyStoreType)AzureComputeService.Management.KEYSTORE_TYPE_SETTING.get(settings);
        logger.trace("creating new Azure client for [{}], [{}]", new Object[]{subscriptionId, this.serviceName});
        try {
            DefaultBuilder builder = new DefaultBuilder();
            for (Builder.Exports exports : ServiceLoader.load(Builder.Exports.class, this.getClass().getClassLoader())) {
                exports.register((Builder.Registry)builder);
            }
            Configuration configuration = new Configuration((Builder)builder);
            configuration.setProperty("com.microsoft.windowsazure.Configuration.logHttpRequests", (Object)logger.isTraceEnabled());
            Configuration managementConfig = ManagementConfiguration.configure(null, (Configuration)configuration, (URI)((URI)AzureComputeService.Management.ENDPOINT_SETTING.get(settings)), (String)subscriptionId, (String)keystorePath, (String)keystorePassword, (KeyStoreType)keystoreType);
            logger.debug("creating new Azure client for [{}], [{}]", new Object[]{subscriptionId, this.serviceName});
            this.client = ComputeManagementService.create((Configuration)managementConfig);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Unable to configure Azure compute service", (Throwable)e, new Object[0]);
        }
    }

    private static String getRequiredSetting(Settings settings, Setting<String> setting) {
        String value = (String)setting.get(settings);
        if (value == null || !Strings.hasLength((String)value)) {
            throw new IllegalArgumentException("Missing required setting " + setting.getKey() + " for azure");
        }
        return value;
    }

    @Override
    public HostedServiceGetDetailedResponse getServiceDetails() {
        SpecialPermission.check();
        try {
            return this.client.getHostedServicesOperations().getDetailed(this.serviceName);
        }
        catch (Exception e) {
            throw new AzureServiceRemoteException("can not get list of azure nodes", e.getCause());
        }
    }

    protected void doStart() throws ElasticsearchException {
    }

    protected void doStop() throws ElasticsearchException {
    }

    protected void doClose() throws ElasticsearchException {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                logger.error("error while closing Azure client", (Throwable)e);
            }
        }
    }
}

