/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;
import org.elasticsearch.hadoop.thirdparty.codehaus.jackson.annotate.JsonProperty;

public class Mapping
implements Serializable {
    private final String index;
    private final String type;
    private final Field[] fields;

    public Mapping(String name, Collection<Field> fields) {
        this(null, name, fields != null ? fields.toArray(new Field[fields.size()]) : Field.NO_FIELDS);
    }

    public Mapping(String index, String name, Collection<Field> fields) {
        this(index, name, fields != null ? fields.toArray(new Field[fields.size()]) : Field.NO_FIELDS);
    }

    Mapping(@JsonProperty(value="index") String index, @JsonProperty(value="type") String type, @JsonProperty(value="fields") Field[] fields) {
        this.index = index;
        this.type = type;
        this.fields = fields;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Mapping filter(Collection<String> includes, Collection<String> excludes) {
        if (includes.isEmpty() && excludes.isEmpty()) {
            return this;
        }
        ArrayList<Field> filtered = new ArrayList<Field>();
        List<FieldFilter.NumberedInclude> convertedIncludes = FieldFilter.toNumberedFilter(includes);
        boolean intact = true;
        for (Field fl : this.getFields()) {
            intact &= Mapping.filterField(fl, null, filtered, convertedIncludes, excludes);
        }
        return intact ? this : new Mapping(this.getIndex(), this.getType(), filtered);
    }

    private static boolean filterField(Field field, String parentName, List<Field> filtered, Collection<FieldFilter.NumberedInclude> includes, Collection<String> excludes) {
        String fieldName = parentName != null ? parentName + "." + field.name() : field.name();
        boolean intact = true;
        if (FieldFilter.filter((String)fieldName, includes, excludes).matched) {
            if (FieldType.isCompound(field.type())) {
                ArrayList<Field> nested = new ArrayList<Field>();
                for (Field nestedField : field.properties()) {
                    intact &= Mapping.filterField(nestedField, fieldName, nested, includes, excludes);
                }
                filtered.add(new Field(field.name(), field.type(), nested));
            } else {
                filtered.add(field);
            }
        } else {
            intact = false;
        }
        return intact;
    }

    public Map<String, FieldType> flatten() {
        if (this.fields == null || this.fields.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldType> map = new LinkedHashMap<String, FieldType>();
        for (Field nestedField : this.fields) {
            Mapping.addSubFieldToMap(map, nestedField, null);
        }
        return map;
    }

    private static void addSubFieldToMap(Map<String, FieldType> fields, Field field, String parentName) {
        String fieldName = parentName != null ? parentName + "." + field.name() : field.name();
        fields.put(fieldName, field.type());
        if (FieldType.isCompound(field.type())) {
            for (Field nestedField : field.properties()) {
                Mapping.addSubFieldToMap(fields, nestedField, fieldName);
            }
        }
    }

    public String toString() {
        if (this.type != "") {
            return String.format("%s/%s=%s", this.index, this.type, Arrays.toString(this.fields));
        }
        return String.format("%s=%s", this.index, Arrays.toString(this.fields));
    }

    public boolean equals(Object o) {
        if (!(o instanceof Mapping)) {
            return false;
        }
        Mapping other = (Mapping)o;
        return Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.deepEquals(this.fields, other.fields);
    }
}

