/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.spark.sql.streaming.EsSinkStatus;
import org.elasticsearch.spark.sql.streaming.JobState;
import org.elasticsearch.spark.sql.streaming.TaskCommit;
import org.elasticsearch.spark.sql.streaming.TaskState;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\n\u0014\u0001yA\u0001\"\r\u0001\u0003\u0006\u0004%\tA\r\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005g!)!\n\u0001C\u0001\u0017\"Aa\n\u0001EC\u0002\u0013\u0005q\nC\u0003Z\u0001\u0011\u0005!\fC\u0003d\u0001\u0011\u0005A\rC\u0003o\u0001\u0011\u0005q\u000eC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"Ia\u000f\u0001a\u0001\u0002\u0004%\ta\u001e\u0005\nu\u0002\u0001\r\u0011!Q!\nMD\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011\u0001:\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0003q\bBCA\u0001\u0001\u0001\u0007\t\u0011)Q\u0005g\"9\u0011Q\u0001\u0001\u0005\u0002\u0005\u001d\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u001d\ti\u0002\u0001C\u0001\u0003?\u0011\u0001#R:D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u000b\u0005Q)\u0012!C:ue\u0016\fW.\u001b8h\u0015\t1r#A\u0002tc2T!\u0001G\r\u0002\u000bM\u0004\u0018M]6\u000b\u0005iY\u0012!D3mCN$\u0018nY:fCJ\u001c\u0007NC\u0001\u001d\u0003\ry'oZ\u0002\u0001'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019rcBA\u0014-\u001d\tA3&D\u0001*\u0015\tQS$\u0001\u0004=e>|GOP\u0005\u0002E%\u0011Q&I\u0001\ba\u0006\u001c7.Y4f\u0013\ty\u0003G\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002.C\u0005I1m\\7nSRdunZ\u000b\u0002gA\u0019A\u0007\u0010 \u000e\u0003UR!\u0001\u0006\u001c\u000b\u0005]B\u0014!C3yK\u000e,H/[8o\u0015\t1\u0012H\u0003\u0002\u0019u)\u00111hG\u0001\u0007CB\f7\r[3\n\u0005u*$aC'fi\u0006$\u0017\r^1M_\u001e\u00042\u0001I B\u0013\t\u0001\u0015EA\u0003BeJ\f\u0017\u0010\u0005\u0002C\u00076\t1#\u0003\u0002E'\taQi]*j].\u001cF/\u0019;vg\u0006Q1m\\7nSRdun\u001a\u0011)\u0005\t9\u0005C\u0001\u0011I\u0013\tI\u0015EA\u0005ue\u0006t7/[3oi\u00061A(\u001b8jiz\"\"\u0001T'\u0011\u0005\t\u0003\u0001\"B\u0019\u0004\u0001\u0004\u0019\u0014A\u00027pO\u001e,'/F\u0001Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0004m_\u001e<\u0017N\\4\u000b\u0005US\u0014aB2p[6|gn]\u0005\u0003/J\u00131\u0001T8hQ\t!q)A\u0004j]&$(j\u001c2\u0015\u0005ms\u0006C\u0001\u0011]\u0013\ti\u0016E\u0001\u0003V]&$\b\"B0\u0006\u0001\u0004\u0001\u0017\u0001\u00036pEN#\u0018\r^3\u0011\u0005\t\u000b\u0017B\u00012\u0014\u0005!QuNY*uCR,\u0017!C2p[6LGOS8c)\rYVM\u001a\u0005\u0006?\u001a\u0001\r\u0001\u0019\u0005\u0006O\u001a\u0001\r\u0001[\u0001\fi\u0006\u001c8nQ8n[&$8\u000fE\u0002'S.L!A\u001b\u0019\u0003\u0007M+\u0017\u000f\u0005\u0002CY&\u0011Qn\u0005\u0002\u000b)\u0006\u001c8nQ8n[&$\u0018\u0001C1c_J$(j\u001c2\u0015\u0005m\u0003\b\"B0\b\u0001\u0004\u0001\u0017A\u0004:fG>\u0014Hm],sSR$XM\\\u000b\u0002gB\u0011\u0001\u0005^\u0005\u0003k\u0006\u0012A\u0001T8oO\u0006\u0011\"/Z2pe\u0012\u001cxK]5ui\u0016tw\fJ3r)\tY\u0006\u0010C\u0004z\u0013\u0005\u0005\t\u0019A:\u0002\u0007a$\u0013'A\bsK\u000e|'\u000fZ:Xe&$H/\u001a8!Q\tQq)\u0001\bfq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;\u0002%\u0015DXmY;uS>t7\u000b^1si~#S-\u001d\u000b\u00037~Dq!\u001f\u0007\u0002\u0002\u0003\u00071/A\bfq\u0016\u001cW\u000f^5p]N#\u0018M\u001d;!Q\tiq)\u0001\u0005j]&$H+Y:l)\rY\u0016\u0011\u0002\u0005\b\u0003\u0017q\u0001\u0019AA\u0007\u0003%!\u0018m]6Ti\u0006$X\rE\u0002C\u0003\u001fI1!!\u0005\u0014\u0005%!\u0016m]6Ti\u0006$X-\u0001\u0006sK\u000e|'\u000fZ*fK:$\u0012aW\u0001\u000bG>lW.\u001b;UCN\\GcA6\u0002\u001c!9\u00111\u0002\tA\u0002\u00055\u0011!C1c_J$H+Y:l)\rY\u0016\u0011\u0005\u0005\b\u0003\u0017\t\u0002\u0019AA\u0007\u0001")
public class EsCommitProtocol
implements Serializable {
    private transient Log logger;
    private final transient MetadataLog<EsSinkStatus[]> commitLog;
    private transient long recordsWritten;
    private transient long executionStart;
    private volatile transient boolean bitmap$trans$0;

    public MetadataLog<EsSinkStatus[]> commitLog() {
        return this.commitLog;
    }

    private Log logger$lzycompute() {
        EsCommitProtocol esCommitProtocol = this;
        synchronized (esCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.logger = LogFactory.getLog(EsCommitProtocol.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Log logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public void initJob(JobState jobState) {
        Assert.notNull(this.commitLog(), "commitLog cannot be null");
    }

    public void commitJob(JobState jobState, Seq<TaskCommit> taskCommits) {
        EsSinkStatus[] commits = (EsSinkStatus[])((IterableOnceOps)taskCommits.flatMap((Function1 & Serializable)x$1 -> x$1.statuses())).toArray(ClassTag$.MODULE$.apply(EsSinkStatus.class));
        if (this.commitLog().add(jobState.batchId(), (Object)commits)) {
            this.logger().debug((Object)new StringBuilder(16).append("Committed batch ").append(jobState.batchId()).toString());
            return;
        }
        throw new IllegalStateException(new StringBuilder(32).append("Batch Id [").append(jobState.batchId()).append("] is already committed").toString());
    }

    public void abortJob(JobState jobState) {
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public void recordsWritten_$eq(long x$1) {
        this.recordsWritten = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public void executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void initTask(TaskState taskState) {
        this.recordsWritten_$eq(0L);
        this.executionStart_$eq(System.currentTimeMillis());
    }

    public void recordSeen() {
        this.recordsWritten_$eq(this.recordsWritten() + 1L);
    }

    public TaskCommit commitTask(TaskState taskState) {
        if (this.recordsWritten() > 0L) {
            return new TaskCommit((Option<EsSinkStatus>)new Some((Object)new EsSinkStatus(taskState.taskId(), this.executionStart(), taskState.resource(), this.recordsWritten())));
        }
        return new TaskCommit((Option<EsSinkStatus>)None$.MODULE$);
    }

    public void abortTask(TaskState taskState) {
    }

    public EsCommitProtocol(MetadataLog<EsSinkStatus[]> commitLog) {
        this.commitLog = commitLog;
    }
}

