/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp.auth.spnego;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.rest.commonshttp.auth.spnego.SpnegoCredentials;
import org.elasticsearch.hadoop.rest.commonshttp.auth.spnego.SpnegoNegotiator;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.Credentials;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.HttpMethod;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.URIException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthScheme;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.AuthenticationException;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.auth.MalformedChallengeException;
import org.elasticsearch.hadoop.util.StringUtils;
import org.ietf.jgss.GSSException;

public class SpnegoAuthScheme
implements AuthScheme,
Closeable {
    private static final String HOSTNAME_PATTERN = "_HOST";
    private String challenge;
    private SpnegoNegotiator spnegoNegotiator;

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    public String getSchemeName() {
        return "Negotiate";
    }

    @Override
    public void processChallenge(String challenge) throws MalformedChallengeException {
        if (StringUtils.hasText(challenge)) {
            this.challenge = challenge.substring("Negotiate".length()).trim();
        }
    }

    protected String getFQDN(URI requestURI) throws UnknownHostException {
        String host = requestURI.getHost();
        InetAddress address = InetAddress.getByName(host);
        return address.getCanonicalHostName();
    }

    private void initializeNegotiator(URI requestURI, SpnegoCredentials spnegoCredentials) throws UnknownHostException, AuthenticationException, GSSException {
        if (this.spnegoNegotiator == null) {
            User userInfo;
            KerberosPrincipal principal;
            String servicePrincipal = spnegoCredentials.getServicePrincipalName();
            if (spnegoCredentials.getServicePrincipalName().contains(HOSTNAME_PATTERN)) {
                String fqdn = this.getFQDN(requestURI);
                String[] components = spnegoCredentials.getServicePrincipalName().split("[/@]");
                if (components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
                    throw new AuthenticationException("Malformed service principal name [" + spnegoCredentials.getServicePrincipalName() + "]. To use host substitution, the principal must be of the format [serviceName/_HOST@REALM.NAME].");
                }
                servicePrincipal = components[0] + "/" + fqdn.toLowerCase() + "@" + components[2];
            }
            if ((principal = (userInfo = spnegoCredentials.getUserProvider().getUser()).getKerberosPrincipal()) == null) {
                throw new EsHadoopIllegalArgumentException("Could not locate Kerberos Principal on currently logged in user.");
            }
            this.spnegoNegotiator = new SpnegoNegotiator(principal.getName(), servicePrincipal);
        }
    }

    private String getNegotiateToken() throws GSSException {
        if (this.spnegoNegotiator == null) {
            throw new IllegalStateException("Negotiator not yet initialized.");
        }
        String authString = StringUtils.hasText(this.challenge) ? this.spnegoNegotiator.send(this.challenge) : this.spnegoNegotiator.send();
        this.challenge = null;
        if (authString != null) {
            authString = "Negotiate " + authString;
        }
        return authString;
    }

    private String authenticate(Credentials credentials, URI requestURI) throws AuthenticationException {
        if (!(credentials instanceof SpnegoCredentials)) {
            throw new AuthenticationException("Invalid credentials type provided to " + this.getClass().getName() + ".Expected " + SpnegoCredentials.class.getName() + " but got " + credentials.getClass().getName());
        }
        SpnegoCredentials spnegoCredentials = (SpnegoCredentials)credentials;
        try {
            this.initializeNegotiator(requestURI, spnegoCredentials);
            return this.getNegotiateToken();
        }
        catch (GSSException e) {
            throw new AuthenticationException("Could not authenticate", e);
        }
        catch (UnknownHostException e) {
            throw new AuthenticationException("Could not authenticate", e);
        }
    }

    @Override
    public String authenticate(Credentials credentials, HttpMethod method) throws AuthenticationException {
        try {
            return this.authenticate(credentials, URI.create(method.getURI().getURI()));
        }
        catch (URIException e) {
            throw new AuthenticationException("Could not determine request URI", e);
        }
    }

    @Override
    public String authenticate(Credentials credentials, String method, String uri) throws AuthenticationException {
        return this.authenticate(credentials, URI.create(uri));
    }

    public void ensureMutualAuth(String returnChallenge) throws AuthenticationException {
        try {
            this.processChallenge(returnChallenge);
        }
        catch (MalformedChallengeException mce) {
            throw new AuthenticationException("Received invalid response header for mutual authentication", mce);
        }
        try {
            String token = this.getNegotiateToken();
            if (!this.spnegoNegotiator.established() || token != null) {
                throw new AuthenticationException("Could not complete SPNEGO Authentication, Mutual Authentication Failed");
            }
        }
        catch (GSSException gsse) {
            throw new AuthenticationException("Could not complete SPNEGO Authentication", gsse);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.spnegoNegotiator != null) {
            this.spnegoNegotiator.close();
        }
        this.challenge = null;
    }

    @Override
    public boolean isComplete() {
        return this.spnegoNegotiator.established();
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public String getParameter(String name) {
        return null;
    }

    @Override
    public String getID() {
        return this.getSchemeName();
    }
}

