/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.handler.write.impl;

import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.handler.ErrorHandler;
import org.elasticsearch.hadoop.handler.impl.AbortOnFailure;
import org.elasticsearch.hadoop.handler.impl.AbstractHandlerLoader;
import org.elasticsearch.hadoop.handler.impl.DropAndLog;
import org.elasticsearch.hadoop.handler.impl.elasticsearch.ElasticsearchHandler;
import org.elasticsearch.hadoop.serialization.handler.write.ISerializationErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.write.impl.DelegatingErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.write.impl.SerializationEventConverter;
import org.elasticsearch.hadoop.serialization.handler.write.impl.SerializationLogRenderer;

public class SerializationHandlerLoader
extends AbstractHandlerLoader<ISerializationErrorHandler> {
    public static final String ES_WRITE_DATA_ERROR_HANDLERS = "es.write.data.error.handlers";
    public static final String ES_WRITE_DATA_ERROR_HANDLER = "es.write.data.error.handler";

    public SerializationHandlerLoader() {
        super(ISerializationErrorHandler.class);
    }

    @Override
    protected String getHandlersPropertyName() {
        return ES_WRITE_DATA_ERROR_HANDLERS;
    }

    @Override
    protected String getHandlerPropertyName() {
        return ES_WRITE_DATA_ERROR_HANDLER;
    }

    @Override
    protected ISerializationErrorHandler loadBuiltInHandler(AbstractHandlerLoader.NamedHandlers handlerName) {
        ErrorHandler genericHandler;
        switch (handlerName) {
            case FAIL: {
                genericHandler = AbortOnFailure.create();
                break;
            }
            case LOG: {
                genericHandler = DropAndLog.create(new SerializationLogRenderer());
                break;
            }
            case ES: {
                genericHandler = ElasticsearchHandler.create(this.getSettings(), new SerializationEventConverter());
                break;
            }
            default: {
                throw new EsHadoopIllegalArgumentException("Could not find default implementation for built in handler type [" + (Object)((Object)handlerName) + "]");
            }
        }
        return new DelegatingErrorHandler(genericHandler);
    }
}

