/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public final class GetApiKeyRequest
extends LegacyActionRequest {
    private final String realmName;
    private final String userName;
    private final String apiKeyId;
    private final String apiKeyName;
    private final boolean ownedByAuthenticatedUser;
    private final boolean withLimitedBy;
    private final boolean activeOnly;
    private final boolean withProfileUid;

    private GetApiKeyRequest(@Nullable String realmName, @Nullable String userName, @Nullable String apiKeyId, @Nullable String apiKeyName, boolean ownedByAuthenticatedUser, boolean withLimitedBy, boolean activeOnly, boolean withProfileUid) {
        this.realmName = GetApiKeyRequest.textOrNull(realmName);
        this.userName = GetApiKeyRequest.textOrNull(userName);
        this.apiKeyId = GetApiKeyRequest.textOrNull(apiKeyId);
        this.apiKeyName = GetApiKeyRequest.textOrNull(apiKeyName);
        this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
        this.withLimitedBy = withLimitedBy;
        this.activeOnly = activeOnly;
        this.withProfileUid = withProfileUid;
    }

    private static String textOrNull(@Nullable String arg) {
        return Strings.hasText(arg) ? arg : null;
    }

    public String getRealmName() {
        return this.realmName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getApiKeyId() {
        return this.apiKeyId;
    }

    public String getApiKeyName() {
        return this.apiKeyName;
    }

    public boolean ownedByAuthenticatedUser() {
        return this.ownedByAuthenticatedUser;
    }

    public boolean withLimitedBy() {
        return this.withLimitedBy;
    }

    public boolean activeOnly() {
        return this.activeOnly;
    }

    public boolean withProfileUid() {
        return this.withProfileUid;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if ((Strings.hasText(this.apiKeyId) || Strings.hasText(this.apiKeyName)) && (Strings.hasText(this.realmName) || Strings.hasText(this.userName))) {
            validationException = ValidateActions.addValidationError("username or realm name must not be specified when the api key id or api key name is specified", validationException);
        }
        if (this.ownedByAuthenticatedUser && (Strings.hasText(this.realmName) || Strings.hasText(this.userName))) {
            validationException = ValidateActions.addValidationError("neither username nor realm-name may be specified when retrieving owned API keys", validationException);
        }
        if (Strings.hasText(this.apiKeyId) && Strings.hasText(this.apiKeyName)) {
            validationException = ValidateActions.addValidationError("only one of [api key id, api key name] can be specified", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetApiKeyRequest that = (GetApiKeyRequest)o;
        return this.ownedByAuthenticatedUser == that.ownedByAuthenticatedUser && Objects.equals(this.realmName, that.realmName) && Objects.equals(this.userName, that.userName) && Objects.equals(this.apiKeyId, that.apiKeyId) && Objects.equals(this.apiKeyName, that.apiKeyName) && this.withLimitedBy == that.withLimitedBy && this.activeOnly == that.activeOnly && this.withProfileUid == that.withProfileUid;
    }

    public int hashCode() {
        return Objects.hash(this.realmName, this.userName, this.apiKeyId, this.apiKeyName, this.ownedByAuthenticatedUser, this.withLimitedBy, this.activeOnly, this.withProfileUid);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String realmName = null;
        private String userName = null;
        private String apiKeyId = null;
        private String apiKeyName = null;
        private boolean ownedByAuthenticatedUser = false;
        private boolean withLimitedBy = false;
        private boolean activeOnly = false;
        private boolean withProfileUid = false;

        public Builder realmName(String realmName) {
            this.realmName = realmName;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder apiKeyId(String apiKeyId) {
            this.apiKeyId = apiKeyId;
            return this;
        }

        public Builder apiKeyName(String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        public Builder ownedByAuthenticatedUser() {
            return this.ownedByAuthenticatedUser(true);
        }

        public Builder ownedByAuthenticatedUser(boolean ownedByAuthenticatedUser) {
            this.ownedByAuthenticatedUser = ownedByAuthenticatedUser;
            return this;
        }

        public Builder withLimitedBy() {
            return this.withLimitedBy(true);
        }

        public Builder withLimitedBy(boolean withLimitedBy) {
            this.withLimitedBy = withLimitedBy;
            return this;
        }

        public Builder activeOnly(boolean activeOnly) {
            this.activeOnly = activeOnly;
            return this;
        }

        public Builder withProfileUid(boolean withProfileUid) {
            this.withProfileUid = withProfileUid;
            return this;
        }

        public GetApiKeyRequest build() {
            return new GetApiKeyRequest(this.realmName, this.userName, this.apiKeyId, this.apiKeyName, this.ownedByAuthenticatedUser, this.withLimitedBy, this.activeOnly, this.withProfileUid);
        }
    }
}

