/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import java.net.InetAddress;
import java.util.Objects;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.script.IpFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractIpScriptFieldQuery;

public class IpScriptFieldTermQuery
extends AbstractIpScriptFieldQuery {
    private final BytesRef term;

    public IpScriptFieldTermQuery(Script script, IpFieldScript.LeafFactory leafFactory, String fieldName, BytesRef term) {
        super(script, leafFactory, fieldName);
        this.term = term;
    }

    @Override
    protected boolean matches(BytesRef[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (!this.term.bytesEquals(values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return InetAddresses.toAddrString(this.address());
        }
        return this.fieldName() + ":" + InetAddresses.toAddrString(this.address());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.term);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        IpScriptFieldTermQuery other = (IpScriptFieldTermQuery)obj;
        return this.term.bytesEquals(other.term);
    }

    InetAddress address() {
        return IpScriptFieldTermQuery.decode(this.term);
    }
}

