/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.Map;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;

public class LicensedAllocatedPersistentTask
extends AllocatedPersistentTask {
    private final LicensedFeature.Persistent licensedFeature;
    private final String featureContext;
    private final XPackLicenseState licenseState;

    public LicensedAllocatedPersistentTask(long id, String type, String action, String description, TaskId parentTask, Map<String, String> headers, LicensedFeature.Persistent feature, String featureContext, XPackLicenseState licenseState) {
        super(id, type, action, description, parentTask, headers);
        this.licensedFeature = feature;
        this.featureContext = featureContext;
        this.licenseState = licenseState;
        this.licensedFeature.startTracking(licenseState, featureContext);
    }

    private void stopTracking() {
        this.licensedFeature.stopTracking(this.licenseState, this.featureContext);
    }

    @Override
    protected final boolean markAsCancelled() {
        this.stopTracking();
        return this.doMarkAsCancelled();
    }

    protected boolean doMarkAsCancelled() {
        return super.markAsCancelled();
    }

    @Override
    public final void markAsCompleted() {
        this.stopTracking();
        this.doMarkAsCompleted();
    }

    protected void doMarkAsCompleted() {
        super.markAsCompleted();
    }

    @Override
    public final void markAsFailed(Exception e) {
        this.stopTracking();
        this.doMarkAsFailed(e);
    }

    protected void doMarkAsFailed(Exception e) {
        super.markAsFailed(e);
    }

    @Override
    public final void markAsLocallyAborted(String localAbortReason) {
        this.stopTracking();
        this.doMarkAsLocallyAborted(localAbortReason);
    }

    protected void doMarkAsLocallyAborted(String localAbortReason) {
        super.markAsLocallyAborted(localAbortReason);
    }

    @Override
    public final void init(PersistentTasksService persistentTasksService, TaskManager taskManager, String persistentTaskId, long allocationId) {
        super.init(persistentTasksService, taskManager, persistentTaskId, allocationId);
    }
}

