/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.indices.recovery.RecoveryTransportRequest;

public class RecoveryCleanFilesRequest
extends RecoveryTransportRequest {
    private final Store.MetadataSnapshot snapshotFiles;
    private final int totalTranslogOps;
    private final long globalCheckpoint;

    public RecoveryCleanFilesRequest(long recoveryId, long requestSeqNo, ShardId shardId, Store.MetadataSnapshot snapshotFiles, int totalTranslogOps, long globalCheckpoint) {
        super(requestSeqNo, recoveryId, shardId);
        this.snapshotFiles = snapshotFiles;
        this.totalTranslogOps = totalTranslogOps;
        this.globalCheckpoint = globalCheckpoint;
    }

    RecoveryCleanFilesRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshotFiles = Store.MetadataSnapshot.readFrom(in);
        this.totalTranslogOps = in.readVInt();
        this.globalCheckpoint = in.readZLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.snapshotFiles.writeTo(out);
        out.writeVInt(this.totalTranslogOps);
        out.writeZLong(this.globalCheckpoint);
    }

    public Store.MetadataSnapshot sourceMetaSnapshot() {
        return this.snapshotFiles;
    }

    public int totalTranslogOps() {
        return this.totalTranslogOps;
    }

    public long getGlobalCheckpoint() {
        return this.globalCheckpoint;
    }
}

