/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.script.field.ToScriptFieldFactory;

public final class SortedSetBytesLeafFieldData
extends AbstractLeafOrdinalsFieldData {
    private final LeafReader reader;
    private final String field;

    SortedSetBytesLeafFieldData(LeafReader reader, String field, ToScriptFieldFactory<SortedSetDocValues> toScriptFieldFactory) {
        super(toScriptFieldFactory);
        this.reader = reader;
        this.field = field;
    }

    @Override
    public SortedSetDocValues getOrdinalsValues() {
        try {
            return DocValues.getSortedSet(this.reader, this.field);
        }
        catch (IOException e) {
            throw new IllegalStateException("cannot load docvalues", e);
        }
    }

    @Override
    public long ramBytesUsed() {
        return 0L;
    }
}

