/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.InferenceConfig;
import co.elastic.clients.elasticsearch.ingest.InferenceConfigVariant;
import co.elastic.clients.elasticsearch.ingest.InputConfig;
import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String modelId;
    @Nullable
    private final String targetField;
    private final Map<String, JsonData> fieldMap;
    @Nullable
    private final InferenceConfig inferenceConfig;
    private final List<InputConfig> inputOutput;
    @Nullable
    private final Boolean ignoreMissing;
    public static final JsonpDeserializer<InferenceProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceProcessor::setupInferenceProcessorDeserializer);

    private InferenceProcessor(Builder builder) {
        super(builder);
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.targetField = builder.targetField;
        this.fieldMap = ApiTypeHelper.unmodifiable(builder.fieldMap);
        this.inferenceConfig = builder.inferenceConfig;
        this.inputOutput = ApiTypeHelper.unmodifiable(builder.inputOutput);
        this.ignoreMissing = builder.ignoreMissing;
    }

    public static InferenceProcessor of(Function<Builder, ObjectBuilder<InferenceProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Inference;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    public final Map<String, JsonData> fieldMap() {
        return this.fieldMap;
    }

    @Nullable
    public final InferenceConfig inferenceConfig() {
        return this.inferenceConfig;
    }

    public final List<InputConfig> inputOutput() {
        return this.inputOutput;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (ApiTypeHelper.isDefined(this.fieldMap)) {
            generator.writeKey("field_map");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> entry : this.fieldMap.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.inferenceConfig != null) {
            generator.writeKey("inference_config");
            this.inferenceConfig.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.inputOutput)) {
            generator.writeKey("input_output");
            generator.writeStartArray();
            for (InputConfig inputConfig : this.inputOutput) {
                inputConfig.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
    }

    protected static void setupInferenceProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::fieldMap, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "field_map");
        op.add(Builder::inferenceConfig, InferenceConfig._DESERIALIZER, "inference_config");
        op.add(Builder::inputOutput, JsonpDeserializer.arrayDeserializer(InputConfig._DESERIALIZER), "input_output");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceProcessor> {
        private String modelId;
        @Nullable
        private String targetField;
        @Nullable
        private Map<String, JsonData> fieldMap;
        @Nullable
        private InferenceConfig inferenceConfig;
        @Nullable
        private List<InputConfig> inputOutput;
        @Nullable
        private Boolean ignoreMissing;

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder fieldMap(Map<String, JsonData> map) {
            this.fieldMap = Builder._mapPutAll(this.fieldMap, map);
            return this;
        }

        public final Builder fieldMap(String key, JsonData value) {
            this.fieldMap = Builder._mapPut(this.fieldMap, key, value);
            return this;
        }

        public final Builder inferenceConfig(@Nullable InferenceConfig value) {
            this.inferenceConfig = value;
            return this;
        }

        public final Builder inferenceConfig(Function<InferenceConfig.Builder, ObjectBuilder<InferenceConfig>> fn) {
            return this.inferenceConfig(fn.apply(new InferenceConfig.Builder()).build());
        }

        public final Builder inferenceConfig(InferenceConfigVariant value) {
            this.inferenceConfig = value._toInferenceConfig();
            return this;
        }

        public final Builder inputOutput(List<InputConfig> list) {
            this.inputOutput = Builder._listAddAll(this.inputOutput, list);
            return this;
        }

        public final Builder inputOutput(InputConfig value, InputConfig ... values) {
            this.inputOutput = Builder._listAdd(this.inputOutput, value, values);
            return this;
        }

        public final Builder inputOutput(Function<InputConfig.Builder, ObjectBuilder<InputConfig>> fn) {
            return this.inputOutput(fn.apply(new InputConfig.Builder()).build(), new InputConfig[0]);
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceProcessor build() {
            this._checkSingleUse();
            return new InferenceProcessor(this);
        }
    }
}

