/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.config.ir.graph;

import java.util.stream.Stream;
import org.logstash.common.SourceWithMetadata;
import org.logstash.config.ir.InvalidIRException;
import org.logstash.config.ir.SourceComponent;
import org.logstash.config.ir.graph.Graph;
import org.logstash.config.ir.graph.Vertex;

public abstract class Edge
implements SourceComponent {
    private final Vertex from;
    private final Vertex to;
    private Graph graph;

    protected Edge(Vertex from, Vertex to) throws InvalidIRException {
        this.from = from;
        this.to = to;
        if (this.from == this.to) {
            throw new InvalidIRException("Cannot create a cyclic vertex! " + String.valueOf(to));
        }
        if (!this.from.acceptsOutgoingEdge(this)) {
            throw new Vertex.InvalidEdgeTypeException(String.format("Invalid outgoing edge %s for edge %s", this.from, this));
        }
    }

    public void setGraph(Graph graph) {
        if (this.graph == graph) {
            return;
        }
        if (this.graph != null) {
            throw new IllegalArgumentException("Attempted to set graph for edge that already has one!" + String.valueOf(this));
        }
        this.graph = graph;
    }

    public final int hashCode() {
        return 37 * this.from.hashCode() + this.to.hashCode();
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        Edge that = (Edge)other;
        return this.from.equals(that.from) && this.to.equals(that.to);
    }

    public abstract Edge copy(Vertex var1, Vertex var2) throws InvalidIRException;

    public Stream<Edge> ancestors() {
        return Stream.concat(this.from.incomingEdges(), this.from.incomingEdges().flatMap(Edge::ancestors).distinct()).distinct();
    }

    public Stream<Edge> descendants() {
        return Stream.concat(this.to.outgoingEdges(), this.to.outgoingEdges().flatMap(Edge::ancestors).distinct()).distinct();
    }

    public Stream<Edge> lineage() {
        return Stream.concat(Stream.concat(this.ancestors(), Stream.of(this)), this.descendants());
    }

    public Vertex getTo() {
        return this.to;
    }

    public Vertex getFrom() {
        return this.from;
    }

    public String toString() {
        return String.valueOf(this.getFrom()) + " -> " + String.valueOf(this.getTo());
    }

    @Override
    public boolean sourceComponentEquals(SourceComponent sourceComponent) {
        if (sourceComponent == null) {
            return false;
        }
        if (sourceComponent == this) {
            return true;
        }
        if (sourceComponent.getClass() == this.getClass()) {
            Edge otherE = (Edge)sourceComponent;
            return this.getFrom().sourceComponentEquals(otherE.getFrom()) && this.getTo().sourceComponentEquals(otherE.getTo());
        }
        return false;
    }

    public abstract String individualHashSource();

    public abstract String getId();

    @Override
    public SourceWithMetadata getSourceWithMetadata() {
        return null;
    }

    public static abstract class EdgeFactory {
        public abstract Edge make(Vertex var1, Vertex var2) throws InvalidIRException;
    }
}

