/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.transport.actions.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.watcher.support.WatcherUtils;

public class GetWatchRequest
extends LegacyActionRequest {
    private String id;

    public GetWatchRequest() {
    }

    public GetWatchRequest(String id) {
        this.id = id;
    }

    public GetWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
    }

    GetWatchRequest setId(String id) {
        this.id = id;
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("watch id is missing", validationException);
        } else if (!WatcherUtils.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError("watch id contains whitespace", validationException);
        }
        return validationException;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return "get [" + this.id + "]";
    }
}

