/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;

public interface IndexAnalyzers
extends Closeable {
    public NamedAnalyzer getAnalyzer(AnalyzerType var1, String var2);

    default public NamedAnalyzer get(String name) {
        return this.getAnalyzer(AnalyzerType.ANALYZER, name);
    }

    default public NamedAnalyzer getNormalizer(String name) {
        return this.getAnalyzer(AnalyzerType.NORMALIZER, name);
    }

    default public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.getAnalyzer(AnalyzerType.WHITESPACE, name);
    }

    default public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.getAnalyzer(AnalyzerType.ANALYZER, "default");
    }

    default public NamedAnalyzer getDefaultSearchAnalyzer() {
        NamedAnalyzer analyzer = this.getAnalyzer(AnalyzerType.ANALYZER, "default_search");
        if (analyzer != null) {
            return analyzer;
        }
        return this.getDefaultIndexAnalyzer();
    }

    default public NamedAnalyzer getDefaultSearchQuoteAnalyzer() {
        NamedAnalyzer analyzer = this.getAnalyzer(AnalyzerType.ANALYZER, "default_search_quoted");
        if (analyzer != null) {
            return analyzer;
        }
        return this.getDefaultSearchAnalyzer();
    }

    default public List<String> reload(AnalysisRegistry analysisRegistry, IndexSettings indexSettings, String resource, boolean preview) throws IOException {
        return List.of();
    }

    @Override
    default public void close() throws IOException {
    }

    public static IndexAnalyzers of(Map<String, NamedAnalyzer> analyzers) {
        return IndexAnalyzers.of(analyzers, Map.of(), Map.of());
    }

    public static IndexAnalyzers of(Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> tokenizers) {
        return IndexAnalyzers.of(analyzers, tokenizers, Map.of());
    }

    public static IndexAnalyzers of(final Map<String, NamedAnalyzer> analyzers, final Map<String, NamedAnalyzer> normalizers, final Map<String, NamedAnalyzer> whitespaceNormalizers) {
        return new IndexAnalyzers(){

            @Override
            public NamedAnalyzer getAnalyzer(AnalyzerType type, String name) {
                return switch (type.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 0 -> (NamedAnalyzer)analyzers.get(name);
                    case 1 -> (NamedAnalyzer)normalizers.get(name);
                    case 2 -> (NamedAnalyzer)whitespaceNormalizers.get(name);
                };
            }

            @Override
            public void close() throws IOException {
                IOUtils.close(Stream.of(analyzers.values().stream(), normalizers.values().stream(), whitespaceNormalizers.values().stream()).flatMap(s -> s).filter(a -> a.scope() == AnalyzerScope.INDEX).toList());
            }

            @Override
            public List<String> reload(AnalysisRegistry registry, IndexSettings indexSettings, String resource, boolean preview) throws IOException {
                List<NamedAnalyzer> reloadableAnalyzers = analyzers.values().stream().filter(a -> {
                    ReloadableCustomAnalyzer ra;
                    Analyzer patt0$temp = a.analyzer();
                    return patt0$temp instanceof ReloadableCustomAnalyzer && (ra = (ReloadableCustomAnalyzer)patt0$temp).usesResource(resource);
                }).toList();
                if (reloadableAnalyzers.isEmpty()) {
                    return List.of();
                }
                if (!preview) {
                    Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(indexSettings);
                    Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(indexSettings);
                    Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(indexSettings);
                    Map<String, Settings> settings = indexSettings.getSettings().getGroups("index.analysis.analyzer");
                    for (NamedAnalyzer analyzer : reloadableAnalyzers) {
                        String name = analyzer.name();
                        Settings analyzerSettings = settings.get(name);
                        ReloadableCustomAnalyzer reloadableAnalyzer = (ReloadableCustomAnalyzer)analyzer.analyzer();
                        reloadableAnalyzer.reload(name, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
                    }
                }
                return reloadableAnalyzers.stream().map(NamedAnalyzer::name).toList();
            }
        };
    }

    public static enum AnalyzerType {
        ANALYZER,
        NORMALIZER,
        WHITESPACE;

    }
}

