/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStatePublicationEvent;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.coordination.CleanableResponseHandler;
import org.elasticsearch.cluster.coordination.ClusterStateSerializationStats;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.PublishClusterStateStats;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.CheckedSupplier;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.PositionTrackingOutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.RecyclerBytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.LazyInitializable;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Strings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class PublicationTransportHandler {
    private static final Logger logger = LogManager.getLogger(PublicationTransportHandler.class);
    public static final String PUBLISH_STATE_ACTION_NAME = "internal:cluster/coordination/publish_state";
    private final TransportService transportService;
    private final Executor clusterCoordinationExecutor;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest;
    private final AtomicReference<ClusterState> lastSeenClusterState = new AtomicReference();
    private final AtomicLong fullClusterStateReceivedCount = new AtomicLong();
    private final AtomicLong incompatibleClusterStateDiffReceivedCount = new AtomicLong();
    private final AtomicLong compatibleClusterStateDiffReceivedCount = new AtomicLong();
    private static final TransportRequestOptions STATE_REQUEST_OPTIONS = TransportRequestOptions.of(null, TransportRequestOptions.Type.STATE);
    public static final TransportVersion INCLUDES_LAST_COMMITTED_DATA_VERSION = TransportVersions.V_8_6_0;
    private final SerializationStatsTracker serializationStatsTracker = new SerializationStatsTracker();

    public PublicationTransportHandler(TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest) {
        this.transportService = transportService;
        this.clusterCoordinationExecutor = transportService.getThreadPool().executor("cluster_coordination");
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.handlePublishRequest = handlePublishRequest;
        transportService.registerRequestHandler(PUBLISH_STATE_ACTION_NAME, transportService.getThreadPool().generic(), false, false, BytesTransportRequest::new, (request, channel, task) -> this.handleIncomingPublishRequest((BytesTransportRequest)request, (ActionListener<PublishWithJoinResponse>)new ChannelActionListener<PublishWithJoinResponse>(channel)));
    }

    public PublishClusterStateStats stats() {
        return new PublishClusterStateStats(this.fullClusterStateReceivedCount.get(), this.incompatibleClusterStateDiffReceivedCount.get(), this.compatibleClusterStateDiffReceivedCount.get(), this.serializationStatsTracker.getSerializationStats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIncomingPublishRequest(BytesTransportRequest request, ActionListener<PublishWithJoinResponse> publishResponseListener) throws IOException {
        block18: {
            assert (ThreadPool.assertCurrentThreadPool("generic"));
            Compressor compressor = CompressorFactory.compressorForUnknownXContentType(request.bytes());
            StreamInput in = request.bytes().streamInput();
            try {
                if (compressor != null) {
                    in = compressor.threadLocalStreamInput(in);
                }
                in = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);
                in.setTransportVersion(request.version());
                if (in.readBoolean()) {
                    ClusterState incomingState;
                    try (StreamInput input = in;){
                        incomingState = ClusterState.readFrom(input, this.transportService.getLocalNode());
                        assert (input.read() == -1);
                    }
                    catch (Exception e) {
                        logger.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
                        assert (false) : e;
                        throw e;
                    }
                    this.fullClusterStateReceivedCount.incrementAndGet();
                    logger.debug("received full cluster state version [{}] with size [{}]", (Object)incomingState.version(), (Object)request.bytes().length());
                    this.acceptState(incomingState, publishResponseListener.map(response -> {
                        this.lastSeenClusterState.set(incomingState);
                        return response;
                    }));
                    break block18;
                }
                ClusterState lastSeen = this.lastSeenClusterState.get();
                if (lastSeen == null) {
                    logger.debug("received diff for but don't have any local cluster state - requesting full state");
                    this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
                    throw new IncompatibleClusterStateVersionException("have no local cluster state");
                }
                ClusterState incomingState = this.deserializeAndApplyDiff(request, in, lastSeen);
                this.compatibleClusterStateDiffReceivedCount.incrementAndGet();
                logger.debug("received diff cluster state version [{}] with uuid [{}], diff size [{}]", (Object)incomingState.version(), (Object)incomingState.stateUUID(), (Object)request.bytes().length());
                this.acceptState(incomingState, publishResponseListener.map(response -> {
                    this.lastSeenClusterState.compareAndSet(lastSeen, incomingState);
                    return response;
                }));
            }
            finally {
                IOUtils.close((Closeable)in);
            }
        }
    }

    private ClusterState deserializeAndApplyDiff(BytesTransportRequest request, StreamInput in, ClusterState currentState) throws IOException {
        ClusterState incomingState;
        try {
            Metadata adjustedMetadata;
            CoordinationMetadata.VotingConfiguration lastCommittedConfiguration;
            boolean clusterUuidCommitted;
            Diff<ClusterState> diff;
            boolean includesLastCommittedData = request.version().onOrAfter(INCLUDES_LAST_COMMITTED_DATA_VERSION);
            try (StreamInput input = in;){
                diff = ClusterState.readDiffFrom(input, currentState.nodes().getLocalNode());
                if (includesLastCommittedData) {
                    clusterUuidCommitted = in.readBoolean();
                    lastCommittedConfiguration = new CoordinationMetadata.VotingConfiguration(in);
                } else {
                    clusterUuidCommitted = false;
                    lastCommittedConfiguration = null;
                }
                assert (input.read() == -1);
            }
            incomingState = diff.apply(currentState);
            if (includesLastCommittedData && (adjustedMetadata = incomingState.metadata().withLastCommittedValues(clusterUuidCommitted, lastCommittedConfiguration)) != incomingState.metadata()) {
                incomingState = ClusterState.builder(incomingState).metadata(adjustedMetadata).build();
            }
        }
        catch (IncompatibleClusterStateVersionException e) {
            this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
            throw e;
        }
        catch (Exception e) {
            logger.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
            assert (false) : e;
            throw e;
        }
        return incomingState;
    }

    private void acceptState(final ClusterState incomingState, ActionListener<PublishWithJoinResponse> actionListener) {
        assert (!incomingState.nodes().isLocalNodeElectedMaster()) : "should handle local publications locally, but got " + String.valueOf(incomingState);
        this.clusterCoordinationExecutor.execute(ActionRunnable.supply(actionListener, new CheckedSupplier<PublishWithJoinResponse, Exception>(){

            @Override
            public PublishWithJoinResponse get() {
                return PublicationTransportHandler.this.handlePublishRequest.apply(new PublishRequest(incomingState));
            }

            public String toString() {
                return "acceptState[term=" + incomingState.term() + ",version=" + incomingState.version() + "]";
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PublicationContext newPublicationContext(ClusterStatePublicationEvent clusterStatePublicationEvent) {
        PublicationContext publicationContext = new PublicationContext(clusterStatePublicationEvent);
        boolean success = false;
        try {
            publicationContext.buildDiffAndSerializeStates();
            success = true;
            PublicationContext publicationContext2 = publicationContext;
            return publicationContext2;
        }
        finally {
            if (!success) {
                publicationContext.decRef();
            }
        }
    }

    private ReleasableBytesReference serializeFullClusterState(ClusterState clusterState, DiscoveryNode node, TransportVersion version) {
        try (RecyclerBytesStreamOutput bytesStream = this.transportService.newNetworkBytesStream();){
            long uncompressedBytes;
            try (PositionTrackingOutputStreamStreamOutput stream = new PositionTrackingOutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStream)));){
                stream.setTransportVersion(version);
                stream.writeBoolean(true);
                clusterState.writeTo(stream);
                uncompressedBytes = ((StreamOutput)stream).position();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster state for publishing to node {}", (Throwable)e, node);
            }
            int size = bytesStream.size();
            this.serializationStatsTracker.serializedFullState(uncompressedBytes, size);
            logger.trace("serialized full cluster state version [{}] using transport version [{}] with size [{}]", (Object)clusterState.version(), (Object)version, (Object)size);
            ReleasableBytesReference releasableBytesReference = bytesStream.moveToBytesReference();
            return releasableBytesReference;
        }
    }

    private ReleasableBytesReference serializeDiffClusterState(ClusterState newState, Diff<ClusterState> diff, DiscoveryNode node, TransportVersion version) {
        long clusterStateVersion = newState.version();
        try (RecyclerBytesStreamOutput bytesStream = this.transportService.newNetworkBytesStream();){
            long uncompressedBytes;
            try (PositionTrackingOutputStreamStreamOutput stream = new PositionTrackingOutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(Streams.flushOnCloseStream(bytesStream)));){
                stream.setTransportVersion(version);
                stream.writeBoolean(false);
                diff.writeTo(stream);
                if (version.onOrAfter(INCLUDES_LAST_COMMITTED_DATA_VERSION)) {
                    stream.writeBoolean(newState.metadata().clusterUUIDCommitted());
                    newState.getLastCommittedConfiguration().writeTo(stream);
                }
                uncompressedBytes = ((StreamOutput)stream).position();
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to serialize cluster state diff for publishing to node {}", (Throwable)e, node);
            }
            int size = bytesStream.size();
            this.serializationStatsTracker.serializedDiff(uncompressedBytes, size);
            logger.trace("serialized cluster state diff for version [{}] using transport version [{}] with size [{}]", (Object)clusterStateVersion, (Object)version, (Object)size);
            ReleasableBytesReference releasableBytesReference = bytesStream.moveToBytesReference();
            return releasableBytesReference;
        }
    }

    private static class SerializationStatsTracker {
        private long fullStateCount;
        private long totalUncompressedFullStateBytes;
        private long totalCompressedFullStateBytes;
        private long diffCount;
        private long totalUncompressedDiffBytes;
        private long totalCompressedDiffBytes;

        private SerializationStatsTracker() {
        }

        public synchronized void serializedFullState(long uncompressedBytes, int compressedBytes) {
            ++this.fullStateCount;
            this.totalUncompressedFullStateBytes += uncompressedBytes;
            this.totalCompressedFullStateBytes += (long)compressedBytes;
        }

        public synchronized void serializedDiff(long uncompressedBytes, int compressedBytes) {
            ++this.diffCount;
            this.totalUncompressedDiffBytes += uncompressedBytes;
            this.totalCompressedDiffBytes += (long)compressedBytes;
        }

        public synchronized ClusterStateSerializationStats getSerializationStats() {
            return new ClusterStateSerializationStats(this.fullStateCount, this.totalUncompressedFullStateBytes, this.totalCompressedFullStateBytes, this.diffCount, this.totalUncompressedDiffBytes, this.totalCompressedDiffBytes);
        }
    }

    public class PublicationContext
    extends AbstractRefCounted {
        private final DiscoveryNodes discoveryNodes;
        private final ClusterState newState;
        private final ClusterState previousState;
        private final Task task;
        private final boolean sendFullVersion;
        private final Map<DiscoveryNode, Transport.Connection> nodeConnections = new HashMap<DiscoveryNode, Transport.Connection>();
        private final Map<TransportVersion, ReleasableBytesReference> serializedStates = new ConcurrentHashMap<TransportVersion, ReleasableBytesReference>();
        private final Map<TransportVersion, ReleasableBytesReference> serializedDiffs = new HashMap<TransportVersion, ReleasableBytesReference>();

        PublicationContext(ClusterStatePublicationEvent clusterStatePublicationEvent) {
            this.discoveryNodes = clusterStatePublicationEvent.getNewState().nodes();
            this.newState = clusterStatePublicationEvent.getNewState();
            this.previousState = clusterStatePublicationEvent.getOldState();
            this.task = clusterStatePublicationEvent.getTask();
            this.sendFullVersion = this.previousState.getBlocks().disableStatePersistence();
        }

        void buildDiffAndSerializeStates() {
            assert (this.refCount() > 0);
            LazyInitializable diffSupplier = new LazyInitializable(() -> this.newState.diff(this.previousState));
            for (DiscoveryNode node : this.discoveryNodes) {
                Transport.Connection connection;
                if (node.equals(PublicationTransportHandler.this.transportService.getLocalNode())) continue;
                try {
                    connection = PublicationTransportHandler.this.transportService.getConnection(node);
                }
                catch (NodeNotConnectedException e) {
                    logger.debug(() -> Strings.format("No connection to [%s] available, skipping serialization", node), (Throwable)e);
                    continue;
                }
                this.nodeConnections.put(node, connection);
                if (this.sendFullVersion || !this.previousState.nodes().nodeExists(node)) {
                    this.serializedStates.computeIfAbsent(connection.getTransportVersion(), v -> PublicationTransportHandler.this.serializeFullClusterState(this.newState, node, (TransportVersion)v));
                    continue;
                }
                this.serializedDiffs.computeIfAbsent(connection.getTransportVersion(), v -> PublicationTransportHandler.this.serializeDiffClusterState(this.newState, (Diff)diffSupplier.getOrCompute(), node, (TransportVersion)v));
            }
        }

        public void sendPublishRequest(final DiscoveryNode destination, final PublishRequest publishRequest, ActionListener<PublishWithJoinResponse> listener) {
            assert (this.refCount() > 0);
            assert (publishRequest.getAcceptedState() == this.newState) : "state got switched on us";
            assert (PublicationTransportHandler.this.transportService.getThreadPool().getThreadContext().isSystemContext());
            final long newStateVersion = this.newState.version();
            if (destination.equals(this.discoveryNodes.getLocalNode())) {
                final boolean isVotingOnlyNode = this.discoveryNodes.getLocalNode().getRoles().contains(DiscoveryNodeRole.VOTING_ONLY_NODE_ROLE);
                logger.trace("handling cluster state version [{}] locally on [{}]", (Object)newStateVersion, (Object)destination);
                PublicationTransportHandler.this.transportService.getThreadPool().executor("cluster_coordination").execute(PublicationTransportHandler.this.transportService.getThreadPool().getThreadContext().preserveContext(ActionRunnable.supply(listener, new CheckedSupplier<PublishWithJoinResponse, Exception>(){

                    @Override
                    public PublishWithJoinResponse get() {
                        if (isVotingOnlyNode) {
                            throw new TransportException(new ElasticsearchException("voting-only node skipping local publication to " + String.valueOf(destination), new Object[0]));
                        }
                        return PublicationTransportHandler.this.handlePublishRequest.apply(publishRequest);
                    }

                    public String toString() {
                        return "handling cluster state version [" + newStateVersion + "] locally on [" + String.valueOf(destination) + "]";
                    }
                })));
            } else if (this.sendFullVersion || !this.previousState.nodes().nodeExists(destination)) {
                logger.trace("sending full cluster state version [{}] to [{}]", (Object)newStateVersion, (Object)destination);
                this.sendFullClusterState(destination, listener);
            } else {
                logger.trace("sending cluster state diff for version [{}] to [{}]", (Object)newStateVersion, (Object)destination);
                this.sendClusterStateDiff(destination, listener);
            }
        }

        private void sendFullClusterState(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            assert (this.refCount() > 0);
            Transport.Connection connection = this.nodeConnections.get(destination);
            if (connection == null) {
                logger.debug("No connection to [{}] available, skipping send", (Object)destination);
                listener.onFailure(new NodeNotConnectedException(destination, "No connection available"));
                return;
            }
            TransportVersion version = connection.getTransportVersion();
            ReleasableBytesReference bytes = this.serializedStates.get(version);
            if (bytes == null) {
                try {
                    bytes = this.serializedStates.computeIfAbsent(version, v -> PublicationTransportHandler.this.serializeFullClusterState(this.newState, destination, (TransportVersion)v));
                }
                catch (Exception e) {
                    logger.warn(() -> Strings.format("failed to serialize cluster state before publishing it to node %s", destination), (Throwable)e);
                    listener.onFailure(e);
                    return;
                }
            }
            this.sendClusterState(connection, bytes, listener);
        }

        private void sendClusterStateDiff(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            Transport.Connection connection = this.nodeConnections.get(destination);
            if (connection == null) {
                logger.debug("No connection to [{}] available, skipping send", (Object)destination);
                listener.onFailure(new NodeNotConnectedException(destination, "No connection available"));
                return;
            }
            ReleasableBytesReference bytes = this.serializedDiffs.get(connection.getTransportVersion());
            assert (bytes != null) : "failed to find serialized diff for node " + String.valueOf(destination) + " of version [" + connection.getTransportVersion().toReleaseVersion() + "]";
            if (!this.tryIncRef()) {
                assert (false);
                listener.onFailure(new IllegalStateException("publication context released before transmission"));
                return;
            }
            this.sendClusterState(connection, bytes, ActionListener.runAfter(listener.delegateResponse((delegate, e) -> {
                TransportException transportException;
                if (e instanceof TransportException && (transportException = (TransportException)e).unwrapCause() instanceof IncompatibleClusterStateVersionException) {
                    logger.debug(() -> Strings.format("resending full cluster state to node %s reason %s", destination, transportException.getDetailedMessage()));
                    this.sendFullClusterState(destination, (ActionListener<PublishWithJoinResponse>)delegate);
                    return;
                }
                logger.debug(() -> Strings.format("failed to send cluster state to %s", destination), (Throwable)e);
                delegate.onFailure((Exception)e);
            }), this::decRef));
        }

        private void sendClusterState(Transport.Connection connection, ReleasableBytesReference bytes, ActionListener<PublishWithJoinResponse> listener) {
            assert (this.refCount() > 0);
            if (!bytes.tryIncRef()) {
                assert (false);
                listener.onFailure(new IllegalStateException("serialized cluster state released before transmission"));
                return;
            }
            PublicationTransportHandler.this.transportService.sendChildRequest(connection, PublicationTransportHandler.PUBLISH_STATE_ACTION_NAME, (TransportRequest)new BytesTransportRequest(bytes, connection.getTransportVersion()), this.task, STATE_REQUEST_OPTIONS, new CleanableResponseHandler<PublishWithJoinResponse>(listener, PublishWithJoinResponse::new, PublicationTransportHandler.this.clusterCoordinationExecutor, bytes::decRef));
        }

        @Override
        protected void closeInternal() {
            this.serializedDiffs.values().forEach(Releasables::closeExpectNoException);
            this.serializedStates.values().forEach(Releasables::closeExpectNoException);
        }
    }
}

