/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.EstimatedHeapUsage;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.routing.ExpectedShardSizeEstimator;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ChunkedToXContent;
import org.elasticsearch.common.xcontent.ChunkedToXContentHelper;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ClusterInfo
implements ChunkedToXContent,
Writeable,
ExpectedShardSizeEstimator.ShardSizeProvider {
    public static final ClusterInfo EMPTY = new ClusterInfo();
    private static final TransportVersion HEAP_USAGE_IN_CLUSTER_INFO = TransportVersion.fromName("heap_usage_in_cluster_info");
    private static final TransportVersion NODE_USAGE_STATS_FOR_THREAD_POOLS_IN_CLUSTER_INFO = TransportVersion.fromName("node_usage_stats_for_thread_pools_in_cluster_info");
    private static final TransportVersion SHARD_WRITE_LOAD_IN_CLUSTER_INFO = TransportVersion.fromName("shard_write_load_in_cluster_info");
    private static final TransportVersion MAX_HEAP_SIZE_PER_NODE_IN_CLUSTER_INFO = TransportVersion.fromName("max_heap_size_per_node_in_cluster_info");
    private final Map<String, DiskUsage> leastAvailableSpaceUsage;
    private final Map<String, DiskUsage> mostAvailableSpaceUsage;
    final Map<String, Long> shardSizes;
    final Map<ShardId, Long> shardDataSetSizes;
    final Map<NodeAndShard, String> dataPath;
    final Map<NodeAndPath, ReservedSpace> reservedSpace;
    final Map<String, EstimatedHeapUsage> estimatedHeapUsages;
    final Map<String, NodeUsageStatsForThreadPools> nodeUsageStatsForThreadPools;
    final Map<ShardId, Double> shardWriteLoads;
    final Map<String, ByteSizeValue> maxHeapSizePerNode;

    protected ClusterInfo() {
        this(Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of(), Map.of());
    }

    public ClusterInfo(Map<String, DiskUsage> leastAvailableSpaceUsage, Map<String, DiskUsage> mostAvailableSpaceUsage, Map<String, Long> shardSizes, Map<ShardId, Long> shardDataSetSizes, Map<NodeAndShard, String> dataPath, Map<NodeAndPath, ReservedSpace> reservedSpace, Map<String, EstimatedHeapUsage> estimatedHeapUsages, Map<String, NodeUsageStatsForThreadPools> nodeUsageStatsForThreadPools, Map<ShardId, Double> shardWriteLoads, Map<String, ByteSizeValue> maxHeapSizePerNode) {
        this.leastAvailableSpaceUsage = Map.copyOf(leastAvailableSpaceUsage);
        this.mostAvailableSpaceUsage = Map.copyOf(mostAvailableSpaceUsage);
        this.shardSizes = Map.copyOf(shardSizes);
        this.shardDataSetSizes = Map.copyOf(shardDataSetSizes);
        this.dataPath = Map.copyOf(dataPath);
        this.reservedSpace = Map.copyOf(reservedSpace);
        this.estimatedHeapUsages = Map.copyOf(estimatedHeapUsages);
        this.nodeUsageStatsForThreadPools = Map.copyOf(nodeUsageStatsForThreadPools);
        this.shardWriteLoads = Map.copyOf(shardWriteLoads);
        this.maxHeapSizePerNode = Map.copyOf(maxHeapSizePerNode);
    }

    public ClusterInfo(StreamInput in) throws IOException {
        this.leastAvailableSpaceUsage = in.readImmutableMap(DiskUsage::new);
        this.mostAvailableSpaceUsage = in.readImmutableMap(DiskUsage::new);
        this.shardSizes = in.readImmutableMap(StreamInput::readLong);
        this.shardDataSetSizes = in.readImmutableMap(ShardId::new, StreamInput::readLong);
        this.dataPath = in.readImmutableMap(NodeAndShard::new, StreamInput::readString);
        this.reservedSpace = in.readImmutableMap(NodeAndPath::new, ReservedSpace::new);
        this.estimatedHeapUsages = in.getTransportVersion().supports(HEAP_USAGE_IN_CLUSTER_INFO) ? in.readImmutableMap(EstimatedHeapUsage::new) : Map.of();
        this.nodeUsageStatsForThreadPools = in.getTransportVersion().supports(NODE_USAGE_STATS_FOR_THREAD_POOLS_IN_CLUSTER_INFO) ? in.readImmutableMap(NodeUsageStatsForThreadPools::new) : Map.of();
        this.shardWriteLoads = in.getTransportVersion().supports(SHARD_WRITE_LOAD_IN_CLUSTER_INFO) ? in.readImmutableMap(ShardId::new, StreamInput::readDouble) : Map.of();
        this.maxHeapSizePerNode = in.getTransportVersion().supports(MAX_HEAP_SIZE_PER_NODE_IN_CLUSTER_INFO) ? in.readImmutableMap(ByteSizeValue::readFrom) : Map.of();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.leastAvailableSpaceUsage, StreamOutput::writeWriteable);
        out.writeMap(this.mostAvailableSpaceUsage, StreamOutput::writeWriteable);
        out.writeMap(this.shardSizes, (o, v) -> o.writeLong(v == null ? -1L : v));
        out.writeMap(this.shardDataSetSizes, StreamOutput::writeWriteable, StreamOutput::writeLong);
        out.writeMap(this.dataPath, StreamOutput::writeWriteable, StreamOutput::writeString);
        out.writeMap(this.reservedSpace);
        if (out.getTransportVersion().supports(HEAP_USAGE_IN_CLUSTER_INFO)) {
            out.writeMap(this.estimatedHeapUsages, StreamOutput::writeWriteable);
        }
        if (out.getTransportVersion().supports(NODE_USAGE_STATS_FOR_THREAD_POOLS_IN_CLUSTER_INFO)) {
            out.writeMap(this.nodeUsageStatsForThreadPools, StreamOutput::writeWriteable);
        }
        if (out.getTransportVersion().supports(SHARD_WRITE_LOAD_IN_CLUSTER_INFO)) {
            out.writeMap(this.shardWriteLoads, StreamOutput::writeWriteable, StreamOutput::writeDouble);
        }
        if (out.getTransportVersion().supports(MAX_HEAP_SIZE_PER_NODE_IN_CLUSTER_INFO)) {
            out.writeMap(this.maxHeapSizePerNode, StreamOutput::writeWriteable);
        }
    }

    private static ShardRouting createFakeShardRoutingFromNodeAndShard(NodeAndShard nodeAndShard) {
        return ShardRouting.newUnassigned(nodeAndShard.shardId, true, RecoverySource.EmptyStoreRecoverySource.INSTANCE, new UnassignedInfo(UnassignedInfo.Reason.REINITIALIZED, "fake"), ShardRouting.Role.DEFAULT).initialize(nodeAndShard.nodeId, null, 0L).moveToStarted(0L);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
        return Iterators.concat(ChunkedToXContentHelper.startObject("nodes"), Iterators.map(this.leastAvailableSpaceUsage.entrySet().iterator(), c -> (builder, p) -> {
            builder.startObject((String)c.getKey());
            builder.field("node_name", ((DiskUsage)c.getValue()).nodeName());
            builder.startObject("least_available");
            ((DiskUsage)c.getValue()).toShortXContent(builder);
            builder.endObject();
            builder.startObject("most_available");
            DiskUsage most = this.mostAvailableSpaceUsage.get(c.getKey());
            if (most != null) {
                most.toShortXContent(builder);
            }
            builder.endObject();
            return builder.endObject();
        }), ChunkedToXContentHelper.chunk((builder, p) -> builder.endObject().startObject("shard_sizes")), Iterators.map(this.shardSizes.entrySet().iterator(), c -> (builder, p) -> builder.humanReadableField((String)c.getKey() + "_bytes", (String)c.getKey(), ByteSizeValue.ofBytes((Long)c.getValue()))), ChunkedToXContentHelper.chunk((builder, p) -> builder.endObject().startObject("shard_data_set_sizes")), Iterators.map(this.shardDataSetSizes.entrySet().iterator(), c -> (builder, p) -> builder.humanReadableField(String.valueOf(c.getKey()) + "_bytes", ((ShardId)c.getKey()).toString(), ByteSizeValue.ofBytes((Long)c.getValue()))), ChunkedToXContentHelper.chunk((builder, p) -> builder.endObject().startObject("shard_paths")), Iterators.map(this.dataPath.entrySet().iterator(), c -> (builder, p) -> builder.field(((NodeAndShard)c.getKey()).toString(), (String)c.getValue())), ChunkedToXContentHelper.chunk((builder, p) -> builder.endObject().startArray("reserved_sizes")), Iterators.map(this.reservedSpace.entrySet().iterator(), c -> (builder, p) -> {
            builder.startObject();
            builder.field("node_id", ((NodeAndPath)c.getKey()).nodeId);
            builder.field("path", ((NodeAndPath)c.getKey()).path);
            ((ReservedSpace)c.getValue()).toXContent(builder, params);
            return builder.endObject();
        }), ChunkedToXContentHelper.endArray());
    }

    public Map<String, EstimatedHeapUsage> getEstimatedHeapUsages() {
        return this.estimatedHeapUsages;
    }

    public Map<String, NodeUsageStatsForThreadPools> getNodeUsageStatsForThreadPools() {
        return this.nodeUsageStatsForThreadPools;
    }

    public Map<String, DiskUsage> getNodeLeastAvailableDiskUsages() {
        return this.leastAvailableSpaceUsage;
    }

    public Map<String, DiskUsage> getNodeMostAvailableDiskUsages() {
        return this.mostAvailableSpaceUsage;
    }

    public Map<ShardId, Double> getShardWriteLoads() {
        return this.shardWriteLoads;
    }

    @Override
    public Long getShardSize(ShardId shardId, boolean primary) {
        return this.shardSizes.get(ClusterInfo.shardIdentifierFromRouting(shardId, primary));
    }

    public String getDataPath(ShardRouting shardRouting) {
        return this.dataPath.get(NodeAndShard.from(shardRouting));
    }

    public String getDataPath(NodeAndShard nodeAndShard) {
        return this.dataPath.get(nodeAndShard);
    }

    public Optional<Long> getShardDataSetSize(ShardId shardId) {
        return Optional.ofNullable(this.shardDataSetSizes.get(shardId));
    }

    public ReservedSpace getReservedSpace(String nodeId, String dataPath) {
        ReservedSpace result = this.reservedSpace.get(new NodeAndPath(nodeId, dataPath));
        return result == null ? ReservedSpace.EMPTY : result;
    }

    public Map<String, ByteSizeValue> getMaxHeapSizePerNode() {
        return this.maxHeapSizePerNode;
    }

    public static String shardIdentifierFromRouting(ShardRouting shardRouting) {
        return ClusterInfo.shardIdentifierFromRouting(shardRouting.shardId(), shardRouting.primary());
    }

    public static String shardIdentifierFromRouting(ShardId shardId, boolean primary) {
        return shardId.toString() + "[" + (primary ? "p" : "r") + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        return this.leastAvailableSpaceUsage.equals(that.leastAvailableSpaceUsage) && this.mostAvailableSpaceUsage.equals(that.mostAvailableSpaceUsage) && this.shardSizes.equals(that.shardSizes) && this.shardDataSetSizes.equals(that.shardDataSetSizes) && this.dataPath.equals(that.dataPath) && this.reservedSpace.equals(that.reservedSpace) && this.estimatedHeapUsages.equals(that.estimatedHeapUsages) && this.nodeUsageStatsForThreadPools.equals(that.nodeUsageStatsForThreadPools) && this.shardWriteLoads.equals(that.shardWriteLoads) && this.maxHeapSizePerNode.equals(that.maxHeapSizePerNode);
    }

    public int hashCode() {
        return Objects.hash(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes, this.shardDataSetSizes, this.dataPath, this.reservedSpace, this.estimatedHeapUsages, this.nodeUsageStatsForThreadPools, this.shardWriteLoads, this.maxHeapSizePerNode);
    }

    public String toString() {
        return Strings.toString(this, true, false);
    }

    int getChunkCount() {
        return this.leastAvailableSpaceUsage.size() + this.shardSizes.size() + this.shardDataSetSizes.size() + this.dataPath.size() + this.reservedSpace.size() + 6;
    }

    public static Builder builder() {
        return new Builder();
    }

    public record NodeAndShard(String nodeId, ShardId shardId) implements Writeable
    {
        public NodeAndShard {
            Objects.requireNonNull(nodeId);
            Objects.requireNonNull(shardId);
        }

        public NodeAndShard(StreamInput in) throws IOException {
            this(in.readString(), new ShardId(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            this.shardId.writeTo(out);
        }

        public static NodeAndShard from(ShardRouting shardRouting) {
            return new NodeAndShard(shardRouting.currentNodeId(), shardRouting.shardId());
        }
    }

    public record NodeAndPath(String nodeId, String path) implements Writeable
    {
        public NodeAndPath {
            Objects.requireNonNull(nodeId);
            Objects.requireNonNull(path);
        }

        public NodeAndPath(StreamInput in) throws IOException {
            this(in.readString(), in.readString());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeId);
            out.writeString(this.path);
        }
    }

    public record ReservedSpace(long total, Set<ShardId> shardIds) implements Writeable
    {
        public static final ReservedSpace EMPTY = new ReservedSpace(0L, new HashSet<ShardId>());

        ReservedSpace(StreamInput in) throws IOException {
            this(in.readVLong(), in.readCollectionAsSet(ShardId::new));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.total);
            out.writeCollection(this.shardIds);
        }

        public boolean containsShardId(ShardId shardId) {
            return this.shardIds.contains(shardId);
        }

        void toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("total", this.total);
            builder.startArray("shards");
            for (ShardId shardIdCursor : this.shardIds) {
                shardIdCursor.toXContent(builder, params);
            }
            builder.endArray();
        }

        public static class Builder {
            private long total;
            private HashSet<ShardId> shardIds = new HashSet();

            public ReservedSpace build() {
                assert (this.shardIds != null) : "already built";
                ReservedSpace reservedSpace = new ReservedSpace(this.total, this.shardIds);
                this.shardIds = null;
                return reservedSpace;
            }

            public Builder add(ShardId shardId, long reservedBytes) {
                assert (this.shardIds != null) : "already built";
                assert (reservedBytes >= 0L) : reservedBytes;
                this.shardIds.add(shardId);
                this.total += reservedBytes;
                return this;
            }
        }
    }

    public static class Builder {
        private Map<String, DiskUsage> leastAvailableSpaceUsage = Map.of();
        private Map<String, DiskUsage> mostAvailableSpaceUsage = Map.of();
        private Map<String, Long> shardSizes = Map.of();
        private Map<ShardId, Long> shardDataSetSizes = Map.of();
        private Map<NodeAndShard, String> dataPath = Map.of();
        private Map<NodeAndPath, ReservedSpace> reservedSpace = Map.of();
        private Map<String, EstimatedHeapUsage> estimatedHeapUsages = Map.of();
        private Map<String, NodeUsageStatsForThreadPools> nodeUsageStatsForThreadPools = Map.of();
        private Map<ShardId, Double> shardWriteLoads = Map.of();
        private Map<String, ByteSizeValue> maxHeapSizePerNode = Map.of();

        public ClusterInfo build() {
            return new ClusterInfo(this.leastAvailableSpaceUsage, this.mostAvailableSpaceUsage, this.shardSizes, this.shardDataSetSizes, this.dataPath, this.reservedSpace, this.estimatedHeapUsages, this.nodeUsageStatsForThreadPools, this.shardWriteLoads, this.maxHeapSizePerNode);
        }

        public Builder leastAvailableSpaceUsage(Map<String, DiskUsage> leastAvailableSpaceUsage) {
            this.leastAvailableSpaceUsage = leastAvailableSpaceUsage;
            return this;
        }

        public Builder mostAvailableSpaceUsage(Map<String, DiskUsage> mostAvailableSpaceUsage) {
            this.mostAvailableSpaceUsage = mostAvailableSpaceUsage;
            return this;
        }

        public Builder shardSizes(Map<String, Long> shardSizes) {
            this.shardSizes = shardSizes;
            return this;
        }

        public Builder shardDataSetSizes(Map<ShardId, Long> shardDataSetSizes) {
            this.shardDataSetSizes = shardDataSetSizes;
            return this;
        }

        public Builder dataPath(Map<NodeAndShard, String> dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public Builder reservedSpace(Map<NodeAndPath, ReservedSpace> reservedSpace) {
            this.reservedSpace = reservedSpace;
            return this;
        }

        public Builder estimatedHeapUsages(Map<String, EstimatedHeapUsage> estimatedHeapUsages) {
            this.estimatedHeapUsages = estimatedHeapUsages;
            return this;
        }

        public Builder nodeUsageStatsForThreadPools(Map<String, NodeUsageStatsForThreadPools> nodeUsageStatsForThreadPools) {
            this.nodeUsageStatsForThreadPools = nodeUsageStatsForThreadPools;
            return this;
        }

        public Builder shardWriteLoads(Map<ShardId, Double> shardWriteLoads) {
            this.shardWriteLoads = shardWriteLoads;
            return this;
        }

        public Builder maxHeapSizePerNode(Map<String, ByteSizeValue> maxHeapSizePerNode) {
            this.maxHeapSizePerNode = maxHeapSizePerNode;
            return this;
        }
    }
}

