/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.datastreams;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ChunkedToXContentObject;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;

public class UpdateDataStreamMappingsAction
extends ActionType<Response> {
    public static final String NAME = "indices:admin/data_stream/mappings/update";
    public static final UpdateDataStreamMappingsAction INSTANCE = new UpdateDataStreamMappingsAction();

    public UpdateDataStreamMappingsAction() {
        super(NAME);
    }

    public record DataStreamMappingsResponse(String dataStreamName, boolean dataStreamSucceeded, String dataStreamErrorMessage, CompressedXContent mappings, CompressedXContent effectiveMappings) implements ToXContent,
    Writeable
    {
        public DataStreamMappingsResponse(StreamInput in) throws IOException {
            this(in.readString(), in.readBoolean(), in.readOptionalString(), CompressedXContent.readCompressedString(in), CompressedXContent.readCompressedString(in));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.dataStreamName);
            out.writeBoolean(this.dataStreamSucceeded);
            out.writeOptionalString(this.dataStreamErrorMessage);
            this.mappings.writeTo(out);
            this.effectiveMappings.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            Map<String, Object> uncompressedEffectiveMappings;
            Map<String, Object> uncompressedMappings;
            builder.startObject();
            builder.field("name", this.dataStreamName);
            builder.field("applied_to_data_stream", this.dataStreamSucceeded);
            if (this.dataStreamErrorMessage != null) {
                builder.field("error", this.dataStreamErrorMessage);
            }
            if (!(uncompressedMappings = XContentHelper.convertToMap(this.mappings.uncompressed(), true, XContentType.JSON).v2()).isEmpty()) {
                builder.field("mappings");
                builder.map(uncompressedMappings);
            }
            if (!(uncompressedEffectiveMappings = XContentHelper.convertToMap(this.effectiveMappings.uncompressed(), true, XContentType.JSON).v2()).isEmpty()) {
                builder.field("effective_mappings");
                builder.map(uncompressedEffectiveMappings);
            }
            builder.endObject();
            return builder;
        }
    }

    public static class Response
    extends ActionResponse
    implements ChunkedToXContentObject {
        private final List<DataStreamMappingsResponse> dataStreamMappingsResponses;

        public Response(List<DataStreamMappingsResponse> dataStreamMappingsResponses) {
            this.dataStreamMappingsResponses = dataStreamMappingsResponses;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readCollectionAsList(DataStreamMappingsResponse::new));
        }

        public List<DataStreamMappingsResponse> getDataStreamMappingsResponses() {
            return this.dataStreamMappingsResponses;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.dataStreamMappingsResponses, (out1, value) -> value.writeTo(out1));
        }

        @Override
        public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params params) {
            return Iterators.concat(Iterators.single((builder, params1) -> builder.startObject().startArray("data_streams")), this.dataStreamMappingsResponses.stream().map(dataStreamMappingsResponse -> dataStreamMappingsResponse).iterator(), Iterators.single((builder, params1) -> builder.endArray().endObject()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.dataStreamMappingsResponses, response.dataStreamMappingsResponses);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreamMappingsResponses);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements IndicesRequest.Replaceable {
        private final CompressedXContent mappings;
        private final boolean dryRun;
        private String[] dataStreamNames = Strings.EMPTY_ARRAY;

        public Request(CompressedXContent mappings, boolean dryRun, TimeValue masterNodeTimeout, TimeValue ackTimeout) {
            super(masterNodeTimeout, ackTimeout);
            this.mappings = mappings;
            this.dryRun = dryRun;
        }

        @Override
        public Request indices(String ... dataStreamNames) {
            this.dataStreamNames = dataStreamNames;
            return this;
        }

        public CompressedXContent getMappings() {
            return this.mappings;
        }

        @Override
        public boolean includeDataStreams() {
            return true;
        }

        public boolean isDryRun() {
            return this.dryRun;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.dataStreamNames = in.readStringArray();
            this.mappings = CompressedXContent.readCompressedString(in);
            this.dryRun = in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.dataStreamNames);
            this.mappings.writeTo(out);
            out.writeBoolean(this.dryRun);
        }

        @Override
        public String[] indices() {
            return this.dataStreamNames;
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED;
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)o;
            return Arrays.equals(this.dataStreamNames, request.dataStreamNames) && this.mappings.equals(request.mappings) && this.dryRun == request.dryRun && Objects.equals(this.masterNodeTimeout(), request.masterNodeTimeout()) && Objects.equals(this.ackTimeout(), request.ackTimeout());
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.dataStreamNames), this.mappings, this.dryRun, this.masterNodeTimeout(), this.ackTimeout());
        }
    }
}

