/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JobForecastStatistics
implements JsonpSerializable {
    @Nullable
    private final JobStatistics memoryBytes;
    @Nullable
    private final JobStatistics processingTimeMs;
    @Nullable
    private final JobStatistics records;
    private final Map<String, Long> status;
    private final long total;
    private final int forecastedJobs;
    public static final JsonpDeserializer<JobForecastStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JobForecastStatistics::setupJobForecastStatisticsDeserializer);

    private JobForecastStatistics(Builder builder) {
        this.memoryBytes = builder.memoryBytes;
        this.processingTimeMs = builder.processingTimeMs;
        this.records = builder.records;
        this.status = ApiTypeHelper.unmodifiable(builder.status);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
        this.forecastedJobs = ApiTypeHelper.requireNonNull(builder.forecastedJobs, (Object)this, "forecastedJobs", 0);
    }

    public static JobForecastStatistics of(Function<Builder, ObjectBuilder<JobForecastStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final JobStatistics memoryBytes() {
        return this.memoryBytes;
    }

    @Nullable
    public final JobStatistics processingTimeMs() {
        return this.processingTimeMs;
    }

    @Nullable
    public final JobStatistics records() {
        return this.records;
    }

    public final Map<String, Long> status() {
        return this.status;
    }

    public final long total() {
        return this.total;
    }

    public final int forecastedJobs() {
        return this.forecastedJobs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.memoryBytes != null) {
            generator.writeKey("memory_bytes");
            this.memoryBytes.serialize(generator, mapper);
        }
        if (this.processingTimeMs != null) {
            generator.writeKey("processing_time_ms");
            this.processingTimeMs.serialize(generator, mapper);
        }
        if (this.records != null) {
            generator.writeKey("records");
            this.records.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.status)) {
            generator.writeKey("status");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.status.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("forecasted_jobs");
        generator.write(this.forecastedJobs);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupJobForecastStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::memoryBytes, JobStatistics._DESERIALIZER, "memory_bytes");
        op.add(Builder::processingTimeMs, JobStatistics._DESERIALIZER, "processing_time_ms");
        op.add(Builder::records, JobStatistics._DESERIALIZER, "records");
        op.add(Builder::status, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "status");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::forecastedJobs, JsonpDeserializer.integerDeserializer(), "forecasted_jobs");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JobForecastStatistics> {
        @Nullable
        private JobStatistics memoryBytes;
        @Nullable
        private JobStatistics processingTimeMs;
        @Nullable
        private JobStatistics records;
        @Nullable
        private Map<String, Long> status;
        private Long total;
        private Integer forecastedJobs;

        public final Builder memoryBytes(@Nullable JobStatistics value) {
            this.memoryBytes = value;
            return this;
        }

        public final Builder memoryBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.memoryBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder processingTimeMs(@Nullable JobStatistics value) {
            this.processingTimeMs = value;
            return this;
        }

        public final Builder processingTimeMs(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.processingTimeMs(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder records(@Nullable JobStatistics value) {
            this.records = value;
            return this;
        }

        public final Builder records(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.records(fn.apply(new JobStatistics.Builder()).build());
        }

        public final Builder status(Map<String, Long> map) {
            this.status = Builder._mapPutAll(this.status, map);
            return this;
        }

        public final Builder status(String key, Long value) {
            this.status = Builder._mapPut(this.status, key, value);
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder forecastedJobs(int value) {
            this.forecastedJobs = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JobForecastStatistics build() {
            this._checkSingleUse();
            return new JobForecastStatistics(this);
        }
    }
}

