/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.HistogramMergeOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.LastOverTime;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.expression.function.grouping.Bucket;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.ChangePoint;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.Limit;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.MvExpand;
import org.elasticsearch.xpack.esql.plan.logical.OrderBy;
import org.elasticsearch.xpack.esql.plan.logical.join.LookupJoin;

public class TimeSeriesAggregate
extends Aggregate {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "TimeSeriesAggregate", TimeSeriesAggregate::new);
    private final Bucket timeBucket;

    public TimeSeriesAggregate(Source source, LogicalPlan child, List<Expression> groupings, List<? extends NamedExpression> aggregates, Bucket timeBucket) {
        super(source, child, groupings, aggregates);
        this.timeBucket = timeBucket;
    }

    public TimeSeriesAggregate(StreamInput in) throws IOException {
        super(in);
        this.timeBucket = (Bucket)in.readOptionalWriteable(inp -> (Bucket)Bucket.ENTRY.reader.read(inp));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.timeBucket);
    }

    @Override
    public String getWriteableName() {
        return TimeSeriesAggregate.ENTRY.name;
    }

    protected NodeInfo<Aggregate> info() {
        return NodeInfo.create((Node)this, TimeSeriesAggregate::new, (Object)((Object)this.child()), (Object)this.groupings, (Object)this.aggregates, (Object)this.timeBucket);
    }

    @Override
    public TimeSeriesAggregate replaceChild(LogicalPlan newChild) {
        return new TimeSeriesAggregate(this.source(), newChild, this.groupings, this.aggregates, this.timeBucket);
    }

    @Override
    public TimeSeriesAggregate with(LogicalPlan child, List<Expression> newGroupings, List<? extends NamedExpression> newAggregates) {
        return new TimeSeriesAggregate(this.source(), child, newGroupings, newAggregates, this.timeBucket);
    }

    @Override
    public boolean expressionsResolved() {
        return super.expressionsResolved() && (this.timeBucket == null || this.timeBucket.resolved());
    }

    @Nullable
    public Bucket timeBucket() {
        return this.timeBucket;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.groupings, this.aggregates, this.child(), this.timeBucket});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesAggregate other = (TimeSeriesAggregate)obj;
        return Objects.equals(this.groupings, other.groupings) && Objects.equals(this.aggregates, other.aggregates) && Objects.equals((Object)this.child(), (Object)other.child()) && Objects.equals(this.timeBucket, other.timeBucket);
    }

    @Override
    public void postAnalysisVerification(Failures failures) {
        super.postAnalysisVerification(failures);
        this.groupings().forEach(g -> g.forEachDown(e -> {
            FieldAttribute fieldAttr;
            if (e instanceof FieldAttribute && (fieldAttr = (FieldAttribute)e).isMetric()) {
                failures.add(Failure.fail(fieldAttr, "cannot group by a metric field [{}] in a time-series aggregation. If you want to group by a metric field, use the FROM command instead of the TS command.", new Object[]{fieldAttr.sourceText()}));
            }
        }));
        this.child().forEachDown(p -> {
            if (p instanceof OrderBy) {
                OrderBy orderBy = (OrderBy)p;
                failures.add(Failure.fail(orderBy, "sorting [{}] between the time-series source and the first aggregation [{}] is not allowed", orderBy.sourceText(), this.sourceText()));
            }
            if (p instanceof Limit) {
                Limit limit = (Limit)p;
                failures.add(Failure.fail(limit, "limiting [{}] the time-series source before the first aggregation [{}] is not allowed; filter data with a WHERE command instead", limit.sourceText(), this.sourceText()));
            }
            if (p instanceof LookupJoin) {
                LookupJoin lookupJoin = (LookupJoin)p;
                failures.add(Failure.fail(lookupJoin, "lookup join [{}] in the time-series before the first aggregation [{}] is not allowed", lookupJoin.sourceText(), this.sourceText()));
            }
            if (p instanceof Enrich) {
                Enrich enrich = (Enrich)p;
                failures.add(Failure.fail(enrich, "enrich [{}] in the time-series before the first aggregation [{}] is not allowed", enrich.sourceText(), this.sourceText()));
            }
            if (p instanceof ChangePoint) {
                ChangePoint changePoint = (ChangePoint)p;
                failures.add(Failure.fail(changePoint, "change_point [{}] in the time-series the first aggregation [{}] is not allowed", changePoint.sourceText(), this.sourceText()));
            }
            if (p instanceof MvExpand) {
                MvExpand mvExpand = (MvExpand)p;
                failures.add(Failure.fail(mvExpand, "mv_expand [{}] in the time-series before the first aggregation [{}] is not allowed", mvExpand.sourceText(), this.sourceText()));
            }
        });
    }

    @Override
    protected void checkTimeSeriesAggregates(Failures failures) {
        for (NamedExpression aggregate : this.aggregates) {
            Expression field;
            TimeSeriesAggregateFunction overTimeAgg;
            Count count;
            Alias alias;
            Expression expression;
            if (!(aggregate instanceof Alias) || !((expression = Alias.unwrap((Expression)(alias = (Alias)aggregate))) instanceof AggregateFunction)) continue;
            AggregateFunction outer = (AggregateFunction)expression;
            if (outer instanceof Count && (count = (Count)outer).field().foldable()) {
                failures.add(Failure.fail(count, "count_star [{}] can't be used with TS command; use count on a field instead", new Object[]{outer.sourceText()}));
            } else if (!(outer instanceof TimeSeriesAggregateFunction) && !(outer.field() instanceof AggregateFunction) && (overTimeAgg = (field = outer.field()).dataType() == DataType.EXPONENTIAL_HISTOGRAM ? new HistogramMergeOverTime(this.source(), field, (Expression)Literal.TRUE, (Expression)AggregateFunction.NO_WINDOW) : new LastOverTime(this.source(), field, (Expression)AggregateFunction.NO_WINDOW, (Expression)new Literal(this.source(), null, DataType.DATETIME))).typeResolved() != Expression.TypeResolution.TYPE_RESOLVED) {
                failures.add(Failure.fail(this, "implicit time-series aggregation function [{}] generated from [{}] doesn't support type [{}], only numeric types are supported; use the FROM command instead of the TS command", outer.sourceText().replace(field.sourceText(), "last_over_time(" + field.sourceText() + ")"), outer.sourceText(), field.dataType().typeName()));
            }
            outer.field().forEachDown(AggregateFunction.class, nested -> {
                if (!(nested instanceof TimeSeriesAggregateFunction)) {
                    Failure.fail(this, "cannot use aggregate function [{}] inside aggregation function [{}];only time-series aggregation function can be used inside another aggregation function", nested.sourceText(), outer.sourceText());
                }
                nested.field().forEachDown(AggregateFunction.class, nested2 -> failures.add(Failure.fail(this, "cannot use aggregate function [{}] inside over-time aggregation function [{}]", nested.sourceText(), nested2.sourceText())));
            });
        }
    }
}

