/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.ClampMin;

public final class ClampMinDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ClampMinDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator field;
    private final EvalOperator.ExpressionEvaluator min;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ClampMinDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator field, EvalOperator.ExpressionEvaluator min, DriverContext driverContext) {
        this.source = source;
        this.field = field;
        this.min = min;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (DoubleBlock fieldBlock = (DoubleBlock)this.field.eval(page);){
            DoubleBlock doubleBlock;
            block20: {
                DoubleVector minVector;
                DoubleVector fieldVector;
                DoubleBlock minBlock;
                block18: {
                    DoubleBlock doubleBlock2;
                    block19: {
                        block16: {
                            DoubleBlock doubleBlock3;
                            block17: {
                                minBlock = (DoubleBlock)this.min.eval(page);
                                try {
                                    fieldVector = fieldBlock.asVector();
                                    if (fieldVector != null) break block16;
                                    doubleBlock3 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                                    if (minBlock == null) break block17;
                                }
                                catch (Throwable throwable) {
                                    if (minBlock != null) {
                                        try {
                                            minBlock.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                minBlock.close();
                            }
                            return doubleBlock3;
                        }
                        minVector = minBlock.asVector();
                        if (minVector != null) break block18;
                        doubleBlock2 = this.eval(page.getPositionCount(), fieldBlock, minBlock);
                        if (minBlock == null) break block19;
                        minBlock.close();
                    }
                    return doubleBlock2;
                }
                doubleBlock = this.eval(page.getPositionCount(), fieldVector, minVector).asBlock();
                if (minBlock == null) break block20;
                minBlock.close();
            }
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        baseRamBytesUsed += this.field.baseRamBytesUsed();
        return baseRamBytesUsed += this.min.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, DoubleBlock fieldBlock, DoubleBlock minBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block13: for (int p = 0; p < positionCount; ++p) {
                switch (fieldBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                switch (minBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block13;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block13;
                    }
                }
                double field = fieldBlock.getDouble(fieldBlock.getFirstValueIndex(p));
                double min = minBlock.getDouble(minBlock.getFirstValueIndex(p));
                result.appendDouble(ClampMin.process(field, min));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, DoubleVector fieldVector, DoubleVector minVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                double field = fieldVector.getDouble(p);
                double min = minVector.getDouble(p);
                result.appendDouble(p, ClampMin.process(field, min));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "ClampMinDoubleEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.field, this.min});
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory field;
        private final EvalOperator.ExpressionEvaluator.Factory min;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory field, EvalOperator.ExpressionEvaluator.Factory min) {
            this.source = source;
            this.field = field;
            this.min = min;
        }

        public ClampMinDoubleEvaluator get(DriverContext context) {
            return new ClampMinDoubleEvaluator(this.source, this.field.get(context), this.min.get(context), context);
        }

        public String toString() {
            return "ClampMinDoubleEvaluator[field=" + String.valueOf(this.field) + ", min=" + String.valueOf(this.min) + "]";
        }
    }
}

