/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.fulltext;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FieldAttribute;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.expression.Foldables;
import org.elasticsearch.xpack.esql.expression.function.Options;
import org.elasticsearch.xpack.esql.expression.function.fulltext.FullTextFunction;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.type.EsqlDataTypeConverter;

public abstract class SingleFieldFullTextFunction
extends FullTextFunction
implements PostAnalysisPlanVerificationAware,
PostOptimizationPlanVerificationAware {
    protected final Expression field;
    private final transient Expression options;

    protected SingleFieldFullTextFunction(Source source, Expression field, Expression query, Expression options, List<Expression> children, QueryBuilder queryBuilder) {
        super(source, query, children, queryBuilder);
        this.field = field;
        this.options = options;
    }

    public Expression field() {
        return this.field;
    }

    public Expression options() {
        return this.options;
    }

    @Override
    protected Expression.TypeResolution resolveParams() {
        return this.resolveField().and(this.resolveQuery()).and(this.resolveOptions());
    }

    protected Expression.TypeResolution resolveField() {
        return TypeResolutions.isType((Expression)this.field, this.getFieldDataTypes()::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{this.expectedFieldTypesString()});
    }

    protected Expression.TypeResolution resolveQuery() {
        Expression.TypeResolution result = TypeResolutions.isType((Expression)this.query(), this.getQueryDataTypes()::contains, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND, (String[])new String[]{this.expectedQueryTypesString()}).and(TypeResolutions.isNotNull((Expression)this.query(), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
        if (result.unresolved()) {
            return result;
        }
        return Foldables.resolveTypeQuery(this.query(), this.sourceText(), Foldables.TypeResolutionValidator.forPreOptimizationValidation(this.query()));
    }

    protected Expression.TypeResolution resolveOptions() {
        if (this.options() == null) {
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return Options.resolve(this.options(), this.source(), TypeResolutions.ParamOrdinal.THIRD, this.getAllowedOptions());
    }

    protected Object queryAsObject() {
        Object queryAsObject = Foldables.queryAsObject(this.query(), this.sourceText());
        if (queryAsObject instanceof BytesRef) {
            BytesRef bytesRef = (BytesRef)queryAsObject;
            return switch (this.query().dataType()) {
                case DataType.IP -> EsqlDataTypeConverter.ipToString(bytesRef);
                case DataType.VERSION -> EsqlDataTypeConverter.versionToString(bytesRef);
                default -> bytesRef.utf8ToString();
            };
        }
        if (this.query().dataType() == DataType.UNSIGNED_LONG) {
            return NumericUtils.unsignedLongAsBigInteger((long)((Long)queryAsObject));
        }
        if (this.query().dataType() == DataType.DATETIME && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.dateTimeToString((Long)queryAsObject);
        }
        if (this.query().dataType() == DataType.DATE_NANOS && queryAsObject instanceof Long) {
            return EsqlDataTypeConverter.nanoTimeToString((Long)queryAsObject);
        }
        return queryAsObject;
    }

    protected FieldAttribute fieldAsFieldAttribute() {
        return this.fieldAsFieldAttribute(this.field);
    }

    public boolean foldable() {
        return Expressions.isGuaranteedNull((Expression)this.field());
    }

    public Object fold(FoldContext ctx) {
        return null;
    }

    @Override
    public Nullability nullable() {
        return this.field().nullable();
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return (plan, failures) -> {
            super.postAnalysisPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            this.fieldVerifier((LogicalPlan)((Object)plan), this, this.field, (Failures)failures);
        };
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postOptimizationPlanVerification() {
        return (plan, failures) -> {
            super.postOptimizationPlanVerification().accept((LogicalPlan)((Object)plan), (Failures)failures);
            this.fieldVerifier((LogicalPlan)((Object)plan), this, this.field, (Failures)failures);
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFieldFullTextFunction that = (SingleFieldFullTextFunction)o;
        return Objects.equals(this.field(), that.field()) && Objects.equals(this.query(), that.query()) && Objects.equals(this.queryBuilder(), that.queryBuilder());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field(), this.query(), this.queryBuilder());
    }

    protected abstract Set<DataType> getFieldDataTypes();

    protected abstract Set<DataType> getQueryDataTypes();

    protected abstract Map<String, DataType> getAllowedOptions();

    protected String expectedFieldTypesString() {
        return SingleFieldFullTextFunction.expectedTypesAsString(this.getFieldDataTypes());
    }

    protected String expectedQueryTypesString() {
        return SingleFieldFullTextFunction.expectedTypesAsString(this.getQueryDataTypes());
    }

    static String expectedTypesAsString(Set<DataType> dataTypes) {
        return String.join((CharSequence)", ", dataTypes.stream().map(dt -> dt.name().toLowerCase(Locale.ROOT)).toList());
    }
}

